/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.internal.ui;

import com.tssap.selena.gde.internal.Messages;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.preferences.PreferencesPlugin;
import com.tssap.selena.model.util.UndoTransparableCommand;
import com.tssap.selena.model.view.View;
import com.tssap.selena.model.view.ViewAccess;
import com.tssap.selena.model.view.ViewManager;
import com.tssap.selena.ui.prefpages.FieldEditorPreferenceTabPage;
import java.util.Enumeration;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FontFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;

public class GridPreferencePage
extends FieldEditorPreferenceTabPage {
    private static final String DIAGRAM_FONT_PROPERTY = "diagramFont";
    private int myClassWidth;
    private FontData myFontData;
    private boolean myTabPositions;
    private static Font myBoldFont;

    public GridPreferencePage() {
        super(0);
        this.initDefaults();
    }

    public void init(IWorkbench workbench) {
    }

    protected void initDefaults() {
        IPreferenceStore store = this.doGetPreferenceStore();
        FontData defaultFontData = JFaceResources.getDefaultFont().getFontData()[0];
        String locale = BootLoader.getNL();
        if (locale != null && locale.toLowerCase().startsWith("en")) {
            defaultFontData = new FontData("MS Sans Serif", defaultFontData.getHeight(), defaultFontData.getStyle());
        }
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)DIAGRAM_FONT_PROPERTY, (FontData)defaultFontData);
    }

    protected void createFieldEditors() {
        Composite composite = this.getFieldEditorParent();
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        Composite fontsGroup = this.createGroup(composite, Messages.getString("GridPreferencePage.Font"));
        FontFieldEditor fontEditor = new FontFieldEditor(DIAGRAM_FONT_PROPERTY, Messages.getString("GridPreferencePage.Diagram_Font_Label"), Messages.getString("GridPreferencePage.Text_Preview"), fontsGroup);
        this.addField((FieldEditor)fontEditor);
        Control textControl = fontEditor.getPreviewControl();
        GridData data = new GridData(768);
        data.horizontalSpan = 3;
        data.heightHint = 32;
        textControl.setLayoutData((Object)data);
        this.myFontData = PreferenceConverter.getFontData((IPreferenceStore)this.getPreferenceStore(), (String)DIAGRAM_FONT_PROPERTY);
        Group group = new Group(composite, 0);
        group.setText(Messages.getString("GridPreferencePage.Grid_options"));
        group.setLayout((Layout)new GridLayout(2, true));
        group.setLayoutData((Object)new GridData(768));
        Composite gridOptnComp = new Composite((Composite)group, 0);
        Composite gridSizeComp = new Composite((Composite)group, 0);
        this.addField((FieldEditor)new BooleanFieldEditor("show_grid", Messages.getString("GridPreferencePage.Show_grid"), gridOptnComp));
        this.addField((FieldEditor)new BooleanFieldEditor("snap_to_grid", Messages.getString("GridPreferencePage.Snap_to_grid"), gridOptnComp));
        IntegerFieldEditor intEditor = new IntegerFieldEditor("grid_width", Messages.getString("GridPreferencePage.Grid_width"), gridSizeComp);
        this.addField((FieldEditor)intEditor);
        data = new GridData();
        data.horizontalIndent = 9;
        intEditor.getLabelControl(gridSizeComp).setLayoutData((Object)data);
        data = (GridData)intEditor.getTextControl(gridSizeComp).getLayoutData();
        data.horizontalAlignment = 32;
        data.widthHint = this.convertWidthInCharsToPixels(5);
        intEditor = new IntegerFieldEditor("grid_height", Messages.getString("GridPreferencePage.Grid_height"), gridSizeComp);
        this.addField((FieldEditor)intEditor);
        data = new GridData();
        data.horizontalIndent = 9;
        intEditor.getLabelControl(gridSizeComp).setLayoutData((Object)data);
        data = (GridData)intEditor.getTextControl(gridSizeComp).getLayoutData();
        data.horizontalAlignment = 32;
        data.widthHint = this.convertWidthInCharsToPixels(5);
        group = new Group(composite, 0);
        group.setText(Messages.getString("GridPreferencePage.Layout_Options"));
        group.setLayout((Layout)new GridLayout(1, true));
        group.setLayoutData((Object)new GridData(768));
        Composite widthComp = new Composite((Composite)group, 0);
        IntegerFieldEditor editor = new IntegerFieldEditor("class_width", Messages.getString("GridPreferencePage.Maximum_width_of_class_element"), widthComp);
        ((GridLayout)widthComp.getLayout()).makeColumnsEqualWidth = true;
        data = new GridData();
        data.horizontalIndent = 9;
        data.widthHint = this.convertWidthInCharsToPixels(5);
        editor.getTextControl(widthComp).setData((Object)data);
        data = new GridData();
        data.horizontalIndent = 9;
        data.widthHint = this.convertWidthInCharsToPixels(5);
        editor.getLabelControl(widthComp).setData((Object)data);
        this.addField((FieldEditor)editor);
        this.myClassWidth = this.getPreferenceStore().getInt("class_width");
        RadioGroupFieldEditor radio = new RadioGroupFieldEditor("tab_placement", Messages.getString("GridPreferencePage.Tab_Placement"), 1, (String[][])new String[][]{{Messages.getString("GridPreferencePage.Tab_Placement.Top"), "top"}, {Messages.getString("GridPreferencePage.Tab_Placement.Bottom"), "bottom"}}, composite, true);
        this.addField((FieldEditor)radio);
        Composite labelComposite = new Composite(composite, 0);
        labelComposite.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(labelComposite, 1);
        label.setFont(GridPreferencePage.getBoldFont((Device)composite.getDisplay(), label.getFont()));
        label.setText(Messages.getString("GridPreferencePage.Tab_Placement.Note"));
        label = new Label(labelComposite, 0);
        label.setText(Messages.getString("GridPreferencePage.Tab_Placement.TopNote"));
        label = new Label(labelComposite, 0);
        label = new Label(labelComposite, 0);
        label.setText(Messages.getString("GridPreferencePage.Tab_Placement.BottomNote"));
    }

    private Composite createGroup(Composite parent, String name) {
        Group group = new Group(parent, 0);
        group.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        group.setText(name);
        Composite result = new Composite((Composite)group, 0);
        result.setLayoutData((Object)new GridData(1808));
        return result;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return PreferencesPlugin.getPreferenceStore((String)"workspace", null);
    }

    public boolean performOk() {
        boolean result = super.performOk();
        if (result) {
            FontData newFontData = PreferenceConverter.getFontData((IPreferenceStore)this.getPreferenceStore(), (String)DIAGRAM_FONT_PROPERTY);
            int newClassWidth = this.getPreferenceStore().getInt("class_width");
            boolean needTotalUpdate = false;
            if (this.myClassWidth != newClassWidth) {
                this.myClassWidth = newClassWidth;
                needTotalUpdate = true;
            }
            if (!this.myFontData.equals((Object)newFontData)) {
                this.myFontData = newFontData;
                needTotalUpdate = true;
            }
            this.performUpdate(needTotalUpdate);
        }
        return result;
    }

    protected void performUpdate(final boolean needTotalUpdate) {
        ModelAccess.runCommand((Runnable)new UndoTransparableCommand(){

            public void run() {
                Enumeration models = ModelAccess.models();
                while (models.hasMoreElements()) {
                    Model theModel = (Model)models.nextElement();
                    UniqueName modelUIN = theModel.getUniqueName();
                    ViewManager viewManager = ViewAccess.getViewManager((UniqueName)modelUIN);
                    if (needTotalUpdate) {
                        viewManager.updateAllViews();
                        continue;
                    }
                    Enumeration views = viewManager.views();
                    while (views.hasMoreElements()) {
                        View view = (View)views.nextElement();
                        String name = view.getReferenceCollection().getPropertyValue("$metaclass");
                        view.getReferenceCollection().setPropertyValue("$metaclass", name);
                    }
                }
            }
        });
    }

    protected static Font getBoldFont(Device device, Font normal) {
        if (myBoldFont == null) {
            FontData[] data = normal.getFontData();
            if (data.length <= 0) {
                return normal;
            }
            FontData fontData = data[0];
            fontData.setStyle(fontData.getStyle() | 1);
            myBoldFont = new Font(device, fontData);
        }
        return myBoldFont;
    }
}

