/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.internal.tools;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.tools.AbstractTool;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class MarqueeSelectionTool
extends AbstractTool {
    static final int TOGGLE_MODE = 1;
    static final int APPEND_MODE = 2;
    private static final Request MARQUEE_REQUEST = new Request((Object)"selection");
    private int mode;
    private Shape marqueeRectangleFigure;
    private List allChildren = new ArrayList();
    private List selectedEditParts;
    private Request targetRequest;
    private Point myStartPoint = new Point();

    public MarqueeSelectionTool() {
        this.setDefaultCursor(Cursors.ARROW);
    }

    public void deactivate() {
        if (this.isInState(4)) {
            this.eraseMarqueeFeedback();
            this.eraseTargetFeedback();
        }
        super.deactivate();
        this.allChildren = new ArrayList();
        this.setState(0x40000000);
    }

    public void setViewer(EditPartViewer viewer) {
        if (viewer == this.getCurrentViewer()) {
            return;
        }
        super.setViewer(viewer);
        this.setDefaultCursor(Cursors.ARROW);
    }

    protected String getCommandName() {
        return "selection";
    }

    protected String getDebugName() {
        return "Marquee Tool";
    }

    protected boolean handleButtonDown(int button) {
        if (!this.isGraphicalViewer()) {
            return true;
        }
        if (button != 1) {
            this.setState(8);
            this.handleInvalidInput();
        }
        if (this.stateTransition(1, 4)) {
            if (this.getCurrentInput().isControlKeyDown()) {
                this.setSelectionMode(1);
            } else if (this.getCurrentInput().isShiftKeyDown()) {
                this.setSelectionMode(2);
            }
        }
        return true;
    }

    protected boolean handleButtonUp(int button) {
        if (this.stateTransition(4, 0x40000000)) {
            this.eraseTargetFeedback();
            this.performMarqueeSelect();
            this.eraseMarqueeFeedback();
        }
        this.handleFinished();
        return true;
    }

    protected boolean handleDragInProgress() {
        if (this.isInState(6)) {
            this.showMarqueeFeedback();
            this.eraseTargetFeedback();
            this.selectedEditParts = this.calculateNewSelection();
            this.showTargetFeedback();
        }
        return true;
    }

    protected boolean handleInvalidInput() {
        this.eraseTargetFeedback();
        this.eraseMarqueeFeedback();
        return true;
    }

    protected List getAllChildren() {
        if (this.allChildren.isEmpty()) {
            this.allChildren = this.getAllChildren((EditPart)this.getCurrentViewer().getRootEditPart(), new ArrayList());
        }
        return this.allChildren;
    }

    private List calculateNewSelection() {
        ArrayList<EditPart> newSelections = new ArrayList<EditPart>();
        List children = this.getAllChildren();
        int i = 0;
        while (i < children.size()) {
            EditPart child = (EditPart)children.get(i);
            IFigure figure = ((GraphicalEditPart)child).getFigure();
            if (figure.isVisible()) {
                Rectangle r = figure.getBounds().getCopy();
                if (this.getMarqueeSelectionRectangle().intersects(r) && child.getTargetEditPart(MARQUEE_REQUEST) == child) {
                    newSelections.add(child);
                }
            }
            ++i;
        }
        return newSelections;
    }

    private Request createTargetRequest() {
        return MARQUEE_REQUEST;
    }

    private void eraseMarqueeFeedback() {
        if (this.marqueeRectangleFigure != null) {
            this.removeFeedback((IFigure)this.marqueeRectangleFigure);
            this.marqueeRectangleFigure = null;
        }
    }

    private void eraseTargetFeedback() {
        if (this.selectedEditParts == null) {
            return;
        }
        ListIterator oldEditParts = this.selectedEditParts.listIterator();
        while (oldEditParts.hasNext()) {
            EditPart editPart = (EditPart)oldEditParts.next();
            editPart.eraseTargetFeedback(this.getTargetRequest());
        }
    }

    private List getAllChildren(EditPart editPart, List allChildren) {
        List children = editPart.getChildren();
        int i = 0;
        while (i < children.size()) {
            GraphicalEditPart child = (GraphicalEditPart)children.get(i);
            allChildren.add(child);
            this.getAllChildren((EditPart)child, allChildren);
            ++i;
        }
        return allChildren;
    }

    private IFigure getMarqueeFeedbackFigure() {
        if (this.marqueeRectangleFigure == null) {
            this.marqueeRectangleFigure = new RectangleFigure();
            FigureUtilities.makeGhostShape((Shape)this.marqueeRectangleFigure);
            this.marqueeRectangleFigure.setFill(false);
            this.marqueeRectangleFigure.setLineStyle(4);
            this.marqueeRectangleFigure.setBackgroundColor(ColorConstants.white);
            this.marqueeRectangleFigure.setForegroundColor(ColorConstants.black);
            this.addFeedback((IFigure)this.marqueeRectangleFigure);
            this.myStartPoint = this.getStartLocation();
            this.marqueeRectangleFigure.translateToRelative((Translatable)this.myStartPoint);
            this.marqueeRectangleFigure.setBounds(new Rectangle(this.myStartPoint, this.myStartPoint));
        }
        return this.marqueeRectangleFigure;
    }

    private Rectangle getMarqueeSelectionRectangle() {
        return this.getMarqueeFeedbackFigure().getBounds().getCopy();
    }

    private int getSelectionMode() {
        return this.mode;
    }

    private Request getTargetRequest() {
        if (this.targetRequest == null) {
            this.targetRequest = this.createTargetRequest();
        }
        return this.targetRequest;
    }

    private boolean isGraphicalViewer() {
        return this.getCurrentViewer() instanceof GraphicalViewer;
    }

    private void performMarqueeSelect() {
        EditPartViewer viewer = this.getCurrentViewer();
        List newSelections = this.calculateNewSelection();
        if (this.getSelectionMode() == 2) {
            int i = 0;
            while (i < newSelections.size()) {
                EditPart editPart = (EditPart)newSelections.get(i);
                viewer.appendSelection(editPart);
                ++i;
            }
        } else {
            viewer.setSelection((ISelection)new StructuredSelection(newSelections));
        }
    }

    private void setSelectionMode(int mode) {
        this.mode = mode;
    }

    private void showMarqueeFeedback() {
        Point currentLocation = this.getLocation();
        IFigure feedbackFigure = this.getMarqueeFeedbackFigure();
        feedbackFigure.translateToRelative((Translatable)currentLocation);
        Point startLocation = this.getRelativeStartLocation();
        Rectangle rect = new Rectangle(startLocation, currentLocation);
        this.getMarqueeFeedbackFigure().setBounds(rect);
    }

    private void showTargetFeedback() {
        int i = 0;
        while (i < this.selectedEditParts.size()) {
            EditPart editPart = (EditPart)this.selectedEditParts.get(i);
            editPart.showTargetFeedback(this.getTargetRequest());
            ++i;
        }
    }

    private Point getRelativeStartLocation() {
        return this.myStartPoint;
    }
}

