/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.internal.toolbar.def;

import com.tssap.selena.gde.internal.GdePlugin;
import com.tssap.selena.gde.internal.toolbar.def.IToolbarActionFactory;
import com.tssap.selena.gde.internal.toolbar.def.ToolbarActionDef;
import com.tssap.selena.gde.internal.toolbar.def.ToolbarDef;
import com.tssap.selena.gde.internal.toolbar.def.ToolbarDefRegistry;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.jface.action.Action;

public class ToolbarDefLoader {
    public static final String TOOLBAR_EXTENSION_ID = "toolbar";
    public static final String eTOOLBAR_ACTION = "toolbar-action";
    public static final String eTOOLBAR_DEFINITION = "toolbar-definition";
    public static final String aCLASSNAME = "classname";
    public static final String aDIAGRAM_METACLASS = "diagramMetaclass";

    public void load() {
        IExtensionPoint epoint = GdePlugin.getDefault().getDescriptor().getExtensionPoint(TOOLBAR_EXTENSION_ID);
        IExtension[] extensions = epoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            this.loadExtension(extension);
            ++i;
        }
    }

    private void loadExtension(IExtension extension) {
        IConfigurationElement[] configElements = extension.getConfigurationElements();
        int i = 0;
        while (i < configElements.length) {
            IConfigurationElement configElement = configElements[i];
            this.loadDefinition(configElement);
            ++i;
        }
    }

    private void loadDefinition(IConfigurationElement configElement) {
        String name = configElement.getName();
        if (!eTOOLBAR_DEFINITION.equals(name)) {
            return;
        }
        String diagramMetaclass = configElement.getAttribute(aDIAGRAM_METACLASS);
        if (diagramMetaclass == null) {
            diagramMetaclass = "<all_diagrams>";
        }
        ToolbarDef toolbarDef = (ToolbarDef)ToolbarDefRegistry.getInstance().getDef(diagramMetaclass);
        this.loadDefs(toolbarDef, configElement.getChildren());
    }

    private void loadDef(ToolbarDef toolbarDef, final IConfigurationElement configElement) {
        String name = configElement.getName();
        if (eTOOLBAR_ACTION.equals(name)) {
            IToolbarActionFactory actionFactory = new IToolbarActionFactory(){

                public Action createAction() {
                    try {
                        return (Action)configElement.createExecutableExtension(ToolbarDefLoader.aCLASSNAME);
                    }
                    catch (Throwable e) {
                        return null;
                    }
                }
            };
            ToolbarActionDef actionDef = new ToolbarActionDef(actionFactory);
            toolbarDef.addDef(actionDef);
        }
    }

    private void loadDefs(ToolbarDef toolbarDef, IConfigurationElement[] configElements) {
        int i = 0;
        while (i < configElements.length) {
            this.loadDef(toolbarDef, configElements[i]);
            ++i;
        }
    }
}

