/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.internal.palette2.def;

import com.tssap.selena.gde.internal.GdePlugin;
import com.tssap.selena.gde.internal.palette2.def.IDGenerator;
import com.tssap.selena.gde.internal.palette2.def.PaletteCategoryDef;
import com.tssap.selena.gde.internal.palette2.def.PaletteDef;
import com.tssap.selena.gde.internal.palette2.def.PaletteToolEntryDef;
import com.tssap.selena.gde.palette2.def.IPaletteDefRegistry;
import com.tssap.selena.gde.palette2.def.PaletteDefAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gef.Tool;

public class PaletteExtensionPointReader {
    public static final String PALETTE_EXTENSION_ID = "palette";
    public static final String ePALETTE_CATEGORY = "palette-category";
    public static final String ePALETTE_DEFINITION = "palette-definition";
    public static final String ePALETTE_DEFINITION_CONTRIBUTION = "palette-definition-contribution";
    public static final String ePALETTE_TOOL_ENTRY = "palette-tool-entry";
    public static final String aDIAGRAM_METACLASS = "diagramMetaclass";
    public static final String aICON_LARGE = "iconLarge";
    public static final String aICON_SMALL = "iconSmall";
    public static final String aID = "id";
    public static final String aLABEL = "label";
    public static final String aPARENT_ID = "parentID";
    public static final String aSHORT_DESCRIPTION = "shortDescription";
    public static final String aTOOL_CLASSNAME = "toolClassname";
    private IPaletteDefRegistry registry;
    private List contributions;

    public PaletteExtensionPointReader(IPaletteDefRegistry registry) {
        this.registry = registry;
        this.contributions = new ArrayList();
    }

    public void read() {
        IExtensionPoint epoint = GdePlugin.getDefault().getDescriptor().getExtensionPoint(PALETTE_EXTENSION_ID);
        IExtension[] extensions = epoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            this.readExtension(extension);
            ++i;
        }
        Iterator itr = this.contributions.iterator();
        while (itr.hasNext()) {
            ContributionRecord record = (ContributionRecord)itr.next();
            this.readDefinitionContribution(record.cel, record.plugin);
        }
    }

    private void readExtension(IExtension extension) {
        IConfigurationElement[] configElements = extension.getConfigurationElements();
        int i = 0;
        while (i < configElements.length) {
            IConfigurationElement cel = configElements[i];
            String name = cel.getName();
            try {
                if (ePALETTE_DEFINITION.equals(name)) {
                    this.readDefinition(cel, extension.getDeclaringPluginDescriptor().getPlugin());
                } else if (ePALETTE_DEFINITION_CONTRIBUTION.equals(name)) {
                    this.contributions.add(new ContributionRecord(cel, extension.getDeclaringPluginDescriptor().getPlugin()));
                }
            }
            catch (CoreException e) {
                GdePlugin.getDefault().getLog().log(e.getStatus());
            }
            ++i;
        }
    }

    private void readDefinition(IConfigurationElement cel, Plugin plugin) {
        String diagramMetaclass = cel.getAttribute(aDIAGRAM_METACLASS);
        String projectNature = cel.getAttribute("projectNature");
        String id = this.readID(cel);
        String parentID = cel.getAttribute("extends");
        int priority = this.readPriority(cel, 10);
        PaletteDef paletteDef = new PaletteDef(id, parentID, projectNature, diagramMetaclass, priority, GdePlugin.getDefault().getPaletteDefRegistry());
        this.readCategories(paletteDef, cel.getChildren(ePALETTE_CATEGORY), plugin);
        this.registry.registerDef(paletteDef);
    }

    private void readDefinitionContribution(IConfigurationElement cel, Plugin plugin) {
        String id = this.readID(cel);
        PaletteDef paletteDef = (PaletteDef)this.registry.getDef(id);
        if (paletteDef == null) {
            return;
        }
        this.readCategories(paletteDef, cel.getChildren(ePALETTE_CATEGORY), plugin);
        this.readToolEntryContributions(paletteDef, cel.getChildren(ePALETTE_TOOL_ENTRY), plugin);
    }

    private void readCategory(PaletteDef paletteDef, IConfigurationElement cel, Plugin plugin) {
        String id = this.readID(cel);
        PaletteDefAction action = PaletteDefAction.parse(cel.getAttribute("action"));
        int order = this.readOrder(cel, -1);
        String label = cel.getAttribute(aLABEL);
        PaletteCategoryDef cat = new PaletteCategoryDef(id, action, order, label, paletteDef);
        paletteDef.addCategoryDef(cat);
        this.readToolEntries(cat, cel.getChildren(ePALETTE_TOOL_ENTRY), plugin);
    }

    private void readToolEntry(PaletteCategoryDef paletteCat, IConfigurationElement cel, Plugin plugin) {
        String id = this.readID(cel);
        int order = this.readOrder(cel, -1);
        PaletteDefAction action = PaletteDefAction.parse(cel.getAttribute("action"));
        String label = cel.getAttribute(aLABEL);
        String shortDescription = cel.getAttribute(aSHORT_DESCRIPTION);
        String iconLarge = cel.getAttribute(aICON_LARGE);
        String iconSmall = cel.getAttribute(aICON_SMALL);
        Tool tool = this.readTool(cel);
        PaletteToolEntryDef entry = new PaletteToolEntryDef(id, order, action, label, shortDescription, tool, iconLarge, iconSmall, paletteCat, plugin);
        paletteCat.addToolEntryDef(entry);
    }

    private void readCategories(PaletteDef paletteDef, IConfigurationElement[] cels, Plugin plugin) {
        int ic = 0;
        while (ic < cels.length) {
            this.readCategory(paletteDef, cels[ic], plugin);
            ++ic;
        }
    }

    private void readToolEntries(PaletteCategoryDef categoryDef, IConfigurationElement[] cels, Plugin plugin) {
        int ic = 0;
        while (ic < cels.length) {
            this.readToolEntry(categoryDef, cels[ic], plugin);
            ++ic;
        }
    }

    private void readToolEntryContributions(PaletteDef paletteDef, IConfigurationElement[] cels, Plugin plugin) {
        int ic = 0;
        while (ic < cels.length) {
            PaletteCategoryDef categoryDef;
            IConfigurationElement cel = cels[ic];
            String parentID = cel.getAttribute(aPARENT_ID);
            if (parentID != null && (categoryDef = (PaletteCategoryDef)paletteDef.getCategory(parentID)) != null) {
                this.readToolEntry(categoryDef, cel, plugin);
            }
            ++ic;
        }
    }

    private String readID(IConfigurationElement cel) {
        String id = cel.getAttribute(aID);
        if (id == null) {
            id = IDGenerator.getInstance().next();
        }
        return id;
    }

    private int readOrder(IConfigurationElement cel, int defaultValue) {
        String sOrder = cel.getAttribute("order");
        try {
            return Integer.parseInt(sOrder);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private int readPriority(IConfigurationElement cel, int defaultValue) {
        String sPriority = cel.getAttribute("priority");
        try {
            return Integer.parseInt(sPriority);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private Tool readTool(IConfigurationElement cel) {
        Object toolObj = null;
        try {
            if (cel.getAttributeAsIs(aTOOL_CLASSNAME) != null) {
                toolObj = cel.createExecutableExtension(aTOOL_CLASSNAME);
            }
        }
        catch (CoreException e) {
            GdePlugin.getDefault().logException(e);
        }
        Tool tool = null;
        if (toolObj instanceof Tool) {
            tool = (Tool)toolObj;
        }
        return tool;
    }

    private static class ContributionRecord {
        IConfigurationElement cel;
        Plugin plugin;

        ContributionRecord(IConfigurationElement cel, Plugin plugin) {
            this.cel = cel;
            this.plugin = plugin;
        }
    }
}

