/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.internal.palette2.def;

import com.tssap.selena.gde.internal.palette.GDEPaletteCategory;
import com.tssap.selena.gde.internal.palette.GDEPaletteToolEntry;
import com.tssap.selena.gde.palette2.def.IPaletteCategoryDef;
import com.tssap.selena.gde.palette2.def.IPaletteDef;
import com.tssap.selena.gde.palette2.def.IPaletteElementFactory;
import com.tssap.selena.gde.palette2.def.IPaletteToolEntryDef;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class PaletteElementFactory
implements IPaletteElementFactory {
    private static Map ourImages = new HashMap();

    public GDEPaletteCategory[] create(IPaletteDef paletteDef) {
        ArrayList<GDEPaletteCategory> gdeCategories = new ArrayList<GDEPaletteCategory>();
        IPaletteCategoryDef[] categories = paletteDef.getCategories();
        int ic = 0;
        while (ic < categories.length) {
            GDEPaletteCategory gdeCat = this.create(categories[ic]);
            if (gdeCat != null) {
                gdeCategories.add(gdeCat);
            }
            ++ic;
        }
        return gdeCategories.toArray(new GDEPaletteCategory[gdeCategories.size()]);
    }

    private GDEPaletteCategory create(IPaletteCategoryDef categoryDef) {
        List gdeToolEntries = this.createToolEntries(categoryDef.getToolEntries());
        GDEPaletteCategory gdeCat = new GDEPaletteCategory(categoryDef.getLabel(), gdeToolEntries);
        return gdeCat;
    }

    private List createToolEntries(IPaletteToolEntryDef[] entryDefs) {
        ArrayList<GDEPaletteToolEntry> gdeToolEntries = new ArrayList<GDEPaletteToolEntry>();
        int ie = 0;
        while (ie < entryDefs.length) {
            GDEPaletteToolEntry gdeEntry = this.createToolEntry(entryDefs[ie]);
            if (gdeEntry != null) {
                gdeToolEntries.add(gdeEntry);
            }
            ++ie;
        }
        return gdeToolEntries;
    }

    private GDEPaletteToolEntry createToolEntry(IPaletteToolEntryDef entryDef) {
        GDEPaletteToolEntry gdeEntry = null;
        if (entryDef.getTool() != null) {
            URL iconLargeURL = this.getImageURL(entryDef.getIconLarge(), entryDef.getPlugin());
            URL iconSmallURL = this.getImageURL(entryDef.getIconSmall(), entryDef.getPlugin());
            Image iLarge = PaletteElementFactory.getImage(iconLargeURL);
            Image iSmall = PaletteElementFactory.getImage(iconSmallURL);
            gdeEntry = new GDEPaletteToolEntry(entryDef.getTool(), entryDef.getLabel(), entryDef.getShortDescription(), iSmall, iLarge);
        }
        return gdeEntry;
    }

    private URL getImageURL(String iconPath, Plugin plugin) {
        URL result = null;
        if (iconPath != null) {
            try {
                IPluginDescriptor declaringDescriptor = null;
                if (iconPath.startsWith("/")) {
                    int nextSeparator = iconPath.indexOf("/", 1);
                    if (nextSeparator == -1) {
                        return null;
                    }
                    String declaringPluginID = iconPath.substring(1, nextSeparator);
                    iconPath = iconPath.substring(nextSeparator + 1);
                    declaringDescriptor = Platform.getPluginRegistry().getPluginDescriptor(declaringPluginID);
                } else if (plugin != null) {
                    declaringDescriptor = plugin.getDescriptor();
                }
                if (declaringDescriptor != null) {
                    result = new URL(declaringDescriptor.getInstallURL(), iconPath);
                }
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        return result;
    }

    public static Image getImage(URL url) {
        if (url == null) {
            return null;
        }
        if (!ourImages.containsKey(url.toString())) {
            Image image = ImageDescriptor.createFromURL((URL)url).createImage();
            ourImages.put(url.toString(), image);
        }
        return (Image)ourImages.get(url.toString());
    }
}

