/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.internal.palette2.def;

import com.tssap.selena.gde.internal.viewmap.ChainMap;
import com.tssap.selena.gde.internal.viewmap.IListFactory;
import com.tssap.selena.gde.internal.viewmap.IMapFactory;
import com.tssap.selena.gde.palette2.def.IPaletteDef;
import com.tssap.selena.gde.palette2.def.IPaletteDefRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PaletteDefRegistry
implements IPaletteDefRegistry {
    private ChainMap map = new ChainMap(2, new IMapFactory(){

        public Map createMap() {
            return new HashMap();
        }
    }, new IListFactory(){

        public List createList() {
            return new ArrayList();
        }
    });
    private Map idMap = new HashMap();
    private static final boolean[] asterisks = new boolean[]{false, true};

    public void dump() {
        this.map.dump();
    }

    public IPaletteDef findDef(String[] projectNatures, String diagramMetaclass) {
        ArrayList defs = new ArrayList();
        Object[] keys = new String[]{"*", diagramMetaclass};
        defs.addAll(this.map.get(keys, asterisks));
        int in = 0;
        while (in < projectNatures.length) {
            keys[0] = projectNatures[in];
            defs.addAll(this.map.get(keys, asterisks));
            ++in;
        }
        IPaletteDef[] array = defs.toArray(new IPaletteDef[defs.size()]);
        int id = 0;
        while (id < array.length) {
            ++id;
        }
        IPaletteDef result = this.findStrongestDef(array);
        return result;
    }

    public IPaletteDef getDef(String id) {
        return (IPaletteDef)this.idMap.get(id);
    }

    public void registerDef(IPaletteDef def) {
        this.map.put(new String[]{ChainMap.fixKey(def.getProjectNature()), ChainMap.fixKey(def.getDiagramMetaclass())}, def);
        this.idMap.put(def.getID(), def);
    }

    private IPaletteDef findStrongestDef(IPaletteDef[] defs) {
        if (defs.length == 0) {
            return null;
        }
        IPaletteDef result = null;
        int maxRank = -1;
        int ir = 0;
        while (ir < defs.length) {
            IPaletteDef def = defs[ir];
            int rank = def.getRank();
            if (rank > maxRank) {
                maxRank = rank;
                result = def;
            } else if (rank == maxRank && def.getPriority() > result.getPriority()) {
                result = def;
            }
            ++ir;
        }
        return result;
    }
}

