/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.internal.palette2.def;

import com.tssap.selena.gde.palette2.def.IPaletteCategoryDef;
import com.tssap.selena.gde.palette2.def.IPaletteDef;
import com.tssap.selena.gde.palette2.def.IPaletteDefRegistry;
import com.tssap.selena.gde.palette2.def.PaletteDefAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PaletteDef
implements IPaletteDef {
    private String id;
    private String parentID;
    private String diagramMetaclass;
    private String projectNature;
    private int rank;
    private int priority;
    private Map categories;
    private IPaletteDefRegistry registry;

    public PaletteDef(String id, String parentID, String projectNature, String diagramMetaclass, int priority, IPaletteDefRegistry registry) {
        this.id = id;
        this.parentID = parentID;
        this.projectNature = projectNature;
        this.diagramMetaclass = diagramMetaclass;
        this.priority = priority;
        this.registry = registry;
        this.rank = this.computeRank();
        this.categories = new HashMap();
    }

    public void addCategoryDef(IPaletteCategoryDef def) {
        this.categories.put(def.getID(), def);
    }

    public IPaletteCategoryDef[] getCategories() {
        ArrayList list;
        IPaletteDef parentDef = this.getParentDef();
        if (parentDef == null) {
            list = this.getCategories(PaletteDefAction.ADD_OR_SUBSTITUTE);
        } else {
            IPaletteCategoryDef[] parentCategories = parentDef.getCategories();
            HashMap<String, IPaletteCategoryDef> categoryMap = new HashMap<String, IPaletteCategoryDef>();
            int ic = 0;
            while (ic < parentCategories.length) {
                categoryMap.put(parentCategories[ic].getID(), parentCategories[ic]);
                ++ic;
            }
            Iterator toRemoveItr = this.getCategories(PaletteDefAction.REMOVE).iterator();
            while (toRemoveItr.hasNext()) {
                IPaletteCategoryDef cat = (IPaletteCategoryDef)toRemoveItr.next();
                categoryMap.remove(cat.getID());
            }
            Iterator toModifyItr = this.getCategories(PaletteDefAction.ADD_OR_SUBSTITUTE).iterator();
            while (toModifyItr.hasNext()) {
                IPaletteCategoryDef cat = (IPaletteCategoryDef)toModifyItr.next();
                categoryMap.put(cat.getID(), cat);
            }
            list = new ArrayList();
            list.addAll(categoryMap.values());
        }
        Object[] result = list.toArray(new IPaletteCategoryDef[list.size()]);
        Arrays.sort(result);
        return result;
    }

    public IPaletteCategoryDef getCategory(String id) {
        return (IPaletteCategoryDef)this.categories.get(id);
    }

    public String getID() {
        return this.id;
    }

    public String getDiagramMetaclass() {
        return this.diagramMetaclass;
    }

    public IPaletteDef getParentDef() {
        return this.registry.getDef(this.parentID);
    }

    public int getPriority() {
        return this.priority;
    }

    public String getProjectNature() {
        return this.projectNature;
    }

    public int getRank() {
        return this.rank;
    }

    public String toString() {
        return this.id + ": (" + this.rank + ", " + this.priority + ", " + this.projectNature + ", " + this.diagramMetaclass + ")";
    }

    private int computeRank() {
        int rank = 0;
        if (this.projectNature != null) {
            ++rank;
        }
        if (this.diagramMetaclass != null) {
            ++rank;
        }
        return rank;
    }

    private List getCategories(PaletteDefAction action) {
        ArrayList<IPaletteCategoryDef> list = new ArrayList<IPaletteCategoryDef>();
        Iterator itr = this.categories.values().iterator();
        while (itr.hasNext()) {
            IPaletteCategoryDef cat = (IPaletteCategoryDef)itr.next();
            if (cat.getAction() != action) continue;
            list.add(cat);
        }
        return list;
    }
}

