/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.internal.palette2.def;

import com.tssap.selena.gde.internal.palette2.def.Messages;
import com.tssap.selena.gde.palette2.def.IPaletteCategoryDef;
import com.tssap.selena.gde.palette2.def.IPaletteDef;
import com.tssap.selena.gde.palette2.def.IPaletteToolEntryDef;
import com.tssap.selena.gde.palette2.def.PaletteDefAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PaletteCategoryDef
implements IPaletteCategoryDef,
Comparable {
    private String id;
    private PaletteDefAction action;
    private int order;
    private String label;
    private IPaletteDef paletteDef;
    private Map toolEntries;

    public PaletteCategoryDef(String id, PaletteDefAction action, int order, String label, IPaletteDef paletteDef) {
        this.id = id;
        this.action = action;
        this.order = order;
        this.label = label;
        this.paletteDef = paletteDef;
        this.toolEntries = new HashMap();
    }

    public void addToolEntryDef(IPaletteToolEntryDef def) {
        this.toolEntries.put(def.getID(), def);
    }

    public int compareTo(Object o) {
        IPaletteCategoryDef def = (IPaletteCategoryDef)o;
        return new Integer(this.order).compareTo(new Integer(def.getOrder()));
    }

    public PaletteDefAction getAction() {
        return this.action;
    }

    public String getID() {
        return this.id;
    }

    public String getLabel() {
        String result = Messages.getString("unknown_label_1");
        if (this.label != null) {
            result = this.label;
        } else if (this.getParentDef() != null) {
            result = this.getParentDef().getLabel();
        }
        return result;
    }

    public int getOrder() {
        int result = 10;
        if (this.order >= 0) {
            result = this.order;
        } else if (this.getParentDef() != null) {
            result = this.getParentDef().getOrder();
        }
        return result;
    }

    public IPaletteCategoryDef getParentDef() {
        return this.paletteDef.getParentDef() == null ? null : this.paletteDef.getParentDef().getCategory(this.id);
    }

    public IPaletteToolEntryDef[] getToolEntries() {
        ArrayList list;
        IPaletteCategoryDef parentDef = this.getParentDef();
        if (parentDef == null) {
            list = this.getToolEntries(PaletteDefAction.ADD_OR_SUBSTITUTE);
        } else {
            IPaletteToolEntryDef[] parentTools = parentDef.getToolEntries();
            HashMap<String, IPaletteToolEntryDef> toolMap = new HashMap<String, IPaletteToolEntryDef>();
            int it = 0;
            while (it < parentTools.length) {
                toolMap.put(parentTools[it].getID(), parentTools[it]);
                ++it;
            }
            Iterator toRemoveItr = this.getToolEntries(PaletteDefAction.REMOVE).iterator();
            while (toRemoveItr.hasNext()) {
                IPaletteToolEntryDef tool = (IPaletteToolEntryDef)toRemoveItr.next();
                toolMap.remove(tool.getID());
            }
            Iterator toModifyItr = this.getToolEntries(PaletteDefAction.ADD_OR_SUBSTITUTE).iterator();
            while (toModifyItr.hasNext()) {
                IPaletteToolEntryDef tool = (IPaletteToolEntryDef)toModifyItr.next();
                toolMap.put(tool.getID(), tool);
            }
            list = new ArrayList();
            list.addAll(toolMap.values());
        }
        Object[] result = list.toArray(new IPaletteToolEntryDef[list.size()]);
        Arrays.sort(result);
        return result;
    }

    public IPaletteToolEntryDef getToolEntry(String id) {
        return (IPaletteToolEntryDef)this.toolEntries.get(id);
    }

    private List getToolEntries(PaletteDefAction action) {
        ArrayList<IPaletteToolEntryDef> list = new ArrayList<IPaletteToolEntryDef>();
        Iterator itr = this.toolEntries.values().iterator();
        while (itr.hasNext()) {
            IPaletteToolEntryDef tool = (IPaletteToolEntryDef)itr.next();
            if (tool.getAction() != action) continue;
            list.add(tool);
        }
        return list;
    }
}

