/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.internal.palette.def;

import com.tssap.selena.gde.internal.palette.GDEPaletteCategory;
import com.tssap.selena.gde.internal.palette.GDEPaletteEntry;
import com.tssap.selena.gde.internal.palette.GDEPaletteGroup;
import com.tssap.selena.gde.internal.palette.GDEPaletteToolEntry;
import com.tssap.selena.gde.palette.def.IPaletteCategoryDef;
import com.tssap.selena.gde.palette.def.IPaletteDef;
import com.tssap.selena.gde.palette.def.IPaletteDefElement;
import com.tssap.selena.gde.palette.def.IPaletteEntryDef;
import com.tssap.selena.gde.palette.def.IPaletteGroupDef;
import com.tssap.selena.gde.palette.def.IPaletteParentDef;
import com.tssap.selena.gde.palette.def.IPaletteToolEntryDef;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PaletteElementFactory {
    private static PaletteElementFactory instance;

    public static PaletteElementFactory getInstance() {
        if (instance == null) {
            instance = new PaletteElementFactory();
        }
        return instance;
    }

    public List create(IPaletteDef def) {
        return this.createChildDefs(def);
    }

    public GDEPaletteEntry create(IPaletteEntryDef entryDef) {
        GDEPaletteEntry entry = null;
        if (entryDef.getLabel() != null) {
            entry = entryDef.getShortDescription() != null ? (entryDef.getIconSmall() != null && entryDef.getIconLarge() != null ? new GDEPaletteEntry(entryDef.getLabel(), entryDef.getShortDescription(), entryDef.getIconSmall(), entryDef.getIconLarge()) : new GDEPaletteEntry(entryDef.getLabel(), entryDef.getShortDescription())) : new GDEPaletteEntry(entryDef.getLabel());
        }
        return entry;
    }

    public GDEPaletteToolEntry create(IPaletteToolEntryDef toolEntryDef) {
        GDEPaletteToolEntry toolEntry = null;
        if (toolEntryDef.getTool() != null && toolEntryDef.getLabel() != null) {
            toolEntry = toolEntryDef.getShortDescription() != null ? (toolEntryDef.getIconSmall() != null && toolEntryDef.getIconLarge() != null ? new GDEPaletteToolEntry(toolEntryDef.getTool(), toolEntryDef.getLabel(), toolEntryDef.getShortDescription(), toolEntryDef.getIconSmall(), toolEntryDef.getIconLarge()) : new GDEPaletteToolEntry(toolEntryDef.getTool(), toolEntryDef.getLabel(), toolEntryDef.getShortDescription())) : new GDEPaletteToolEntry(toolEntryDef.getTool(), toolEntryDef.getLabel());
        }
        if (toolEntry != null) {
            toolEntry.setDefault(toolEntryDef.isDefault());
        }
        return toolEntry;
    }

    public GDEPaletteGroup create(IPaletteGroupDef groupDef) {
        GDEPaletteGroup group = null;
        if (groupDef.getLabel() != null) {
            group = new GDEPaletteGroup(groupDef.getLabel());
            group.setChildren(this.createChildDefs(groupDef));
        }
        return group;
    }

    public GDEPaletteCategory create(IPaletteCategoryDef categoryDef) {
        GDEPaletteCategory category = null;
        if (categoryDef.getLabel() != null) {
            category = new GDEPaletteCategory(categoryDef.getLabel());
            category.setChildren(this.createChildDefs(categoryDef));
        }
        return category;
    }

    private PaletteElementFactory() {
    }

    private List createChildDefs(IPaletteParentDef def) {
        ArrayList<Object> elements = new ArrayList<Object>();
        Iterator itr = def.getChildDefs().iterator();
        while (itr.hasNext()) {
            IPaletteDefElement defElement = (IPaletteDefElement)itr.next();
            Object paletteElement = defElement.createPaletteElement();
            if (paletteElement == null) continue;
            elements.add(paletteElement);
        }
        return elements;
    }
}

