/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.internal.palette.def;

import com.tssap.selena.gde.internal.GdePlugin;
import com.tssap.selena.gde.internal.palette.def.PaletteCategoryDef;
import com.tssap.selena.gde.internal.palette.def.PaletteDef;
import com.tssap.selena.gde.internal.palette.def.PaletteDefRegistry;
import com.tssap.selena.gde.internal.palette.def.PaletteEntryDef;
import com.tssap.selena.gde.internal.palette.def.PaletteGroupDef;
import com.tssap.selena.gde.internal.palette.def.PaletteParentDef;
import com.tssap.selena.gde.internal.palette.def.PaletteToolEntryDef;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gef.Tool;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class PaletteDefLoader {
    public static final String PALETTE_EXTENSION_ID = "palette";
    public static final String ePALETTE_CATEGORY = "palette-category";
    public static final String ePALETTE_DEFINITION = "palette-definition";
    public static final String ePALETTE_ENTRY = "palette-entry";
    public static final String ePALETTE_GROUP = "palette-group";
    public static final String ePALETTE_TOOL_ENTRY = "palette-tool-entry";
    public static final String aDIAGRAM_METACLASS = "diagramMetaclass";
    public static final String aICON_LARGE = "iconLarge";
    public static final String aICON_SMALL = "iconSmall";
    public static final String aID = "id";
    public static final String aLABEL = "label";
    public static final String aPARENT_ID = "parentID";
    public static final String aSHORT_DESCRIPTION = "shortDescription";
    public static final String aTOOL_CLASSNAME = "toolClassname";

    public void load() {
        IExtensionPoint epoint = GdePlugin.getDefault().getDescriptor().getExtensionPoint(PALETTE_EXTENSION_ID);
        IExtension[] extensions = epoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            this.loadExtension(extension);
            ++i;
        }
    }

    private void loadExtension(IExtension extension) {
        IConfigurationElement[] configElements = extension.getConfigurationElements();
        int i = 0;
        while (i < configElements.length) {
            IConfigurationElement configElement = configElements[i];
            try {
                this.loadDefinition(configElement, extension.getDeclaringPluginDescriptor().getPlugin());
            }
            catch (CoreException e) {
                GdePlugin.getDefault().logException(e);
            }
            ++i;
        }
    }

    private void loadDefinition(IConfigurationElement configElement, Plugin plugin) {
        String name = configElement.getName();
        if (!ePALETTE_DEFINITION.equals(name)) {
            return;
        }
        String diagramMetaclass = configElement.getAttribute(aDIAGRAM_METACLASS);
        if (diagramMetaclass == null) {
            diagramMetaclass = "*";
        }
        PaletteDef paletteDef = (PaletteDef)PaletteDefRegistry.getInstance().getDef(diagramMetaclass);
        this.loadChildDefs(paletteDef, configElement.getChildren(), plugin);
    }

    private void loadChildDef(PaletteParentDef parentDef, IConfigurationElement childConfigElement, Plugin plugin) {
        String id;
        String name = childConfigElement.getName();
        String parentID = childConfigElement.getAttribute(aPARENT_ID);
        if (parentID == null) {
            parentID = parentDef.getID();
        }
        if ((id = childConfigElement.getAttribute(aID)) == null) {
            id = aID + parentDef.hashCode();
        }
        String label = childConfigElement.getAttribute(aLABEL);
        String shortDescription = childConfigElement.getAttribute(aSHORT_DESCRIPTION);
        URL pluginInstallURL = plugin.getDescriptor().getInstallURL();
        if (ePALETTE_ENTRY.equals(name) || ePALETTE_TOOL_ENTRY.equals(name)) {
            String iconSmall = childConfigElement.getAttribute(aICON_SMALL);
            String iconLarge = childConfigElement.getAttribute(aICON_LARGE);
            URL iconSmallURL = PaletteDefLoader.getImageURL(iconSmall, plugin);
            URL iconLargeURL = PaletteDefLoader.getImageURL(iconSmall, plugin);
            Image iSmall = ImageDescriptor.createFromURL((URL)iconSmallURL).createImage();
            Image iLarge = ImageDescriptor.createFromURL((URL)iconLargeURL).createImage();
            PaletteEntryDef def = null;
            if (ePALETTE_TOOL_ENTRY.equals(name)) {
                Object toolObj = null;
                try {
                    if (childConfigElement.getAttributeAsIs(aTOOL_CLASSNAME) != null) {
                        toolObj = childConfigElement.createExecutableExtension(aTOOL_CLASSNAME);
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                Tool tool = null;
                if (toolObj instanceof Tool) {
                    tool = (Tool)toolObj;
                }
                def = new PaletteToolEntryDef(parentID, tool, label, shortDescription, iSmall, iLarge, false);
            } else {
                def = new PaletteEntryDef(parentID, label, shortDescription, iSmall, iLarge);
            }
            parentDef.getParentDefRegistry().addChild(parentID, def);
        } else if (ePALETTE_GROUP.equals(name)) {
            PaletteGroupDef def = new PaletteGroupDef(parentID, id, label, parentDef.getParentDefRegistry());
            this.loadChildDefs(def, childConfigElement.getChildren(), plugin);
            parentDef.getParentDefRegistry().addChild(parentID, def);
        } else if (ePALETTE_CATEGORY.equals(name)) {
            PaletteCategoryDef def = new PaletteCategoryDef(parentID, id, label, parentDef.getParentDefRegistry());
            this.loadChildDefs(def, childConfigElement.getChildren(), plugin);
            parentDef.getParentDefRegistry().addChild(parentID, def);
        }
    }

    public static URL getImageURL(String iconPath, Plugin plugin) {
        URL result = null;
        try {
            IPluginDescriptor declaringDescriptor;
            if (iconPath.startsWith("/")) {
                int nextSeparator = iconPath.indexOf("/", 1);
                if (nextSeparator == -1) {
                    return null;
                }
                String declaringPluginID = iconPath.substring(1, nextSeparator);
                iconPath = iconPath.substring(nextSeparator + 1);
                declaringDescriptor = Platform.getPluginRegistry().getPluginDescriptor(declaringPluginID);
            } else {
                declaringDescriptor = plugin.getDescriptor();
            }
            if (declaringDescriptor != null) {
                result = new URL(declaringDescriptor.getInstallURL(), iconPath);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return result;
    }

    private void loadChildDefs(PaletteParentDef parentDef, IConfigurationElement[] childConfigElements, Plugin plugin) {
        int i = 0;
        while (i < childConfigElements.length) {
            this.loadChildDef(parentDef, childConfigElements[i], plugin);
            ++i;
        }
    }
}

