/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.internal.palette;

import com.tssap.selena.gde.internal.palette.GDEPaletteCategory;
import com.tssap.selena.gde.internal.palette.GDEPaletteContainer;
import com.tssap.selena.gde.internal.palette.GDEPaletteGroup;
import com.tssap.selena.gde.internal.palette.GDEPaletteRoot;
import com.tssap.selena.gde.internal.palette.GDEPaletteToolEntry;
import com.tssap.selena.gde.internal.palette.IGDEPaletteEntry;
import java.util.Iterator;
import org.eclipse.gef.palette.DefaultPaletteContainer;

public class LabelUpdater {
    public static void updateEntry(IGDEPaletteEntry entry) {
        String labelToSet = entry.getLabelStatus() ? entry.getOriginalLabel() : "";
        entry.setLabel(labelToSet);
    }

    public static void updateToolEntry(GDEPaletteToolEntry toolEntry) {
        LabelUpdater.updateEntry(toolEntry);
    }

    public static void updateContainer(GDEPaletteContainer container) {
        LabelUpdater.updateEntry(container);
        LabelUpdater.updateChildren(container, container.getLabelStatus());
    }

    public static void updateGroup(GDEPaletteGroup group) {
        LabelUpdater.updateEntry(group);
        LabelUpdater.updateChildren((DefaultPaletteContainer)group, group.getLabelStatus());
    }

    public static void updateCategory(GDEPaletteCategory category) {
        LabelUpdater.updateEntry(category);
        LabelUpdater.updateChildren((DefaultPaletteContainer)category, category.getLabelStatus());
    }

    public static void updateRoot(GDEPaletteRoot root) {
        LabelUpdater.updateChildren((DefaultPaletteContainer)root, root.getLabelStatus());
    }

    private static void updateChildren(DefaultPaletteContainer container, boolean status) {
        Iterator itr = container.getChildren().iterator();
        while (itr.hasNext()) {
            Object child = itr.next();
            if (!(child instanceof IGDEPaletteEntry)) continue;
            IGDEPaletteEntry entry = (IGDEPaletteEntry)child;
            entry.setLabelStatus(status);
        }
    }
}

