/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.internal.inplace;

import com.tssap.selena.gde.IInplaceEditorApplier;
import com.tssap.selena.gde.ModelElementEditPart;
import com.tssap.selena.gde.internal.DiagramElement;
import com.tssap.selena.gde.internal.DiagramImpl;
import com.tssap.selena.gde.internal.Messages;
import com.tssap.selena.gde.internal.inplace.InplaceEditor;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.ui.actions.TextActionHandlerExt;
import com.tssap.selena.model.update.diagram.IUpdatableElement;
import com.tssap.selena.model.util.UpdateCommand;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;

public class PreservingSelectionInplaceEditor
extends InplaceEditor {
    private DiagramImpl myDiagram;
    private boolean myApplying;

    public PreservingSelectionInplaceEditor(Composite parent, IInplaceEditorApplier applier, ModelElementEditPart ep, TextActionHandlerExt textActionHandler) {
        super(parent, applier, ep, textActionHandler);
        this.myDiagram = (DiagramImpl)ep.getDiagram();
    }

    public void applyEditorValue() {
        PreservingSelectionInplaceEditor preservingSelectionInplaceEditor = this;
        synchronized (preservingSelectionInplaceEditor) {
            if (this.myApplying) {
                return;
            }
            this.myApplying = true;
        }
        if (this.validateValue() && this.getInplaceApplyer().canApplyValue(this.getValue()) == IInplaceEditorApplier.VALID) {
            if (this.getValue() != null && this.getValue().equals(this.getInplaceApplyer().getInitialValue())) {
                this.shutDown();
                this.myDiagram = null;
            } else {
                ModelAccess.runCommand((Runnable)new UpdateCommand(){

                    public void run() {
                        PreservingSelectionInplaceEditor.this.getInplaceApplyer().applyValue(PreservingSelectionInplaceEditor.this.getValue());
                        Object changedElement = PreservingSelectionInplaceEditor.this.getInplaceApplyer().getChangedElement();
                        if (changedElement instanceof Entity) {
                            PreservingSelectionInplaceEditor.restoreSelectionLater(PreservingSelectionInplaceEditor.this.myDiagram, (Entity)changedElement);
                            PreservingSelectionInplaceEditor.this.myDiagram = null;
                        }
                        PreservingSelectionInplaceEditor.this.shutDown();
                    }
                });
            }
        } else {
            PreservingSelectionInplaceEditor preservingSelectionInplaceEditor2 = this;
            synchronized (preservingSelectionInplaceEditor2) {
                this.myApplying = false;
            }
        }
    }

    public void shutDown() {
        super.shutDown();
        PreservingSelectionInplaceEditor preservingSelectionInplaceEditor = this;
        synchronized (preservingSelectionInplaceEditor) {
            this.myApplying = false;
        }
    }

    private static void restoreSelectionLater(final DiagramImpl diagram, final Entity toSelect) {
        if (toSelect == null) {
            return;
        }
        if (diagram == null) {
            System.out.println("Should not happen: Diagram == null!");
            return;
        }
        ModelAccess.runCommandLater((Runnable)new Runnable(){

            public void run() {
                IUpdatableElement newDiagramElement = diagram.findByEntityUin(toSelect.getUniqueName());
                if (newDiagramElement instanceof DiagramElement) {
                    diagram.getViewPart().getViewer().setSelection((ISelection)new StructuredSelection((Object)((DiagramElement)newDiagramElement).getEditPart()));
                }
            }
        }, (String)Messages.getString("PreservingSelectionInplaceEditor.Restoring_selection"));
    }
}

