/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.internal.inplace;

import com.tssap.selena.gde.IInplaceEditorApplier;
import com.tssap.selena.gde.ModelElementEditPart;
import com.tssap.selena.gde.internal.DiagramRootEditPart;
import com.tssap.selena.internal.model.ui.keyboardShortcuts.HotkeyActionListener;
import com.tssap.selena.internal.model.ui.keyboardShortcuts.KeyboardNotifier;
import com.tssap.selena.model.ui.actions.TextActionHandlerExt;
import com.tssap.selena.model.update.hierarchy.Revisit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.gef.RootEditPart;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;

public class InplaceEditor
extends TextCellEditor
implements ICellEditorListener,
FocusListener,
PropertyChangeListener,
HotkeyActionListener {
    private TextActionHandlerExt myTextActionHandler;
    private IInplaceEditorApplier myApplyer;
    private ScrollPane myDiagramScroller = null;
    private boolean myIsActivated = false;

    public InplaceEditor(Composite parent, IInplaceEditorApplier applier, ModelElementEditPart ep, TextActionHandlerExt textActionHandler) {
        super(parent);
        this.addListener(this);
        parent.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (!InplaceEditor.this.getControl().isDisposed() && InplaceEditor.this.isActivated()) {
                    InplaceEditor.this.deactivate();
                    InplaceEditor.this.dispose();
                }
            }
        });
        this.getControl().addFocusListener((FocusListener)this);
        this.attachTextActionHandler(textActionHandler);
        RootEditPart rootEP = ep.getRoot();
        if (rootEP instanceof DiagramRootEditPart) {
            this.myDiagramScroller = ((DiagramRootEditPart)rootEP).getDiagramScrollPane();
            this.myDiagramScroller.getVerticalScrollBar().addPropertyChangeListener((PropertyChangeListener)this);
            this.myDiagramScroller.getHorizontalScrollBar().addPropertyChangeListener((PropertyChangeListener)this);
        }
        KeyboardNotifier.getInstance().addHotkeyActionListener((HotkeyActionListener)this);
        this.myApplyer = applier;
        this.setValidator(applier);
        String value = this.myApplyer.getInitialValue();
        if (value == null) {
            value = "";
        }
        this.setValue(value);
        this.performSelectAll();
    }

    public void activate() {
        this.myIsActivated = true;
        super.activate();
        this.setFocus();
    }

    public void applyEditorValue() {
        if (this.validateValue() && this.canApplyEditorValue()) {
            this.myApplyer.applyValue(this.getValue());
            this.shutDown();
        }
    }

    public void cancelEditor() {
        this.shutDown();
    }

    public void editorValueChanged(boolean oldValidState, boolean newValidState) {
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        this.focusLost();
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.focusLost();
    }

    public void beforeStart() {
        this.cancelEditor();
    }

    public void finalize() {
        Revisit.revisit();
    }

    private void attachTextActionHandler(TextActionHandlerExt textActionHandler) {
        this.myTextActionHandler = textActionHandler;
        if (this.myTextActionHandler != null && this.getControl() instanceof Text) {
            this.myTextActionHandler.addText((Text)this.getControl());
        }
    }

    protected boolean validateValue() {
        if (this.getValidator() != null) {
            String errorMessage = this.getValidator().isValid(this.getValue());
            Revisit.revisit();
            return errorMessage == IInplaceEditorApplier.VALID;
        }
        return this.isValueValid();
    }

    public void shutDown() {
        this.setValidator(null);
        this.removeListener(this);
        if (this.getControl() != null && !this.getControl().isDisposed()) {
            if (this.myTextActionHandler != null && this.getControl() instanceof Text) {
                this.myTextActionHandler.removeText((Text)this.getControl());
            }
            this.getControl().removeFocusListener((FocusListener)this);
        }
        if (this.myDiagramScroller != null) {
            this.myDiagramScroller.getVerticalScrollBar().removePropertyChangeListener((PropertyChangeListener)this);
            this.myDiagramScroller.getHorizontalScrollBar().removePropertyChangeListener((PropertyChangeListener)this);
        }
        KeyboardNotifier.getInstance().removeHotkeyActionListener((HotkeyActionListener)this);
        if ("motif".equals(SWT.getPlatform())) {
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    InplaceEditor.this.dispose();
                }
            });
        } else {
            this.dispose();
        }
    }

    public void focusLost() {
        if (!this.myIsActivated) {
            return;
        }
        if (this.canApplyEditorValue()) {
            this.applyEditorValue();
        } else {
            this.cancelEditor();
        }
    }

    protected IInplaceEditorApplier getInplaceApplyer() {
        return this.myApplyer;
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.character == '\u001b') {
            this.fireCancelEditor();
        } else if (keyEvent.character == '\r') {
            this.fireApplyEditorValue();
        }
    }

    private boolean canApplyEditorValue() {
        return this.getInplaceApplyer().canApplyValue(this.getValue()) == IInplaceEditorApplier.VALID;
    }
}

