/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.internal.grid;

import com.tssap.selena.gde.internal.grid.IGridSetup;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class GridHelper {
    public static Point adjust(Point p, IGridSetup gridSetup) {
        Point ap = new Point(p);
        ap.x = GridHelper.adjustX(ap.x, gridSetup);
        ap.y = GridHelper.adjustY(ap.y, gridSetup);
        return ap;
    }

    public static Rectangle adjustBottom(Rectangle r, IGridSetup gridSetup) {
        Rectangle ar = new Rectangle(r);
        int bottom = GridHelper.adjustY(r.bottom(), gridSetup);
        ar.height = bottom - r.y;
        return ar;
    }

    public static Rectangle adjustLeft(Rectangle r, IGridSetup gridSetup) {
        Rectangle ar = new Rectangle(r);
        ar.x = GridHelper.adjustX(r.x, gridSetup);
        ar.width = r.right() - ar.x;
        return ar;
    }

    public static Rectangle adjustRight(Rectangle r, IGridSetup gridSetup) {
        Rectangle ar = new Rectangle(r);
        int right = GridHelper.adjustX(r.right(), gridSetup);
        ar.width = right - r.x;
        return ar;
    }

    public static Rectangle adjustTop(Rectangle r, IGridSetup gridSetup) {
        Rectangle ar = new Rectangle(r);
        ar.y = GridHelper.adjustY(r.y, gridSetup);
        ar.height = r.bottom() - ar.y;
        return ar;
    }

    public static Rectangle adjustTopLeft(Rectangle r, IGridSetup gridSetup) {
        Rectangle ar = new Rectangle(r);
        ar.setLocation(GridHelper.adjust(ar.getLocation(), gridSetup));
        return ar;
    }

    public static int adjustX(int x, IGridSetup gridSetup) {
        if (!gridSetup.snapToGrid()) {
            return x;
        }
        float fr = (float)x / (float)gridSetup.getGridWidth();
        int ix = Math.round(fr) * gridSetup.getGridWidth();
        return ix;
    }

    public static int adjustY(int y, IGridSetup gridSetup) {
        if (!gridSetup.snapToGrid()) {
            return y;
        }
        float fr = (float)y / (float)gridSetup.getGridHeight();
        int iy = Math.round(fr) * gridSetup.getGridHeight();
        return iy;
    }
}

