/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.internal.editpolicies;

import com.tssap.selena.gde.ModelNodeEditPart;
import com.tssap.selena.gde.internal.commands.CompoundModelCommand;
import com.tssap.selena.gde.internal.commands.DropCommand;
import com.tssap.selena.gde.internal.commands.SetConstraintCommand;
import com.tssap.selena.gde.internal.editparts.DiagramEditPart;
import com.tssap.selena.gde.internal.editpolicies.XYLayoutEditPolicy;
import com.tssap.selena.gde.internal.grid.GridHelper;
import com.tssap.selena.gde.internal.grid.IGridSetup;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.AbstractCommand;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;

public class XYLayoutWithMinimumSizeEditPolicy
extends XYLayoutEditPolicy {
    private static Map ourCachedDropCommands = new HashMap();
    private IFigure myTargetFeedback;

    public XYLayoutWithMinimumSizeEditPolicy() {
    }

    public XYLayoutWithMinimumSizeEditPolicy(IGridSetup gridSetup) {
        super(gridSetup);
    }

    protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
        ModelNodeEditPart modelNodeEditPart = (ModelNodeEditPart)child;
        Rectangle rectangle = (Rectangle)constraint;
        Dimension correctSize = rectangle.getSize().getUnioned(modelNodeEditPart.getMinimumSize());
        boolean sizeChanged = !correctSize.equals((Object)modelNodeEditPart.getFigure().getBounds().getSize());
        SetConstraintCommand result = new SetConstraintCommand(child, this.translateConstraints(new Rectangle(rectangle.getLocation(), correctSize)), sizeChanged);
        return result.canExecute() ? result : null;
    }

    protected Object getConstraintFor(ChangeBoundsRequest request, GraphicalEditPart child) {
        Rectangle rect = child.getFigure().getBounds();
        rect = request.getTransformedRectangle(rect);
        GraphicalEditPart host = (GraphicalEditPart)this.getHost();
        rect.translate(host.getContentPane().getBounds().getLocation().negate());
        Object constraint = null;
        if (this.getGridSetup().snapToGrid()) {
            if ("move".equals(request.getType())) {
                constraint = GridHelper.adjustTopLeft(rect, this.getGridSetup());
            } else {
                int direction = request.getResizeDirection();
                if ((1 & direction) != 0) {
                    constraint = GridHelper.adjustTop(rect, this.getGridSetup());
                } else if ((4 & direction) != 0) {
                    constraint = GridHelper.adjustBottom(rect, this.getGridSetup());
                }
                if ((8 & direction) != 0) {
                    constraint = GridHelper.adjustLeft(rect, this.getGridSetup());
                } else if ((0x10 & direction) != 0) {
                    constraint = GridHelper.adjustRight(rect, this.getGridSetup());
                }
            }
        }
        if (constraint == null) {
            constraint = this.getConstraintFor(rect);
        }
        return constraint;
    }

    protected Command createAddCommand(EditPart child, Object constraint) {
        if (ourCachedDropCommands.containsKey(child) && ((Map)ourCachedDropCommands.get(child)).containsKey(this.getHost())) {
            Object dropCommand;
            CompoundCommand command = (CompoundCommand)((Map)ourCachedDropCommands.get(child)).get(this.getHost());
            if (command != null && (dropCommand = command.getCommands().get(command.getCommands().size() - 1)) instanceof DropCommand && constraint instanceof Rectangle) {
                ((DropCommand)((Object)dropCommand)).setConstraint(this.translateConstraints((Rectangle)constraint));
            }
            return command;
        }
        ModelNodeEditPart oldHost = (ModelNodeEditPart)child;
        ModelNodeEditPart newHost = (ModelNodeEditPart)this.getHost();
        DropCommand dropCommand = new DropCommand(newHost, child, this.translateConstraints((Rectangle)constraint));
        if (!ourCachedDropCommands.containsKey(child)) {
            ourCachedDropCommands.put(child, new HashMap());
        }
        if (dropCommand.canExecute()) {
            CompoundCommand compound = new CompoundCommand();
            compound.add((Command)new AbstractCommand(){

                public void execute() {
                    XYLayoutWithMinimumSizeEditPolicy.this.eraseDragTargetFeedback(null);
                }
            });
            compound.add((Command)dropCommand);
            ((Map)ourCachedDropCommands.get(child)).put(this.getHost(), compound);
            return compound;
        }
        ((Map)ourCachedDropCommands.get(child)).put(this.getHost(), null);
        return null;
    }

    protected Command getAddCommand(Request generic) {
        ChangeBoundsRequest request = (ChangeBoundsRequest)generic;
        List editParts = request.getEditParts();
        CompoundModelCommand command = new CompoundModelCommand();
        command.setDebugLabel("Add in ConstrainedLayoutEditPolicy");
        IFigure contentPane = ((GraphicalEditPart)this.getHost()).getContentPane();
        int i = 0;
        while (i < editParts.size()) {
            GraphicalEditPart childPart = (GraphicalEditPart)editParts.get(i);
            Rectangle r = childPart.getFigure().getBounds().getCopy();
            childPart.getFigure().translateToAbsolute((Translatable)r);
            r = request.getTransformedRectangle(r);
            r.translate(contentPane.getClientArea().getLocation().negate());
            contentPane.translateToRelative((Translatable)r);
            contentPane.translateFromParent((Translatable)r);
            Object constraint = this.getConstraintFor(r);
            command.add(this.createAddCommand((EditPart)childPart, this.translateConstraints((Rectangle)this.translateToModelConstraint(constraint))));
            ++i;
        }
        return command.unwrap();
    }

    protected void decorateChild(EditPart child) {
    }

    protected void eraseDragTargetFeedback(Request request) {
        if (this.myTargetFeedback != null) {
            this.removeFeedback(this.myTargetFeedback);
            this.myTargetFeedback = null;
        }
        ourCachedDropCommands.clear();
    }

    protected void showDragTargetFeedback(Request request) {
        if (this.getCommand(request) == null) {
            return;
        }
        if (this.myTargetFeedback == null && !(this.getTargetEditPart(request) instanceof DiagramEditPart)) {
            this.myTargetFeedback = this.createTargetFeedback();
            this.addFeedback(this.myTargetFeedback);
        }
    }

    protected IFigure createTargetFeedback() {
        RectangleFigure result = new RectangleFigure();
        result.setFill(false);
        Rectangle rect = new Rectangle(this.getFigure().getBounds());
        rect.expand(5, 5);
        result.setBounds(rect);
        return result;
    }
}

