/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.internal.editpolicies;

import com.tssap.selena.gde.internal.DiagramViewer;
import com.tssap.selena.gde.internal.handles.ZoomableResizableHandleKit;
import com.tssap.selena.gde.zoom.Zoomer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;

public class PartlyResizableEditPolicy
extends ResizableEditPolicy {
    private int myResizableDirection = 0;
    private Zoomer myZoomer;

    public PartlyResizableEditPolicy(int resizableDirection) {
        this.myResizableDirection = resizableDirection;
    }

    protected List createSelectionHandles() {
        ArrayList list = new ArrayList();
        ZoomableResizableHandleKit.addHandles((GraphicalEditPart)this.getHost(), list);
        this.myZoomer = ((DiagramViewer)this.getHost().getRoot().getViewer()).getZoomer();
        return list;
    }

    protected Command getResizeCommand(ChangeBoundsRequest request) {
        int direction = request.getResizeDirection();
        if (direction != this.myResizableDirection) {
            int newDirection = direction & this.myResizableDirection;
            if (newDirection == 0) {
                return null;
            }
            request.setResizeDirection(newDirection);
            if (this.myResizableDirection == 24) {
                request.setSizeDelta(new Dimension(this.myZoomer.scale(request.getSizeDelta().width), 0));
            } else if (this.myResizableDirection == 5) {
                request.setSizeDelta(new Dimension(0, this.myZoomer.scale(request.getSizeDelta().height)));
            }
        }
        return super.getResizeCommand(request);
    }
}

