/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.internal.editpolicies;

import com.tssap.selena.gde.IBendpointList;
import com.tssap.selena.gde.ModelLinkEditPart;
import com.tssap.selena.gde.internal.commands.GDECreateBendpointCommand;
import com.tssap.selena.gde.internal.commands.GDEDeleteBendpointCommand;
import com.tssap.selena.gde.internal.commands.GDEMoveBendpointCommand;
import com.tssap.selena.gde.internal.grid.GridHelper;
import com.tssap.selena.gde.internal.grid.IGridSetup;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.BendpointEditPolicy;
import org.eclipse.gef.requests.BendpointRequest;

public class GDEBendpointEditPolicy
extends BendpointEditPolicy {
    private IGridSetup gridSetup;

    public GDEBendpointEditPolicy(IGridSetup gridSetup) {
        this.gridSetup = gridSetup;
    }

    protected Command getCreateBendpointCommand(BendpointRequest request) {
        GDECreateBendpointCommand com = new GDECreateBendpointCommand(request);
        Point p = request.getLocation();
        com.setLocation(p);
        com.setBendpointList(this.getBendpointList(request));
        com.setIndex(request.getIndex());
        return com;
    }

    protected Command getDeleteBendpointCommand(BendpointRequest request) {
        GDEDeleteBendpointCommand com = new GDEDeleteBendpointCommand(request);
        Point p = request.getLocation();
        com.setLocation(p);
        com.setBendpointList(this.getBendpointList(request));
        com.setIndex(request.getIndex());
        return com;
    }

    protected Command getMoveBendpointCommand(BendpointRequest request) {
        GDEMoveBendpointCommand com = new GDEMoveBendpointCommand(request);
        Point p = request.getLocation();
        com.setLocation(p);
        com.setBendpointList(this.getBendpointList(request));
        com.setIndex(request.getIndex());
        return com;
    }

    protected void showCreateBendpointFeedback(BendpointRequest request) {
        Point p = GridHelper.adjust(request.getLocation(), this.gridSetup);
        request.setLocation(p);
        super.showCreateBendpointFeedback(request);
    }

    protected void showMoveBendpointFeedback(BendpointRequest request) {
        Point p = GridHelper.adjust(request.getLocation(), this.gridSetup);
        request.setLocation(p);
        super.showMoveBendpointFeedback(request);
    }

    private IBendpointList getBendpointList(BendpointRequest request) {
        return ((ModelLinkEditPart)request.getSource()).getBendpointList();
    }
}

