/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.internal.editpolicies;

import com.tssap.selena.gde.internal.commands.CompleteLinkCreateCommand;
import com.tssap.selena.gde.internal.commands.CreateLinkCommand;
import com.tssap.selena.gde.internal.commands.CreateLinkRequest;
import com.tssap.selena.gde.internal.commands.RedirectSourceCommand;
import com.tssap.selena.gde.internal.commands.RedirectTargetCommand;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.XYAnchor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.FeedbackHelper;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gef.requests.ReconnectRequest;

public class ConnectableNodeEditPolicy
extends GraphicalNodeEditPolicy {
    private IFigure myTargetFeedback;
    private XYAnchor mySourceAnchor = new XYAnchor(new Point(0, 0));
    private static Map ourCommandsCache = new HashMap();

    public Command getCommand(Request request) {
        return super.getCommand(request);
    }

    protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
        if (request instanceof CreateLinkRequest) {
            Command result = this.createCreateLinkCommand((CreateLinkRequest)request);
            return result.canExecute() ? result : null;
        }
        return null;
    }

    protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
        Command result = null;
        if (request instanceof CreateLinkRequest) {
            result = this.createCompleteLinkCreateCommand((CreateLinkRequest)request);
            return result.canExecute() ? result : null;
        }
        return null;
    }

    protected Command createCreateLinkCommand(CreateLinkRequest createLinkRequest) {
        return new CreateLinkCommand(createLinkRequest);
    }

    protected Command createCompleteLinkCreateCommand(CreateLinkRequest createLinkRequest) {
        return new CompleteLinkCreateCommand(createLinkRequest);
    }

    protected Command getReconnectSourceCommand(ReconnectRequest request) {
        if (ourCommandsCache.containsKey(request.getTarget())) {
            return (Command)ourCommandsCache.get(request.getTarget());
        }
        RedirectSourceCommand cmd = new RedirectSourceCommand();
        cmd.setNewSourceEP((GraphicalEditPart)request.getTarget());
        ConnectionEditPart connectionEP = request.getConnectionEditPart();
        cmd.setCurrentSourceEP((GraphicalEditPart)connectionEP.getSource());
        cmd.setConnectionEP(connectionEP);
        if (!cmd.canExecute()) {
            cmd = null;
        }
        ourCommandsCache.put(request.getTarget(), cmd);
        return cmd;
    }

    protected Command getReconnectTargetCommand(ReconnectRequest request) {
        if (ourCommandsCache.containsKey(request.getTarget())) {
            return (Command)ourCommandsCache.get(request.getTarget());
        }
        RedirectTargetCommand cmd = new RedirectTargetCommand();
        cmd.setNewTargetEP((GraphicalEditPart)request.getTarget());
        ConnectionEditPart connectionEP = request.getConnectionEditPart();
        cmd.setCurrentTargetEP((GraphicalEditPart)connectionEP.getTarget());
        cmd.setConnectionEP(connectionEP);
        if (!cmd.canExecute()) {
            cmd = null;
        }
        ourCommandsCache.put(request.getTarget(), cmd);
        return cmd;
    }

    protected void showTargetConnectionFeedback(DropRequest request) {
        if (!(request instanceof CreateConnectionRequest) || this.getCommand((Request)((CreateConnectionRequest)request)) == null) {
            return;
        }
        if (this.myTargetFeedback == null) {
            this.myTargetFeedback = this.createTargetFeedback();
            this.addFeedback(this.myTargetFeedback);
        }
    }

    protected void eraseTargetConnectionFeedback(DropRequest request) {
        ourCommandsCache.clear();
        if (this.myTargetFeedback != null) {
            this.removeFeedback(this.myTargetFeedback);
            this.myTargetFeedback = null;
        }
    }

    protected IFigure createTargetFeedback() {
        RectangleFigure result = new RectangleFigure();
        result.setFill(false);
        Rectangle rect = new Rectangle(this.getFigure().getBounds());
        rect.expand(5, 5);
        result.setBounds(rect);
        return result;
    }

    protected void showCreationFeedback(CreateConnectionRequest request) {
        Point startPoint;
        if (request instanceof CreateLinkRequest && (startPoint = ((CreateLinkRequest)request).getStartPoint()) != null) {
            FeedbackHelper helper = this.getFeedbackHelper(request);
            helper.setMovingStartAnchor(true);
            this.mySourceAnchor.setLocation(startPoint);
            helper.update((ConnectionAnchor)this.mySourceAnchor, startPoint);
            helper.setMovingStartAnchor(false);
        }
        super.showCreationFeedback(request);
    }

    protected IFigure getFigure() {
        return ((GraphicalEditPart)this.getHost()).getFigure();
    }

    public void deactivate() {
        super.deactivate();
        ourCommandsCache.clear();
    }
}

