/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.internal.editparts;

import com.tssap.selena.gde.GdeListener;
import com.tssap.selena.gde.IBendpointList;
import com.tssap.selena.gde.IElementViewMap;
import com.tssap.selena.gde.IInplaceController;
import com.tssap.selena.gde.ILinkViewMap;
import com.tssap.selena.gde.INodeViewMap;
import com.tssap.selena.gde.ModelLinkEditPart;
import com.tssap.selena.gde.ModelNodeEditPart;
import com.tssap.selena.gde.internal.DiagramImpl;
import com.tssap.selena.gde.internal.GdePlugin;
import com.tssap.selena.gde.internal.TranslatedXYAnchor;
import com.tssap.selena.gde.internal.commands.InplaceAwareSelectionTool;
import com.tssap.selena.gde.internal.editparts.NodeEditPart;
import com.tssap.selena.gde.viewmap.ILinkDecoration;
import com.tssap.selena.gde.viewmap.IViewMapRecord;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.update.diagram.IDiagram;
import com.tssap.selena.model.update.hierarchy.Revisit;
import com.tssap.selena.ui.IPropertyMarshaler;
import com.tssap.selena.ui.internal.ChromePlugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.swt.widgets.Control;

public class LinkEditPart
extends AbstractConnectionEditPart
implements ModelLinkEditPart {
    private Point myTargetPoint;
    private Point mySourcePoint;
    private String mySourceAnchor;
    private String myTargetAnchor;
    private BendpointList bendpointList;
    private ConnectionAnchor myStartAnchor;
    private ConnectionAnchor myEndAnchor;
    private Map myInplaceControllers;
    private List decorations;
    private DiagramImpl myDiagram;
    private NodeEditPart mySource;
    private Dimension myTargetDecoration;
    private Dimension mySourceDecoration;
    static /* synthetic */ Class class$com$tssap$selena$gde$IElementViewMap$IEditPolicyAdapter;
    static /* synthetic */ Class class$com$tssap$selena$gde$IElementViewMap$IUpdateAdapter;
    static /* synthetic */ Class class$org$eclipse$draw2d$geometry$Point;

    public LinkEditPart(DiagramImpl diagram, Element model, NodeEditPart source) {
        this.myDiagram = diagram;
        this.setModel(model);
        this.myInplaceControllers = new HashMap(5);
        this.prepareBendpointList();
        this.mySource = source;
        this.decorations = new ArrayList(3);
    }

    public NodeEditPart getSourceEditPart() {
        return this.mySource;
    }

    public void addDecoration(ILinkDecoration decoration) {
        this.decorations.add(decoration);
    }

    public ILinkDecoration[] getDecorations() {
        return this.decorations.toArray(new ILinkDecoration[this.decorations.size()]);
    }

    public void removedDecorations() {
        this.decorations.clear();
    }

    public IDiagram getDiagram() {
        return this.myDiagram;
    }

    public Control getDiagramCanvas() {
        return ((NodeEditPart)this.getSource()).getDiagramCanvas();
    }

    public void addGdeListener(GdeListener listener) {
        InplaceAwareSelectionTool.getInstance().addGdeListener(listener, this);
    }

    public void addLinkAsTarget(ConnectionEditPart childEP) {
        Revisit.revisit();
        throw new RuntimeException("link to link does not implemented yet");
    }

    public IBendpointList getBendpointList() {
        return this.bendpointList;
    }

    public Point[] getBendpointLocations() {
        List bendpoints = this.getBendpointList().getBendpoints();
        Point[] bendpointLocations = new Point[bendpoints.size()];
        int i = 0;
        while (i < bendpoints.size()) {
            bendpointLocations[i] = ((Bendpoint)bendpoints.get(i)).getLocation();
            ++i;
        }
        return bendpointLocations;
    }

    public Element getElement() {
        return (Element)this.getModel();
    }

    public IInplaceController getInplaceController(String inplaceID) {
        return (IInplaceController)this.myInplaceControllers.get(inplaceID);
    }

    public ConnectionAnchor getSourceConnectionAnchor(ModelNodeEditPart editPart) {
        if (this.myStartAnchor == null) {
            this.myStartAnchor = new TranslatedXYAnchor(this.getSourcePoint(), editPart.getFigure());
        }
        return this.myStartAnchor;
    }

    public ConnectionAnchor getTargetConnectionAnchor(ModelNodeEditPart editPart) {
        if (this.myEndAnchor == null) {
            this.myEndAnchor = new TranslatedXYAnchor(this.getTargetPoint(), editPart.getFigure());
        }
        return this.myEndAnchor;
    }

    public void removeGdeListener(GdeListener listener) {
        InplaceAwareSelectionTool.getInstance().removeGdeListener(listener, this);
    }

    public void removeLinkAsTarget(ConnectionEditPart childEP) {
        Revisit.revisit();
        throw new RuntimeException("link to link does not implemented yet");
    }

    public void setBendpointLocations(Point[] locations) {
        if (locations == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<AbsoluteBendpoint> bendpoints = new ArrayList<AbsoluteBendpoint>();
        int i = 0;
        while (i < locations.length) {
            bendpoints.add(new AbsoluteBendpoint(locations[i]));
            ++i;
        }
        ((BendpointList)this.getBendpointList()).populate(bendpoints, true);
        if (this.getConnectionFigure() != null) {
            this.getConnectionFigure().setRoutingConstraint(new ArrayList(this.getBendpointList().getBendpoints()));
        }
    }

    public void setInplaceController(String inplaceID, IInplaceController controller) {
        this.myInplaceControllers.put(inplaceID, controller);
    }

    public void setSourceAnchor(String location) {
        this.mySourceAnchor = location;
        if (location != null) {
            StringTokenizer tokenizer = new StringTokenizer(location, ",");
            int x = 0;
            int y = 0;
            try {
                x = Integer.parseInt(tokenizer.nextToken());
                y = Integer.parseInt(tokenizer.nextToken());
            }
            catch (NumberFormatException nfe) {
                y = 0;
                x = 0;
            }
            this.setSourcePoint(new Point(x, y));
        }
    }

    public void setTargetAnchor(String location) {
        this.myTargetAnchor = location;
        if (location != null) {
            StringTokenizer tokenizer = new StringTokenizer(location, ",");
            int x = 0;
            int y = 0;
            try {
                x = Integer.parseInt(tokenizer.nextToken());
                y = Integer.parseInt(tokenizer.nextToken());
            }
            catch (NumberFormatException nfe) {
                y = 0;
                x = 0;
            }
            this.setTargetPoint(new Point(x, y));
        }
    }

    public void setTargetPoint(Point point) {
        if (this.getTarget() != null && ((NodeEditPart)this.getTarget()).getConnectionAnchorAdapter() instanceof INodeViewMap.IFixedConnectionAnchorAdapter) {
            return;
        }
        this.myTargetPoint = point;
        this.myTargetAnchor = point.x + "," + point.y;
        if (this.getConnectionFigure() != null) {
            this.myEndAnchor = new TranslatedXYAnchor(point, ((GraphicalEditPart)this.getTarget()).getFigure());
            this.getConnectionFigure().setTargetAnchor(this.myEndAnchor);
        }
    }

    public Point getTargetPoint() {
        if (this.myTargetPoint == null) {
            if (((NodeEditPart)this.getTarget()).getConnectionAnchorAdapter() instanceof INodeViewMap.IFixedConnectionAnchorAdapter) {
                INodeViewMap.IConnectionAnchorAdapter adapter = ((NodeEditPart)this.getTarget()).getConnectionAnchorAdapter();
                ConnectionAnchor anchor = adapter.getTargetConnectionAnchor((ModelNodeEditPart)this.getTarget(), (ConnectionEditPart)this);
                this.myTargetPoint = anchor.getReferencePoint();
            } else {
                this.myTargetPoint = new Point(0, 0);
            }
        }
        return this.myTargetPoint;
    }

    public void setSourcePoint(Point point) {
        if (this.getSource() != null && ((NodeEditPart)this.getSource()).getConnectionAnchorAdapter() instanceof INodeViewMap.IFixedConnectionAnchorAdapter) {
            return;
        }
        this.mySourcePoint = point;
        this.mySourceAnchor = point.x + "," + point.y;
        if (this.getConnectionFigure() != null) {
            this.myStartAnchor = new TranslatedXYAnchor(point, ((GraphicalEditPart)this.getSource()).getFigure());
            this.getConnectionFigure().setSourceAnchor(this.myStartAnchor);
        }
    }

    public Point getSourcePoint() {
        if (this.mySourcePoint == null) {
            if (((NodeEditPart)this.getSource()).getConnectionAnchorAdapter() instanceof INodeViewMap.IFixedConnectionAnchorAdapter) {
                INodeViewMap.IConnectionAnchorAdapter adapter = ((NodeEditPart)this.getSource()).getConnectionAnchorAdapter();
                ConnectionAnchor anchor = adapter.getSourceConnectionAnchor((ModelNodeEditPart)this.getSource(), (ConnectionEditPart)this);
                this.mySourcePoint = anchor.getReferencePoint();
            } else {
                this.mySourcePoint = new Point(0, 0);
            }
        }
        return this.mySourcePoint;
    }

    public String getSourceAnchor() {
        return this.mySourceAnchor;
    }

    public String getTargetAnchor() {
        return this.myTargetAnchor;
    }

    public IFigure getOriginalFigure() {
        return this.getFigure();
    }

    protected void createEditPolicies() {
        IViewMapRecord viewMapRecord = this.getViewMapRecord();
        IElementViewMap.IEditPolicyAdapter adapter = (IElementViewMap.IEditPolicyAdapter)viewMapRecord.getViewMap().getAdapter(class$com$tssap$selena$gde$IElementViewMap$IEditPolicyAdapter == null ? (class$com$tssap$selena$gde$IElementViewMap$IEditPolicyAdapter = LinkEditPart.class$("com.tssap.selena.gde.IElementViewMap$IEditPolicyAdapter")) : class$com$tssap$selena$gde$IElementViewMap$IEditPolicyAdapter);
        if (adapter != null) {
            adapter.createEditPolicies(this, viewMapRecord.getParameters());
        }
    }

    protected IFigure createFigure() {
        IViewMapRecord record = this.getViewMapRecord();
        Connection connection = (Connection)record.getViewMap().createFigure(this, record.getParameters());
        ConnectionLayer layer = (ConnectionLayer)this.getLayer("Connection Layer");
        connection.setConnectionRouter(layer.getConnectionRouter());
        return connection;
    }

    protected ILinkViewMap getViewMap() {
        return (ILinkViewMap)this.getViewMapRecord().getViewMap();
    }

    protected IViewMapRecord getViewMapRecord() {
        return GdePlugin.getDefault().createLinkViewMapRecord(this);
    }

    protected void refreshVisuals() {
        IViewMapRecord record = this.getViewMapRecord();
        IElementViewMap viewMap = record.getViewMap();
        IElementViewMap.IUpdateAdapter adapter = (IElementViewMap.IUpdateAdapter)viewMap.getAdapter(class$com$tssap$selena$gde$IElementViewMap$IUpdateAdapter == null ? (class$com$tssap$selena$gde$IElementViewMap$IUpdateAdapter = LinkEditPart.class$("com.tssap.selena.gde.IElementViewMap$IUpdateAdapter")) : class$com$tssap$selena$gde$IElementViewMap$IUpdateAdapter);
        if (adapter != null && this.getModel() != null && !((Element)this.getModel()).isDeleted()) {
            if (this.getModel() instanceof Reference && ((Reference)this.getModel()).getEntity().isDeleted()) {
                return;
            }
            adapter.refreshVisuals(this, record.getParameters());
        }
    }

    public void dispose() {
        InplaceAwareSelectionTool.getInstance().removeAllGdeListeners(this);
        if (this.getParent() != null) {
            super.dispose();
        }
        AbstractEditPart.EditPolicyIterator it = this.getEditPolicyIterator();
        while (it.hasNext()) {
            it.next().deactivate();
        }
    }

    public void setSourceDecoration(Dimension size) {
        this.mySourceDecoration = size;
    }

    public void setTargetDecoration(Dimension size) {
        this.myTargetDecoration = size;
    }

    public Dimension getSourceDecoration() {
        return this.mySourceDecoration;
    }

    public Dimension getTargetDecoration() {
        return this.myTargetDecoration;
    }

    private String getBendpointsAsString() {
        String value = null;
        IPropertyMarshaler marshaller = ChromePlugin.getInstance().getPropertyMarshaler((Object)IBendpointList.MARSHALLER_ID);
        if (marshaller != null) {
            value = marshaller.marshal((Object)this.getBendpointList().getBendpoints());
        }
        return value;
    }

    private void prepareBendpointList() {
        if (this.bendpointList == null) {
            this.bendpointList = new BendpointList();
        }
    }

    private Point readPoint(String value) {
        try {
            IPropertyMarshaler marshaller = ChromePlugin.getInstance().getPropertyMarshaler((Object)(class$org$eclipse$draw2d$geometry$Point == null ? (class$org$eclipse$draw2d$geometry$Point = LinkEditPart.class$("org.eclipse.draw2d.geometry.Point")) : class$org$eclipse$draw2d$geometry$Point).getName());
            return (Point)marshaller.unmarshal(value);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static IBendpointList createBendpointList(Collection points) {
        BendpointList list = new BendpointList();
        list.populate(points, false);
        return list;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class BendpointList
    implements IBendpointList {
        private List bendpoints = new ArrayList();

        BendpointList() {
        }

        public void populate(Collection newBendpoints, boolean setPropertyValue) {
            this.bendpoints.clear();
            Iterator itr = newBendpoints.iterator();
            while (itr.hasNext()) {
                Bendpoint bp = (Bendpoint)itr.next();
                this.bendpoints.add(bp);
            }
        }

        public List getBendpoints() {
            return this.bendpoints;
        }

        public Bendpoint[] getBendpointsAsArray() {
            return this.bendpoints.toArray(new Bendpoint[this.bendpoints.size()]);
        }

        public void insertBendpoint(int index, Bendpoint bendpoint) {
        }

        public void removeBendpoint(int index) {
        }

        public void setBendpoint(int index, Bendpoint bendpoint) {
        }
    }
}

