/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.internal.commands;

import com.tssap.selena.gde.internal.commands.AbstractSelectLaterCommand;
import com.tssap.selena.gde.internal.commands.ConnectionRedirectionCommand;
import com.tssap.selena.model.elements.Container;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.util.UpdateCommand;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.requests.ReconnectRequest;

public class RedirectSourceCommand
extends ConnectionRedirectionCommand {
    private Boolean myCanExecute;
    private GraphicalEditPart myCurrentSourceEP;
    private GraphicalEditPart myNewSourceEP;
    private ConnectionEditPart myConnectionEP;
    private Element myCachedCurrentSource;
    private Element myCachedNewSource;
    private Entity myCachedLink;
    private String myCachedRole;

    public RedirectSourceCommand() {
    }

    public RedirectSourceCommand(ReconnectRequest request) {
        this.setNewSourceEP((GraphicalEditPart)request.getTarget());
        ConnectionEditPart connectionEP = request.getConnectionEditPart();
        this.setCurrentSourceEP((GraphicalEditPart)connectionEP.getSource());
        this.setConnectionEP(connectionEP);
    }

    public boolean canExecute() {
        if (this.myCanExecute != null) {
            return this.myCanExecute;
        }
        Element newSource = this.getNewSource();
        boolean result = false;
        if (newSource instanceof Container) {
            if (newSource.equals(this.getCurrentSource())) {
                result = true;
            } else if (this.getLink() != null && this.getLink().canCopy() && this.getLink().canDelete()) {
                Entity template = this.getLink().getModel().createEntityTemplate(this.getLink());
                if (((Container)this.getNewSource()).canCreateChildEntity(this.getLink().getPropertyValue("$metaclass"), template)) {
                    Entity copiedLink = this.getLink().copy();
                    result = copiedLink != null && ((Container)newSource).canPaste((Element)copiedLink);
                }
            }
        }
        this.myCanExecute = new Boolean(result);
        return result;
    }

    public void execute() {
        if (!(this.getNewSource() instanceof Container)) {
            return;
        }
        if (this.getNewSource().equals(this.getCurrentSource())) {
            return;
        }
        if (this.getLink() == null) {
            return;
        }
        ModelAccess.runCommand((Runnable)new UpdateCommand(){

            public void run() {
                if (RedirectSourceCommand.this.getLink().canCopy()) {
                    Element pastedLink;
                    Entity copiedLink = RedirectSourceCommand.this.getLink().copy();
                    if (copiedLink == null) {
                        return;
                    }
                    if (((Container)RedirectSourceCommand.this.getNewSource()).canPaste((Element)copiedLink) && (pastedLink = ((Container)RedirectSourceCommand.this.getNewSource()).paste((Element)copiedLink)) instanceof Entity) {
                        AbstractSelectLaterCommand.selectNewEntityLater(AbstractSelectLaterCommand.findDiagram((GraphicalEditPart)RedirectSourceCommand.this.getConnectionEP()), (Entity)pastedLink);
                        if (RedirectSourceCommand.this.getLink().canDelete()) {
                            RedirectSourceCommand.this.getLink().delete();
                        }
                    }
                }
            }
        });
    }

    public ConnectionEditPart getConnectionEP() {
        return this.myConnectionEP;
    }

    public void setCurrentSourceEP(GraphicalEditPart currentSourceEP) {
        this.myCurrentSourceEP = currentSourceEP;
        this.myCachedCurrentSource = null;
    }

    public void setNewSourceEP(GraphicalEditPart newSourceEP) {
        this.myNewSourceEP = newSourceEP;
        this.myCachedNewSource = null;
    }

    public void setConnectionEP(ConnectionEditPart connectionEP) {
        this.myConnectionEP = connectionEP;
        this.myCachedLink = null;
    }

    private Element getCurrentSource() {
        if (this.myCachedCurrentSource == null) {
            this.myCachedCurrentSource = ConnectionRedirectionCommand.resolve2Element(this.myCurrentSourceEP);
        }
        return this.myCachedCurrentSource;
    }

    private Element getNewSource() {
        if (this.myCachedNewSource == null) {
            this.myCachedNewSource = ConnectionRedirectionCommand.resolve2Element(this.myNewSourceEP);
        }
        return this.myCachedNewSource;
    }

    private Entity getLink() {
        if (this.myCachedLink == null) {
            this.myCachedLink = ConnectionRedirectionCommand.resolve2Element((GraphicalEditPart)this.myConnectionEP);
        }
        return this.myCachedLink;
    }

    private String getLinkRole() {
        return "Client";
    }
}

