/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.internal.commands;

import com.tssap.selena.gde.IBendpointList;
import com.tssap.selena.gde.ModelElementEditPart;
import com.tssap.selena.gde.internal.DiagramElement;
import com.tssap.selena.gde.internal.DiagramImpl;
import com.tssap.selena.gde.internal.DiagramLink;
import com.tssap.selena.gde.internal.DiagramNode;
import com.tssap.selena.gde.internal.editparts.LinkEditPart;
import com.tssap.selena.gde.viewmap.ILinkDecoration;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.ui.internal.ChromePlugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.AbstractCommand;

public class MoveLinkCommand
extends AbstractCommand {
    private Collection myEditParts;
    private Dimension myDelta;

    public MoveLinkCommand(Collection editParts, Point delta) {
        if (delta != null) {
            this.myDelta = new Dimension(delta.x, delta.y);
        }
        this.myEditParts = editParts;
    }

    public void execute() {
        ModelAccess.runCommand((Runnable)new Runnable(){

            public void run() {
                MoveLinkCommand.this.updateLinks();
                MoveLinkCommand.this.doLayout();
            }
        });
    }

    private void doLayout() {
    }

    private void updateLinks() {
        ArrayList<DiagramLink> linksList = new ArrayList<DiagramLink>();
        ArrayList editParts = new ArrayList();
        DiagramImpl diagram = null;
        Iterator eps = this.myEditParts.iterator();
        while (eps.hasNext()) {
            ModelElementEditPart ep = (ModelElementEditPart)eps.next();
            if (ep.getParent() == null || (diagram = (DiagramImpl)ep.getDiagram()) == null) continue;
            diagram.deferRefresh((DiagramElement)diagram.findDiagramElement((Reference)ep.getModel()), false, true);
            MoveLinkCommand.collectChildren(editParts, ep);
        }
        if (diagram == null) {
            return;
        }
        if (this.myDelta == null) {
            diagram.doPartialLayout();
            return;
        }
        Iterator links = diagram.links().iterator();
        while (links.hasNext()) {
            DiagramLink link = (DiagramLink)links.next();
            if (!editParts.contains(((DiagramNode)link.getSourceNode()).getEditPart()) || !editParts.contains(((DiagramNode)link.getTargetElement()).getEditPart())) continue;
            linksList.add(link);
        }
        Iterator it = linksList.iterator();
        while (it.hasNext()) {
            DiagramLink next = (DiagramLink)it.next();
            Point[] bendPoints = next.getLinkEditPart().getBendpointLocations();
            int i = 0;
            while (i < bendPoints.length) {
                bendPoints[i].translate(this.myDelta);
                ++i;
            }
            Point source = next.getLinkEditPart().getSourcePoint();
            Point target = next.getLinkEditPart().getTargetPoint();
            source.translate(this.myDelta);
            target.translate(this.myDelta);
            ILinkDecoration[] decorations = next.getLinkEditPart().getDecorations();
            int i2 = 0;
            while (i2 < decorations.length) {
                Rectangle bounds = new Rectangle(decorations[i2].getBounds());
                bounds.translate(new Point(this.myDelta.width, this.myDelta.height));
                decorations[i2].setBounds(bounds);
                ++i2;
            }
            next.getLinkEditPart().setBendpointLocations(bendPoints);
            next.getLinkEditPart().setSourcePoint(source);
            next.getLinkEditPart().setTargetPoint(target);
            next.getLinkEditPart().refresh();
            LinkEditPart editPart = next.getLinkEditPart();
            String bendpointsStr = ChromePlugin.getInstance().getPropertyMarshaler((Object)IBendpointList.MARSHALLER_ID).marshal((Object)editPart.getBendpointList().getBendpoints());
            next.getContent().setPropertyValue("sourceAnchor", next.getLinkEditPart().getSourceAnchor());
            next.getContent().setPropertyValue("targetAnchor", next.getLinkEditPart().getTargetAnchor());
            next.getContent().setPropertyValue("bendpoints", bendpointsStr);
            next.getDiagram().addResizedObject(next);
        }
        if (diagram == null) {
            return;
        }
        diagram.doPartialLayout();
        Iterator eps2 = this.myEditParts.iterator();
        while (eps2.hasNext()) {
            ModelElementEditPart ep = (ModelElementEditPart)eps2.next();
            if (ep.getParent() == null) continue;
            diagram.addResizedObject(ep.getModel());
        }
        Iterator it2 = linksList.iterator();
        while (it2.hasNext()) {
            DiagramLink next = (DiagramLink)it2.next();
            diagram.addResizedObject(next.getContent());
        }
    }

    private static void collectChildren(Collection collection, GraphicalEditPart ep) {
        collection.add(ep);
        collection.addAll(ep.getChildren());
        Iterator children = ep.getChildren().iterator();
        while (children.hasNext()) {
            MoveLinkCommand.collectChildren(collection, (GraphicalEditPart)children.next());
        }
    }
}

