/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.internal.commands;

import com.tssap.selena.gde.internal.commands.AutoscrollSupport;
import com.tssap.selena.gde.internal.commands.CreateLinkRequest;
import com.tssap.selena.gde.internal.commands.LinkFactory;
import com.tssap.selena.gde.internal.commands.ScrollableTool;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.tools.ConnectionDragCreationTool;
import org.eclipse.swt.events.MouseEvent;

public class LinkCreationTool
extends ConnectionDragCreationTool
implements IExecutableExtension,
ScrollableTool {
    protected IConfigurationElement myConfig;
    private boolean myJustStarted;
    private boolean myCanBeCreated;
    private boolean myWasButtonDown = false;
    private AutoscrollSupport myAutoscroller = new AutoscrollSupport(this, false);
    private Point myStartLocation = null;
    private EditPart myConnectionSource;

    protected Request createTargetRequest() {
        this.myWasButtonDown = false;
        return new CreateLinkRequest(new LinkFactory(this.myConfig));
    }

    public void mouseDragCausedByScroller(MouseEvent event, EditPartViewer viewer) {
        Point startLocation = this.getStartPoint(this.getStartLocation());
        startLocation.x -= this.myAutoscroller.getXShift();
        startLocation.y -= this.myAutoscroller.getYShift();
        Request request = this.getTargetRequest();
        if (request == null || !(request instanceof CreateLinkRequest)) {
            return;
        }
        ((CreateLinkRequest)request).setStartPoint(startLocation);
        super.mouseDrag(event, viewer);
    }

    public void mouseDrag(MouseEvent mouseEvent, EditPartViewer view) {
        this.myAutoscroller.mouseDrag(mouseEvent, view);
        super.mouseDrag(mouseEvent, view);
    }

    public void mouseMove(MouseEvent mouseEvent, EditPartViewer view) {
        this.myAutoscroller.mouseMove(mouseEvent, view);
        super.mouseMove(mouseEvent, view);
    }

    public void mouseUp(MouseEvent mouseEvent, EditPartViewer view) {
        this.myAutoscroller.mouseUp(mouseEvent, view);
        super.mouseUp(mouseEvent, view);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.myConfig = config;
    }

    protected boolean handleButtonDown(int button) {
        this.myJustStarted = true;
        this.myWasButtonDown = true;
        if (this.getTargetRequest() instanceof CreateLinkRequest) {
            CreateLinkRequest req = (CreateLinkRequest)this.getTargetRequest();
            this.myCanBeCreated = req.getStartCommand() != null ? req.getStartCommand().canExecute() : true;
        }
        if (this.isInState(1) && button == 1) {
            this.updateTargetRequest();
            this.updateTargetUnderMouse();
            this.myConnectionSource = this.getTargetEditPart();
            ((CreateConnectionRequest)this.getTargetRequest()).setSourceEditPart(this.getTargetEditPart());
            if (this.getCommand() != null) {
                this.setState(64);
                this.setCurrentCommand(this.getCommand());
            }
        }
        if (this.isInState(1) && button != 1) {
            this.setState(8);
            this.handleInvalidInput();
        }
        this.setState(2);
        return true;
    }

    protected boolean handleButtonUp(int button) {
        if (!this.myWasButtonDown) {
            return false;
        }
        this.handleDragStarted();
        boolean result = super.handleButtonUp(button);
        this.myConnectionSource = null;
        return result;
    }

    protected boolean handleDrag() {
        if (!this.myCanBeCreated) {
            return false;
        }
        this.myJustStarted = false;
        return super.handleDrag();
    }

    protected boolean handleCreateConnection() {
        boolean bl;
        try {
            this.eraseTargetFeedback();
            this.eraseSourceFeedback();
            boolean result = true;
            if (!this.myJustStarted) {
                result = super.handleCreateConnection();
            }
            this.setCurrentCommand(null);
            this.setTargetEditPart(null);
            this.setTargetRequest(null);
            bl = result;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.getDomain().loadDefaultTool();
            throw throwable;
        }
        this.getDomain().loadDefaultTool();
        return bl;
    }

    protected void showSourceFeedback() {
        super.showSourceFeedback();
        if (this.myConnectionSource != null) {
            this.myConnectionSource.showSourceFeedback(this.getSourceRequest());
        }
    }

    protected void eraseSourceFeedback() {
        super.eraseSourceFeedback();
        if (this.myConnectionSource != null) {
            this.myConnectionSource.eraseSourceFeedback(this.getSourceRequest());
        }
    }

    private Point getStartPoint(Point original) {
        if (this.myStartLocation == null) {
            this.myStartLocation = new Point();
        }
        this.myStartLocation.x = original.x;
        this.myStartLocation.y = original.y;
        return this.myStartLocation;
    }
}

