/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.internal.commands;

import com.tssap.selena.gde.EditPartElementWrapper;
import com.tssap.selena.gde.ExtendedGdeListener;
import com.tssap.selena.gde.GdeListener;
import com.tssap.selena.gde.ModelElementEditPart;
import com.tssap.selena.gde.internal.commands.AutoscrollSupport;
import com.tssap.selena.gde.internal.commands.HashBag;
import com.tssap.selena.gde.internal.commands.ScrollableTool;
import com.tssap.selena.gde.internal.editparts.DiagramEditPart;
import com.tssap.selena.gde.internal.editparts.NodeEditPart;
import com.tssap.selena.gde.internal.tools.MarqueeDragTracker;
import com.tssap.selena.internal.model.ui.ModelUIPlugin;
import com.tssap.selena.model.elements.Element;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.tools.ConnectionBendpointTracker;
import org.eclipse.gef.tools.ConnectionDragCreationTool;
import org.eclipse.gef.tools.ConnectionEndpointTracker;
import org.eclipse.gef.tools.SelectionTool;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.ui.PlatformUI;

public class InplaceAwareSelectionTool
extends SelectionTool
implements ScrollableTool {
    private static InplaceAwareSelectionTool myInstance = new InplaceAwareSelectionTool();
    private final HashBag myListeners = new HashBag();
    private AutoscrollSupport myAutoscroller = new AutoscrollSupport(this, true);

    public static InplaceAwareSelectionTool getInstance() {
        return myInstance;
    }

    private InplaceAwareSelectionTool() {
    }

    public void setDragTracker(DragTracker newDragTracker) {
        if (newDragTracker instanceof ConnectionDragCreationTool || newDragTracker instanceof ConnectionBendpointTracker || newDragTracker instanceof ConnectionEndpointTracker || newDragTracker instanceof MarqueeDragTracker) {
            this.myAutoscroller.setTransformEventsMode(false);
        } else {
            this.myAutoscroller.setTransformEventsMode(true);
        }
        super.setDragTracker(newDragTracker);
    }

    public void mouseDragCausedByScroller(MouseEvent mouseEvent, EditPartViewer view) {
        if (this.getDragTracker() != null) {
            this.getDragTracker().mouseDrag(mouseEvent, view);
        }
    }

    public void mouseDrag(MouseEvent mouseEvent, EditPartViewer view) {
        this.myAutoscroller.mouseDrag(mouseEvent, view);
        super.mouseDrag(mouseEvent, view);
        Iterator it = this.myListeners.getValues(this.getTargetEditPart()).iterator();
        while (it.hasNext()) {
            ((GdeListener)it.next()).mouseDrag(mouseEvent);
        }
    }

    public void keyDown(KeyEvent keyEvent, EditPartViewer view) {
        super.keyDown(keyEvent, view);
        Iterator it = this.myListeners.getValues(this.getTargetEditPart()).iterator();
        while (it.hasNext()) {
            ((GdeListener)it.next()).keyPressed(keyEvent);
        }
    }

    public void keyUp(KeyEvent keyEvent, EditPartViewer view) {
        super.keyUp(keyEvent, view);
        Iterator it = this.myListeners.getValues(this.getTargetEditPart()).iterator();
        while (it.hasNext()) {
            ((GdeListener)it.next()).keyReleased(keyEvent);
        }
        if (keyEvent.stateMask == 0 && keyEvent.character == '\u007f' && this.isEntireDiagramSelected(view)) {
            return;
        }
        ModelUIPlugin.getDefault().getKeyboardNotifier().keyPressed(keyEvent, null);
    }

    private boolean isEntireDiagramSelected(EditPartViewer view) {
        ArrayList<ModelElementEditPart> selectedParts = view.getSelectedEditParts();
        if (selectedParts == null) {
            return false;
        }
        if (selectedParts.size() == 0) {
            selectedParts = new ArrayList<ModelElementEditPart>();
            ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
            if (selection instanceof IStructuredSelection) {
                Iterator it = ((IStructuredSelection)selection).iterator();
                while (it.hasNext()) {
                    Object nextSelectedObject = it.next();
                    if (!(nextSelectedObject instanceof EditPartElementWrapper)) continue;
                    selectedParts.add(((EditPartElementWrapper)((Object)nextSelectedObject)).getEditPart());
                }
            }
        }
        Iterator parts = selectedParts.iterator();
        while (parts.hasNext()) {
            if (!(parts.next() instanceof DiagramEditPart)) continue;
            return true;
        }
        return false;
    }

    private ISelection getSelection(EditPartViewer view) {
        List selectedEPs = view.getSelectedEditParts();
        ArrayList<EditPartElementWrapper> wrappers = new ArrayList<EditPartElementWrapper>(selectedEPs.size());
        Iterator it = selectedEPs.iterator();
        while (it.hasNext()) {
            ModelElementEditPart ep = (ModelElementEditPart)it.next();
            wrappers.add(new EditPartElementWrapper(ep));
        }
        return new StructuredSelection(wrappers);
    }

    public void mouseMove(MouseEvent mouseEvent, EditPartViewer view) {
        this.myAutoscroller.mouseMove(mouseEvent, view);
        super.mouseMove(mouseEvent, view);
        Iterator it = this.myListeners.getValues(this.getTargetEditPart()).iterator();
        while (it.hasNext()) {
            GdeListener listener = (GdeListener)it.next();
            listener.mouseMove(mouseEvent);
        }
    }

    public void mouseDown(MouseEvent mouseEvent, EditPartViewer view) {
        Point point = new Point(mouseEvent.x, mouseEvent.y);
        EditPart part = view.findObjectAt(point);
        if (view.getContents() instanceof GraphicalEditPart) {
            ((GraphicalEditPart)view.getContents()).getFigure().translateToRelative((Translatable)point);
            if (part instanceof NodeEditPart) {
                point = InplaceAwareSelectionTool.translateToRelative((GraphicalEditPart)view.getContents(), (GraphicalEditPart)part, point);
                ((NodeEditPart)part).setUserProperty("bounds", point.x + "," + point.y + ",0,0");
            }
        }
        boolean wasSelected = InplaceAwareSelectionTool.isSelected(this.getTargetEditPart(), view);
        super.mouseDown(mouseEvent, view);
        Iterator it = this.myListeners.getValues(this.getTargetEditPart()).iterator();
        while (it.hasNext()) {
            GdeListener next = (GdeListener)it.next();
            next.mouseDown(mouseEvent);
            if (!(next instanceof ExtendedGdeListener)) continue;
            ((ExtendedGdeListener)next).mouseDown(mouseEvent, wasSelected);
        }
    }

    public void mouseUp(MouseEvent mouseEvent, EditPartViewer view) {
        this.myAutoscroller.mouseUp(mouseEvent, view);
        super.mouseUp(mouseEvent, view);
        Iterator it = this.myListeners.getValues(this.getTargetEditPart()).iterator();
        while (it.hasNext()) {
            ((GdeListener)it.next()).mouseUp(mouseEvent);
        }
    }

    public void mouseDoubleClick(MouseEvent mouseEvent, EditPartViewer view) {
        super.mouseDoubleClick(mouseEvent, view);
        Iterator it = this.myListeners.getValues(this.getTargetEditPart()).iterator();
        while (it.hasNext()) {
            GdeListener listener = (GdeListener)it.next();
            listener.mouseDoubleClick(mouseEvent);
        }
    }

    public void addGdeListener(GdeListener listener, ModelElementEditPart editPart) {
        this.myListeners.put((Object)editPart, listener);
    }

    public void removeGdeListener(GdeListener listener, ModelElementEditPart editPart) {
        this.myListeners.remove((Object)editPart, listener);
    }

    public void removeAllGdeListeners(ModelElementEditPart editPart) {
        this.myListeners.removeAll(editPart);
    }

    private static Point translateToRelative(GraphicalEditPart root, GraphicalEditPart target, Point point) {
        if (!target.equals(root)) {
            point.x -= target.getContentPane().getBounds().x;
            point.y -= target.getContentPane().getBounds().y;
            if (target.getContentPane().getLayoutManager() instanceof XYLayout) {
                if (point.x < 0) {
                    point.x = 0;
                }
                if (point.y < 0) {
                    point.y = 0;
                }
            }
        }
        return point;
    }

    private void dumpSelection(EditPartViewer viewer) {
        List selectedEPs = viewer.getSelectedEditParts();
        if (selectedEPs == null || selectedEPs.isEmpty()) {
            System.err.println("--NOTHING--");
            return;
        }
        Iterator it = selectedEPs.iterator();
        while (it.hasNext()) {
            EditPart next = (EditPart)it.next();
            System.err.println("\t: " + InplaceAwareSelectionTool.toString(next));
        }
    }

    private static boolean isSelected(EditPart ep, EditPartViewer viewer) {
        if (viewer == null || ep == null) {
            return false;
        }
        List selectedEPs = viewer.getSelectedEditParts();
        return selectedEPs != null && selectedEPs.contains(ep);
    }

    private static String toString(EditPart ep) {
        if (ep instanceof ModelElementEditPart) {
            Element content = ((ModelElementEditPart)ep).getElement();
            return content == null ? "null" : content.getPropertyValue("$name");
        }
        return "" + ep;
    }
}

