/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.internal.commands;

import com.tssap.selena.gde.ModelElementEditPart;
import com.tssap.selena.gde.internal.DiagramImpl;
import com.tssap.selena.gde.internal.DiagramViewer;
import com.tssap.selena.gde.internal.commands.ElementCreationTool;
import com.tssap.selena.gde.zoom.Zoomer;
import com.tssap.selena.gde.zoom.requests.CreateRequest;
import com.tssap.selena.internal.model.ui.ModelUIPlugin;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.ReferenceContainer;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.ui.actions.AbstractSelectionAwareAction;
import com.tssap.selena.model.util.UpdateCommand;
import com.tssap.selena.ui.IPropertyMarshaler;
import com.tssap.selena.ui.internal.ChromePlugin;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.tools.CreationTool;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;

public class ElementCreationTool
extends CreationTool
implements IExecutableExtension {
    private Object myWasExecuted = Boolean.FALSE;
    private String myMetaClass;
    private int myWidth;
    private int myHeight;
    private int myMinimumWidth;
    private int myMinimumHeight;
    private HashMap myEntityInitialProperties;
    private boolean myIsAutoSize;
    private String myPredefinedName = null;
    private boolean myInvokeInplace;
    private String myNavigate;
    private static String NEVER = "never";
    private static String DEPEND = "depend";
    private static String ALWAYS = "always";
    private boolean myIsNotResizable;
    private int myIsNotResizableHeight;
    private int myIsNotResizableWidth;
    private static final int MIN_WIDTH = 30;
    private static final int MIN_HEIGHT = 30;
    static /* synthetic */ Class class$org$eclipse$draw2d$geometry$Rectangle;

    public ElementCreationTool() {
        this.setFactory(new ElementFactory());
    }

    protected Request createTargetRequest() {
        EditPartViewer epViewer = this.getCurrentViewer();
        Zoomer zoomer = epViewer == null || !(epViewer instanceof DiagramViewer) ? new Zoomer() : ((DiagramViewer)epViewer).getZoomer();
        CreateRequest request = new CreateRequest(zoomer);
        request.setFactory(this.getFactory());
        return request;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        IConfigurationElement[] entityName;
        IConfigurationElement[] entityCE;
        this.myMetaClass = config.getAttribute("metaclass");
        this.myInvokeInplace = !Boolean.FALSE.toString().equals(config.getAttribute("invokeInplaceAfterCreation"));
        this.myIsNotResizable = Boolean.FALSE.toString().equals(config.getAttributeAsIs("resizable"));
        try {
            this.myIsNotResizableHeight = Integer.parseInt(config.getAttributeAsIs("non_resizable_height"));
        }
        catch (NumberFormatException nfe) {
            this.myIsNotResizableHeight = 0;
        }
        try {
            this.myIsNotResizableWidth = Integer.parseInt(config.getAttributeAsIs("non_resizable_width"));
        }
        catch (NumberFormatException nfe) {
            this.myIsNotResizableWidth = 0;
        }
        this.myNavigate = config.getAttributeAsIs("navigate");
        if (this.myNavigate == null) {
            this.myNavigate = NEVER;
        }
        if ((entityCE = config.getChildren("entity")).length > 0) {
            this.myEntityInitialProperties = new HashMap();
            int ei = 0;
            while (ei < entityCE.length) {
                IConfigurationElement[] propertyCE = entityCE[ei].getChildren("property");
                int pi = 0;
                while (pi < propertyCE.length) {
                    String name = propertyCE[pi].getAttribute("name");
                    String value = propertyCE[pi].getAttribute("value");
                    this.myEntityInitialProperties.put(name, value);
                    ++pi;
                }
                ++ei;
            }
        }
        if ((entityName = config.getChildren("nametemplate")).length > 0) {
            this.myPredefinedName = entityName[0].getAttribute("value");
        }
    }

    protected String getMetaClass() {
        return this.myMetaClass;
    }

    protected String getPredefinedName() {
        return this.myPredefinedName;
    }

    protected int getDefaultWidth() {
        return 0;
    }

    protected int getMinimumWidth() {
        return 30;
    }

    protected int getMinimumHeight() {
        return 30;
    }

    protected int getDefaultHeight() {
        return 0;
    }

    protected boolean handleButtonUp(int button) {
        Object object = this.myWasExecuted;
        synchronized (object) {
            try {
                boolean result;
                boolean bl = result = super.handleButtonUp(button);
                Object var6_5 = null;
                this.myWasExecuted = Boolean.FALSE;
                return bl;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.myWasExecuted = Boolean.FALSE;
                throw throwable;
            }
        }
    }

    protected String makeBoundsAsString() {
        Dimension size;
        IFigure contentPane = ((GraphicalEditPart)this.getTargetEditPart()).getContentPane();
        IFigure rootFigure = ((GraphicalEditPart)this.getTargetEditPart()).getFigure();
        Point startLocation = new Point(this.getStartLocation());
        contentPane.translateToRelative((Translatable)startLocation);
        startLocation.translate(contentPane.getBounds().getLocation().getNegated());
        startLocation.translate(rootFigure.getBounds().getLocation());
        Point location = new Point(this.getLocation());
        contentPane.translateToRelative((Translatable)location);
        location.translate(contentPane.getBounds().getLocation().getNegated());
        location.translate(rootFigure.getBounds().getLocation());
        Dimension difference = location.getDifference(startLocation);
        if (difference.width < this.getMinimumHeight() && difference.height < this.getMinimumWidth() || this.myIsNotResizable) {
            size = new Dimension(this.getDefaultWidth(), this.getDefaultHeight());
            this.setAutoSize(true);
        } else {
            size = location.getDifference(startLocation);
            if (size.width < 0) {
                size.width = -size.width;
                startLocation.x = location.x;
            }
            if (size.height < 0) {
                size.height = -size.height;
                startLocation.y = location.y;
            }
            this.setAutoSize(false);
            if (size.width < this.getMinimumWidth() && size.height < this.getMinimumHeight()) {
                size = new Dimension(this.getDefaultWidth(), this.getDefaultHeight());
                this.setAutoSize(true);
            } else if (size.width < this.getMinimumWidth() || size.height < this.getMinimumHeight()) {
                size = new Dimension(Math.max(size.width, this.getMinimumWidth()), Math.max(size.height, this.getMinimumHeight()));
            }
            if (this.myIsNotResizableHeight > 0) {
                size.height = this.myIsNotResizableHeight;
            }
            if (this.myIsNotResizableWidth > 0) {
                size.width = this.myIsNotResizableWidth;
            }
        }
        if (this.getTargetEditPart() instanceof AbstractGraphicalEditPart) {
            startLocation.translate(((AbstractGraphicalEditPart)this.getTargetEditPart()).getFigure().getBounds().getLocation().getNegated());
        }
        Rectangle rect = new Rectangle(startLocation, size);
        IPropertyMarshaler marshaller = ChromePlugin.getInstance().getPropertyMarshaler((Object)(class$org$eclipse$draw2d$geometry$Rectangle == null ? (class$org$eclipse$draw2d$geometry$Rectangle = ElementCreationTool.class$("org.eclipse.draw2d.geometry.Rectangle")) : class$org$eclipse$draw2d$geometry$Rectangle).getName());
        if (contentPane.getLayoutManager() instanceof XYLayout) {
            if (rect.x < 0) {
                rect.x = 0;
            }
            if (rect.y < 0) {
                rect.y = 0;
            }
        }
        return marshaller.marshal((Object)rect);
    }

    protected Object createObject() {
        Property invokeInplace;
        Entity parent;
        ReferenceCollection diagram;
        if (this.getTargetEditPart() == null) {
            return null;
        }
        if (!(this.getTargetEditPart().getModel() instanceof ReferenceContainer)) {
            return null;
        }
        ReferenceContainer targetReferenceContainer = (ReferenceContainer)this.getTargetEditPart().getModel();
        boolean addedToDiagram = false;
        boolean skipBounds = false;
        if (targetReferenceContainer instanceof ReferenceCollection) {
            addedToDiagram = true;
            diagram = (ReferenceCollection)this.getTargetEditPart().getModel();
            parent = diagram.getParent();
        } else if (targetReferenceContainer instanceof Reference) {
            Reference reference = (Reference)targetReferenceContainer;
            diagram = (ReferenceCollection)reference.getParent();
            parent = reference.getEntity();
            if (parent instanceof ReferenceCollection) {
                addedToDiagram = true;
                skipBounds = true;
                diagram = (ReferenceCollection)parent;
                parent = parent.getParent();
            }
        } else {
            return null;
        }
        Model model = diagram.getModel();
        String bounds = this.makeBoundsAsString();
        parent.setPropertyValue("$ActiveDiagramUIN", diagram.getUniqueName().toString());
        ModelElementEditPart tempEditPart = (ModelElementEditPart)this.getTargetEditPart();
        UniqueName currentOpenDiagramUin = ((DiagramImpl)tempEditPart.getDiagram()).getContent().getUniqueName();
        IWorkbenchPage cachedWorkbenchPage = ((DiagramImpl)tempEditPart.getDiagram()).getViewPart().getSite().getPage();
        tempEditPart = null;
        Entity createdEntity = this.actualCreateEntity(model, parent);
        parent.setPropertyValue("$ActiveDiagramUIN", null);
        if (createdEntity != null && this.myInvokeInplace && (invokeInplace = createdEntity.addProperty("#invoke_inplace", "com.tssap.selena.gde.diagramMultiPageView")) != null && invokeInplace.getSubproperties() != null) {
            PropertyMap subProperties = invokeInplace.getSubproperties();
            subProperties.setPropertyValue("#invoke_inplace_parent_uin", ((Element)targetReferenceContainer).getUniqueName().toString());
            String currentOpenDiagram = currentOpenDiagramUin.toString();
            subProperties.setPropertyValue("$ActiveDiagramUIN", currentOpenDiagram);
        }
        if (this.myEntityInitialProperties != null && createdEntity != null) {
            Iterator names = this.myEntityInitialProperties.keySet().iterator();
            while (names.hasNext()) {
                String propertyName = (String)names.next();
                String propertyValue = (String)this.myEntityInitialProperties.get(propertyName);
                if (!createdEntity.hasProperty(propertyName)) {
                    createdEntity.setPropertyValue(propertyName, propertyValue);
                    continue;
                }
                if (createdEntity.hasPropertyValue(propertyName, propertyValue)) continue;
                createdEntity.addProperty(propertyName, propertyValue);
            }
        }
        if (createdEntity != null && this.getDefaultWidth() >= 0 && this.getDefaultHeight() >= 0) {
            Entity diagramForCreated;
            UniqueName uin;
            Object reference = null;
            String uinStr = createdEntity.getPropertyValue("DiagramUIN");
            if (uinStr != null && (uin = ModelAccess.createUniqueName((String)uinStr)) != null && (diagramForCreated = createdEntity.getModel().findEntity(uin)) != null) {
                createdEntity = diagramForCreated;
            }
            this.navigate(createdEntity, cachedWorkbenchPage);
            Reference refTemplate = this.createReferenceTemplate(model, bounds);
            if (skipBounds) {
                refTemplate.setPropertyValue("bounds", null);
                refTemplate.setPropertyValue("bounds_setted_by_user", null);
            }
            if (addedToDiagram) {
                if (AbstractSelectionAwareAction.shouldAddShortcut((ReferenceCollection)diagram, (Entity)createdEntity)) {
                    refTemplate.setPropertyValue("$shortcutReference", Boolean.TRUE.toString());
                }
                return diagram.addReference(createdEntity, refTemplate);
            }
            return targetReferenceContainer.addReference(createdEntity, refTemplate);
        }
        return null;
    }

    protected void navigate(Entity justCreatedEntity, IWorkbenchPage page) {
        if (!NEVER.equals(this.myNavigate)) {
            if (DEPEND.equals(this.myNavigate)) {
                ModelUIPlugin.getDefault().openEditor((Element)justCreatedEntity, page, false);
            } else if (ALWAYS.equals(this.myNavigate)) {
                ModelUIPlugin.getDefault().openEditor((Element)justCreatedEntity, page, true);
            }
        }
    }

    protected Entity actualCreateEntity(Model model, Entity parent) {
        return parent.createChildEntity(this.myMetaClass, this.getTemplate(model));
    }

    protected Entity getTemplate(Model model) {
        Entity template = null;
        if (this.myPredefinedName != null || this.myEntityInitialProperties != null) {
            template = model.createEntityTemplate();
            template.setPropertyValue("$nametemplate", this.myPredefinedName);
            if (this.myEntityInitialProperties != null) {
                Iterator names = this.myEntityInitialProperties.keySet().iterator();
                while (names.hasNext()) {
                    String propertyValue;
                    String propertyName = (String)names.next();
                    if (!template.canSetPropertyValue(propertyName, propertyValue = (String)this.myEntityInitialProperties.get(propertyName))) continue;
                    template.setPropertyValue(propertyName, propertyValue);
                }
            }
        }
        return template;
    }

    protected Reference createReferenceTemplate(Model model, String bounds) {
        Reference template = model.createReferenceTemplate();
        template.setPropertyValue("bounds", bounds);
        if (!this.isAutoSize()) {
            template.setPropertyValue("bounds_setted_by_user", Boolean.TRUE.toString());
            this.setAutoSize(false);
        }
        return template;
    }

    protected void setAutoSize(boolean state) {
        this.myIsAutoSize = state;
    }

    protected boolean isAutoSize() {
        return this.myIsAutoSize;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class ElementFactory
    implements CreateRequest.Factory {
        private Object myCreatedObject;

        protected ElementFactory() {
        }

        public Object getNewObject() {
            if (Boolean.TRUE.equals(ElementCreationTool.this.myWasExecuted)) {
                return null;
            }
            EditPartViewer viewerToRestore = ElementCreationTool.super.getCurrentViewer();
            BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(this){
                private final /* synthetic */ ElementFactory this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    ModelAccess.runCommand((Runnable)new UpdateCommand(this){
                        private final /* synthetic */ 1 this$2;
                        {
                            this.this$2 = this$2;
                        }

                        public void run() {
                            ElementFactory.access$302(1.access$200(this.this$2), ElementFactory.access$400(1.access$200(this.this$2)).createObject());
                        }
                    });
                }

                static /* synthetic */ ElementFactory access$200(1 x0) {
                    return x0.this$1;
                }
            });
            if (ElementCreationTool.super.getCurrentViewer() != viewerToRestore) {
                System.err.println("ATTENTION : viewer was changed inside creation command");
                System.err.println("original viewer will be restored to WORKAROUND NPE in super.selectAddedObject()");
                ElementCreationTool.this.setViewer(viewerToRestore);
            }
            viewerToRestore = null;
            ElementCreationTool.this.myWasExecuted = Boolean.TRUE;
            return this.myCreatedObject;
        }

        public Object getObjectType() {
            return ElementCreationTool.this.myMetaClass;
        }

        static /* synthetic */ Object access$302(ElementFactory x0, Object x1) {
            x0.myCreatedObject = x1;
            return x0.myCreatedObject;
        }

        static /* synthetic */ ElementCreationTool access$400(ElementFactory x0) {
            return x0.ElementCreationTool.this;
        }
    }
}

