/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.internal.commands;

import com.tssap.selena.gde.ModelNodeEditPart;
import com.tssap.selena.gde.internal.DiagramImpl;
import com.tssap.selena.gde.internal.commands.AbstractReferenceCommand;
import com.tssap.selena.gde.internal.commands.AbstractSelectLaterCommand;
import com.tssap.selena.gde.internal.editparts.DiagramEditPart;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.ui.actions.common.ReferencePropertyRestorer;
import com.tssap.selena.model.ui.actions.common.TreeReferenceTemplate;
import com.tssap.selena.model.update.hierarchy.Revisit;
import com.tssap.selena.model.util.Assert;
import com.tssap.selena.model.util.UpdateCommand;
import com.tssap.selena.ui.IPropertyMarshaler;
import com.tssap.selena.ui.internal.ChromePlugin;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class DropCommand
extends AbstractReferenceCommand {
    private Boolean myResult;
    private Rectangle myConstraint;
    private ModelNodeEditPart myTarget;
    private EditPart mySubject;
    private Entity myDroppedElement;
    private Element myTargetElement;
    private String myDroppedElementMetaclass;
    static /* synthetic */ Class class$org$eclipse$draw2d$geometry$Rectangle;

    public DropCommand(ModelNodeEditPart targetEP, EditPart subjectEP, Rectangle constraint) {
        super((Reference)subjectEP.getModel());
        this.myConstraint = constraint;
        this.myTarget = targetEP;
        this.mySubject = subjectEP;
    }

    private Entity getDroppedElement() {
        if (this.myDroppedElement == null) {
            this.myDroppedElement = this.resolve2Element(this.mySubject);
        }
        return this.myDroppedElement;
    }

    private Element getTargetElement() {
        if (this.myTargetElement == null) {
            this.myTargetElement = this.resolve2Element((EditPart)this.myTarget);
        }
        return this.myTargetElement;
    }

    private String getDroppedElementMetaclass() {
        if (this.myDroppedElementMetaclass == null && this.getDroppedElement() != null) {
            this.myDroppedElementMetaclass = this.getDroppedElement().getPropertyValue("$metaclass");
        }
        return this.myDroppedElementMetaclass;
    }

    public boolean canExecute() {
        if (this.myResult != null) {
            return this.myResult;
        }
        Element targetElement = this.getTargetElement();
        Reference droppedReference = this.getReference();
        Entity droppedEntity = this.getDroppedElement();
        if (targetElement instanceof ReferenceCollection && targetElement.hasProperty("automaticallySynchronized")) {
            targetElement = ((ReferenceCollection)targetElement).getParent();
        }
        if (this.getTargetCollection() == null) {
            this.myResult = Boolean.FALSE;
            return false;
        }
        boolean result = this.isDroppingShortcut() ? this.canExecuteForShortcut(droppedReference, droppedEntity, targetElement) : this.regularCanExecute(droppedEntity, targetElement);
        this.myResult = new Boolean(result);
        return result;
    }

    private boolean isDroppingShortcut() {
        Reference droppedReference = this.getReference();
        return droppedReference != null && droppedReference.hasProperty("$imported");
    }

    private boolean canExecuteForShortcut(Reference droppedReference, Entity droppedEntity, Element targetElement) {
        return droppedEntity != null && droppedEntity.canCopy() && droppedEntity.canCut();
    }

    private boolean regularCanExecute(Entity droppedEntity, Element targetElement) {
        return droppedEntity != null && droppedEntity.canCopy() && droppedEntity.canCut() && targetElement instanceof Entity && this.getDroppedElementMetaclass() != null && ((Entity)targetElement).canCreateChildEntity(this.getDroppedElementMetaclass(), null);
    }

    public void execute() {
        if (this.isDroppingShortcut()) {
            this.selectChoiceAndExecute();
        } else {
            this.regularExecute();
        }
    }

    private ReferenceCollection getSubstitutedTargetCollection() {
        Object targetContent = this.myTarget.getModel();
        if (targetContent instanceof Reference) {
            Entity targetEntity = ((Reference)targetContent).getEntity();
            return targetEntity instanceof ReferenceCollection ? (ReferenceCollection)targetEntity : null;
        }
        return null;
    }

    private ReferenceCollection getTargetCollection() {
        Object targetContent = this.myTarget.getModel();
        if (targetContent instanceof Reference) {
            Entity resolvedTarget = ((Reference)targetContent).getEntity();
            if (resolvedTarget instanceof ReferenceCollection) {
                return (ReferenceCollection)resolvedTarget;
            }
            return (ReferenceCollection)((Reference)targetContent).getParent();
        }
        return (ReferenceCollection)this.myTarget.getDiagram().getContent();
    }

    private void regularExecute() {
        final Reference droppedReference = this.getReference();
        final Entity droppedEntity = this.resolve2Element(this.mySubject);
        final TreeReferenceTemplate subjectTreeTemplate = ReferencePropertyRestorer.getInstance().createTreeReferenceTemplate(this.getReference());
        if (subjectTreeTemplate != null) {
            subjectTreeTemplate.getReferenceTemplate().setPropertyValue("$shortcutReference", null);
            subjectTreeTemplate.getReferenceTemplate().setPropertyValue("$imported", null);
        }
        Entity targetRElement = this.resolve2Element((EditPart)this.myTarget);
        final ReferenceCollection diagramCollection = this.getTargetCollection();
        if (targetRElement instanceof ReferenceCollection && targetRElement.hasProperty("automaticallySynchronized")) {
            targetRElement = ((ReferenceCollection)targetRElement).getParent();
        }
        final Entity targetElement = targetRElement;
        if (droppedEntity != null && droppedEntity.canCopy() && droppedEntity.canCut() && targetElement instanceof Entity) {
            ModelAccess.runCommand((Runnable)new UpdateCommand(){

                public void run() {
                    Entity copy = droppedEntity.copy();
                    if (copy != null && targetElement.canPaste((Element)copy)) {
                        Entity cutCopy;
                        if (!DropCommand.this.isDroppingShortcut()) {
                            copy.delete();
                            cutCopy = droppedEntity.cut();
                        } else {
                            cutCopy = copy;
                        }
                        if (cutCopy == null || !targetElement.canPaste((Element)cutCopy)) {
                            System.err.println("ATTENTION! -- Unrecoverable cut here. User Data is probably lost");
                            return;
                        }
                        Element droppedCopy = targetElement.paste((Element)cutCopy);
                        cutCopy.delete();
                        if (droppedCopy instanceof Entity) {
                            String diagramUinStr;
                            Dimension parentRect = DropCommand.this.myTarget.getFigure().getSize();
                            if (!(((DropCommand)DropCommand.this).myConstraint.width < parentRect.width && ((DropCommand)DropCommand.this).myConstraint.height < parentRect.height || DropCommand.this.myTarget instanceof DiagramEditPart)) {
                                ((DropCommand)DropCommand.this).myConstraint.x = 0;
                                ((DropCommand)DropCommand.this).myConstraint.y = 0;
                            }
                            if ("Package".equals(droppedCopy.getPropertyValue("$metaclass")) && (diagramUinStr = droppedCopy.getPropertyValue("DiagramUIN")) != null) {
                                UniqueName diagramUin = ModelAccess.createUniqueName((String)diagramUinStr);
                                droppedCopy = droppedCopy.getModel().findReferenceCollection(diagramUin);
                            }
                            if (droppedCopy != null) {
                                Reference newReference = ReferencePropertyRestorer.getInstance().restoreReferenceProperties(diagramCollection, (Entity)droppedCopy, subjectTreeTemplate, DropCommand.this.getConstraintAsString());
                                if (DropCommand.this.isDroppingShortcut()) {
                                    droppedReference.delete();
                                }
                                AbstractSelectLaterCommand.selectNewReferenceLater((DiagramImpl)DropCommand.this.myTarget.getDiagram(), newReference);
                            }
                        }
                    }
                    DropCommand.this.dispose();
                }
            });
        }
    }

    private void selectChoiceAndExecute() {
        Assert.isLegal((boolean)this.isDroppingShortcut());
        Control canvas = this.myTarget.getDiagramCanvas();
        Menu popup = new Menu(canvas);
        this.addActionToMenu(popup, "Copy Here", new Runnable(){

            public void run() {
                DropCommand.this.regularExecute();
            }
        });
        final ReferenceCollection substitutedTargetCollection = this.getSubstitutedTargetCollection();
        final TreeReferenceTemplate subjectTreeTemplate = ReferencePropertyRestorer.getInstance().createTreeReferenceTemplate(this.getReference());
        if (substitutedTargetCollection != null && substitutedTargetCollection.canAddReference(this.getReference().getEntity(), subjectTreeTemplate.getReferenceTemplate())) {
            this.addActionToMenu(popup, "Create Shortcut Here", new Runnable(){

                public void run() {
                    Reference droppedShortcut = DropCommand.this.getReference();
                    Reference pastedResult = substitutedTargetCollection.addReference(DropCommand.this.getReference().getEntity(), subjectTreeTemplate.getReferenceTemplate());
                    if (pastedResult != null) {
                        ReferencePropertyRestorer.getInstance().restoreReferenceProperties(pastedResult, subjectTreeTemplate, DropCommand.this.getConstraintAsString());
                        AbstractSelectLaterCommand.selectNewReferenceLater((DiagramImpl)DropCommand.this.myTarget.getDiagram(), pastedResult);
                    }
                    droppedShortcut.delete();
                    DropCommand.this.dispose();
                }
            });
        }
        new Separator().fill(popup, -1);
        this.addActionToMenu(popup, "Cancel", new Runnable(){

            public void run() {
                DropCommand.this.dispose();
            }
        });
        popup.setVisible(true);
    }

    private void addActionToMenu(Menu parent, String actionText, final Runnable command) {
        Action action = new Action(){

            public void run() {
                command.run();
            }
        };
        action.setText(actionText);
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    public void undo() {
        Revisit.revisit();
        throw new RuntimeException("Undo/Redo is not implemented yet");
    }

    public void redo() {
        Revisit.revisit();
        throw new RuntimeException("Undo/Redo is not implemented yet");
    }

    private Entity resolve2Element(EditPart editPart) {
        Object result = editPart.getModel();
        if (result instanceof Reference) {
            result = ((Reference)result).getEntity();
        }
        if (result instanceof ReferenceCollection) {
            return ((ReferenceCollection)result).getParent();
        }
        return result instanceof Entity ? (Entity)result : null;
    }

    public void setConstraint(Rectangle constraint) {
        this.myConstraint = constraint;
    }

    private String getConstraintAsString() {
        IPropertyMarshaler marshaller = ChromePlugin.getInstance().getPropertyMarshaler((Object)(class$org$eclipse$draw2d$geometry$Rectangle == null ? (class$org$eclipse$draw2d$geometry$Rectangle = DropCommand.class$("org.eclipse.draw2d.geometry.Rectangle")) : class$org$eclipse$draw2d$geometry$Rectangle).getName());
        return marshaller.marshal((Object)this.myConstraint);
    }

    public void dispose() {
        this.myDroppedElement = null;
        this.mySubject = null;
        this.myTarget = null;
        this.myTargetElement = null;
        super.dispose();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

