/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.internal.commands;

import com.tssap.selena.gde.internal.commands.LinkFactory;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceCollection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.CreateRequest;

public class CreateLinkRequest
extends CreateConnectionRequest {
    private Point myStartPoint = null;
    private Element myAlternateTarget;

    public CreateLinkRequest(CreateRequest.Factory factory) {
        this.setFactory(factory);
        this.setType("connection start");
    }

    public void setStartPoint(Point point) {
        this.myStartPoint = point;
    }

    public Point getStartPoint() {
        return this.myStartPoint;
    }

    public String getMetaclass() {
        return this.getLinkFactory().getMetaclass();
    }

    public String getSourceRole() {
        return this.getLinkFactory().getSourceRole();
    }

    public String getTargetRole() {
        return this.getLinkFactory().getTargetRole();
    }

    public Entity getTemplate() {
        HashMap initialProperties;
        Entity template = this.getModel().createEntityTemplate();
        if (this.getType() == "connection start") {
            template.setParticipant(this.getSourceRole(), null, this.getElement(this.getSourceEditPart()));
        }
        if (this.getType() == "connection end") {
            template.setParticipant(this.getTargetRole(), null, this.getTargetElement());
        }
        if ((initialProperties = this.getInitialProperties()) != null) {
            Iterator names = initialProperties.keySet().iterator();
            while (names.hasNext()) {
                String propertyValue;
                String propertyName = (String)names.next();
                if (!template.canSetPropertyValue(propertyName, propertyValue = (String)initialProperties.get(propertyName))) continue;
                template.setPropertyValue(propertyName, propertyValue);
            }
        }
        return template;
    }

    public HashMap getInitialProperties() {
        return this.getLinkFactory().getInitialProperties();
    }

    public boolean shouldProceedWithParent(String parentMetaclass) {
        if (this.getLinkFactory().getRestrictedParents() == null || this.getLinkFactory().getRestrictedParents().isEmpty()) {
            return true;
        }
        return this.getLinkFactory().getRestrictedParents().contains(parentMetaclass);
    }

    protected Model getModel() {
        return this.getElement(this.getSourceEditPart()).getModel();
    }

    protected Element getElement(EditPart editPart) {
        if (editPart == null) {
            return null;
        }
        if (editPart.getModel() instanceof Reference) {
            return ((Reference)editPart.getModel()).getEntity();
        }
        if (editPart.getModel() instanceof ReferenceCollection) {
            return (ReferenceCollection)editPart.getModel();
        }
        return null;
    }

    private LinkFactory getLinkFactory() {
        return (LinkFactory)this.getFactory();
    }

    protected Element getTargetElement() {
        if (this.getAlternateTarget() != null) {
            return this.getAlternateTarget();
        }
        return this.getElement(this.getTargetEditPart());
    }

    protected Element getSourceElement() {
        return this.getElement(this.getSourceEditPart());
    }

    Element getAlternateTarget() {
        return this.myAlternateTarget;
    }

    void setAlternateTarget(Element alternateTarget) {
        this.myAlternateTarget = alternateTarget;
    }
}

