/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.internal.commands;

import com.tssap.selena.gde.ILinkOnDiagramSupport;
import com.tssap.selena.gde.internal.DiagramImpl;
import com.tssap.selena.gde.internal.GdePlugin;
import com.tssap.selena.gde.internal.commands.CompleteLinkCreateCommand;
import com.tssap.selena.gde.internal.commands.CreateLinkRequest;
import com.tssap.selena.gde.internal.editparts.DiagramEditPart;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.ui.IPropertyMarshaler;
import com.tssap.selena.ui.internal.ChromePlugin;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public class CompleteLinkCreateCommandForDiagram
extends CompleteLinkCreateCommand {
    private ILinkOnDiagramSupport myCachedSupport;
    private boolean myHaveCachedSupport;
    private DiagramEditPart myDiagramEP;
    static /* synthetic */ Class class$org$eclipse$draw2d$geometry$Rectangle;

    public CompleteLinkCreateCommandForDiagram(CreateLinkRequest request) {
        super(request);
    }

    protected boolean canExecute(Entity parent) {
        return parent != null && this.getLinkOnDiagramSupport() != null;
    }

    public void execute() {
        this.myDiagramEP = (DiagramEditPart)this.getCreateLinkRequest().getTargetEditPart();
        Entity alternateTarget = this.getAlternateTarget();
        if (alternateTarget == null) {
            return;
        }
        this.getCreateLinkRequest().setAlternateTarget((Element)alternateTarget);
        super.execute();
    }

    protected void afterLinkCreated(Entity createdLink) {
        super.afterLinkCreated(createdLink);
        ReferenceCollection diagram = (ReferenceCollection)this.getDiagram().getContent();
        Model model = diagram.getModel();
        Entity alternateTarget = (Entity)this.getCreateLinkRequest().getAlternateTarget();
        Reference template = model.createReferenceTemplate();
        template.setPropertyValue("$shortcutReference", Boolean.TRUE.toString());
        template.setPropertyValue("$imported", Boolean.TRUE.toString());
        template.setPropertyValue("bounds", this.makeBoundsAsString());
        if (diagram.canAddReference(alternateTarget, template)) {
            diagram.addReference(alternateTarget, template);
        }
    }

    protected DiagramImpl getDiagram() {
        return (DiagramImpl)this.myDiagramEP.getDiagram();
    }

    protected String makeBoundsAsString() {
        Point location = new Point(this.getCreateLinkRequest().getLocation());
        IFigure contentPane = this.myDiagramEP.getContentPane();
        contentPane.translateToRelative((Translatable)location);
        Dimension size = new Dimension(-1, -1);
        Rectangle rect = new Rectangle(location, size);
        IPropertyMarshaler marshaller = ChromePlugin.getInstance().getPropertyMarshaler((Object)(class$org$eclipse$draw2d$geometry$Rectangle == null ? (class$org$eclipse$draw2d$geometry$Rectangle = CompleteLinkCreateCommandForDiagram.class$("org.eclipse.draw2d.geometry.Rectangle")) : class$org$eclipse$draw2d$geometry$Rectangle).getName());
        if (rect.x < 0) {
            rect.x = 0;
        }
        if (rect.y < 0) {
            rect.y = 0;
        }
        return marshaller.marshal((Object)rect);
    }

    private ILinkOnDiagramSupport getLinkOnDiagramSupport() {
        if (!this.myHaveCachedSupport) {
            this.myHaveCachedSupport = true;
            this.myCachedSupport = GdePlugin.getDefault().getLinkOnDiagramSupportRegistry().getLinkOnDiagramSupport(this.getCreateLinkRequest().getMetaclass());
        }
        return this.myCachedSupport;
    }

    private Entity getAlternateTarget() {
        return this.doGetAlternateTarget();
    }

    private Entity doGetAlternateTarget() {
        ILinkOnDiagramSupport support = this.getLinkOnDiagramSupport();
        if (support != null) {
            return support.chooseLinkTarget((Entity)this.getCreateLinkRequest().getSourceElement());
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

