/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.internal.commands;

import com.tssap.selena.gde.ModelElementEditPart;
import com.tssap.selena.gde.internal.DiagramElement;
import com.tssap.selena.gde.internal.DiagramImpl;
import com.tssap.selena.gde.internal.Messages;
import com.tssap.selena.gde.internal.commands.CreateLinkCommand;
import com.tssap.selena.gde.internal.commands.CreateLinkRequest;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.update.diagram.IDiagram;
import com.tssap.selena.model.update.diagram.IUpdatableElement;
import com.tssap.selena.model.util.UpdateCommand;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.AbstractCommand;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class CompleteLinkCreateCommand
extends AbstractCommand {
    private CreateLinkRequest myCreateLinkRequest;

    public CompleteLinkCreateCommand(CreateLinkRequest request) {
        this.myCreateLinkRequest = request;
    }

    public void execute() {
        final Command startCommand = this.myCreateLinkRequest.getStartCommand();
        final HashMap initialProperties = this.myCreateLinkRequest.getInitialProperties();
        if (startCommand instanceof CreateLinkCommand) {
            ModelAccess.runCommand((Runnable)new UpdateCommand(){

                public void run() {
                    Entity parent;
                    CreateLinkCommand createLinkCommand;
                    if (startCommand instanceof CreateLinkCommand && (createLinkCommand = (CreateLinkCommand)startCommand).canExecute() && (parent = CompleteLinkCreateCommand.this.getEntity(CompleteLinkCreateCommand.this.myCreateLinkRequest.getSourceEditPart())).canCreateChildEntity(CompleteLinkCreateCommand.this.myCreateLinkRequest.getMetaclass(), CompleteLinkCreateCommand.this.myCreateLinkRequest.getTemplate())) {
                        DiagramImpl gdeDiagram;
                        Entity childEntity = parent.createChildEntity(CompleteLinkCreateCommand.this.myCreateLinkRequest.getMetaclass(), CompleteLinkCreateCommand.this.myCreateLinkRequest.getTemplate());
                        if (initialProperties != null && childEntity != null) {
                            Iterator names = initialProperties.keySet().iterator();
                            while (names.hasNext()) {
                                String propertyName = (String)names.next();
                                String propertyValue = (String)initialProperties.get(propertyName);
                                if (!childEntity.hasProperty(propertyName)) {
                                    childEntity.setPropertyValue(propertyName, propertyValue);
                                    continue;
                                }
                                if (childEntity.hasPropertyValue(propertyName, propertyValue)) continue;
                                childEntity.addProperty(propertyName, propertyValue);
                            }
                        }
                        CompleteLinkCreateCommand.this.afterLinkCreated(childEntity);
                        if (childEntity != null && (gdeDiagram = CompleteLinkCreateCommand.this.getDiagram()) != null) {
                            CompleteLinkCreateCommand.selectOnDiagramLater(gdeDiagram, childEntity.getUniqueName());
                        }
                    }
                }
            });
        }
    }

    protected void afterLinkCreated(Entity createdLink) {
    }

    public boolean canExecute() {
        CreateLinkCommand createLinkCommand;
        Command startCommand = this.myCreateLinkRequest.getStartCommand();
        if (startCommand instanceof CreateLinkCommand && (createLinkCommand = (CreateLinkCommand)startCommand).canExecute()) {
            EditPart sourceEP = this.myCreateLinkRequest.getSourceEditPart();
            if (sourceEP == null) {
                return false;
            }
            Entity parent = this.getEntity(sourceEP);
            return this.canExecute(parent);
        }
        return false;
    }

    protected boolean canExecute(Entity parent) {
        String metaclass = this.getCreateLinkRequest().getMetaclass();
        Entity template = this.getCreateLinkRequest().getTemplate();
        return parent.canCreateChildEntity(metaclass, template);
    }

    protected Entity getEntity(EditPart editPart) {
        Element element = this.getElement(editPart);
        if (element instanceof Entity) {
            return (Entity)element;
        }
        return element.getParent();
    }

    private Element getElement(EditPart editPart) {
        if (editPart.getModel() instanceof Reference) {
            return ((Reference)editPart.getModel()).getEntity();
        }
        if (editPart.getModel() instanceof ReferenceCollection) {
            return (ReferenceCollection)editPart.getModel();
        }
        return null;
    }

    protected static void selectOnDiagramLater(final DiagramImpl diagram, final UniqueName entityUinToSelect) {
        if (diagram == null || entityUinToSelect == null) {
            return;
        }
        ModelAccess.runCommandLater((Runnable)new Runnable(){

            public void run() {
                IUpdatableElement newDiagramElement = diagram.findByEntityUin(entityUinToSelect);
                if (newDiagramElement instanceof DiagramElement) {
                    diagram.getViewPart().getViewer().setSelection((ISelection)new StructuredSelection((Object)((DiagramElement)newDiagramElement).getEditPart()));
                }
            }
        }, (String)Messages.getString("CompleteLinkCreateCommand.Select_new_element"));
    }

    protected DiagramImpl getDiagram() {
        EditPart targetEP = this.myCreateLinkRequest.getTargetEditPart();
        if (targetEP instanceof ModelElementEditPart) {
            IDiagram result = ((ModelElementEditPart)targetEP).getDiagram();
            return result instanceof DiagramImpl ? (DiagramImpl)result : null;
        }
        return null;
    }

    protected CreateLinkRequest getCreateLinkRequest() {
        return this.myCreateLinkRequest;
    }
}

