/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.internal.commands;

import com.tssap.selena.gde.internal.DiagramRootEditPart;
import com.tssap.selena.gde.internal.commands.ScrollableTool;
import org.eclipse.draw2d.ScrollBar;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;

public class AutoscrollSupport {
    private int myXShift = 0;
    private int myYShift = 0;
    private boolean myTransformEvents = false;
    private DiagramScroller myScroller = null;
    private ScrollableTool myTool;

    public AutoscrollSupport(ScrollableTool tool, boolean transformEvents) {
        this.myTool = tool;
        this.myTransformEvents = transformEvents;
    }

    public int getXShift() {
        return this.myXShift;
    }

    public int getYShift() {
        return this.myYShift;
    }

    public void setTransformEventsMode(boolean transformEvents) {
        this.myTransformEvents = transformEvents;
    }

    public void activate() {
    }

    public void deactivate() {
    }

    public void mouseDoubleClick(MouseEvent mouseEvent, EditPartViewer view) {
    }

    public void mouseDown(MouseEvent mouseEvent, EditPartViewer view) {
    }

    public void mouseDrag(MouseEvent mouseEvent, EditPartViewer view) {
        this.stopScrolling();
        RootEditPart rootEP = view.getRootEditPart();
        if (rootEP instanceof DiagramRootEditPart) {
            ScrollPane scrollPane;
            DiagramRootEditPart ep = (DiagramRootEditPart)rootEP;
            Rectangle bounds = ep.getFigure().getBounds();
            ScrollDirection direction = new ScrollDirection();
            if (mouseEvent.x - bounds.x - bounds.width > 0) {
                direction.right = true;
            }
            if (mouseEvent.y - bounds.y - bounds.height > 0) {
                direction.down = true;
            }
            if (bounds.x - mouseEvent.x > 0) {
                direction.left = true;
            }
            if (bounds.y - mouseEvent.y > 0) {
                direction.up = true;
            }
            if (direction.toBeScrolled() && (scrollPane = ep.getDiagramScrollPane()) != null) {
                this.myScroller = new DiagramScroller(direction, scrollPane, mouseEvent, view);
            }
        }
        if (this.myTransformEvents) {
            mouseEvent.x += this.myXShift;
            mouseEvent.y += this.myYShift;
        }
    }

    public void mouseHover(MouseEvent mouseEvent, EditPartViewer view) {
    }

    public void mouseMove(MouseEvent mouseEvent, EditPartViewer view) {
        if (this.myTransformEvents) {
            mouseEvent.x += this.myXShift;
            mouseEvent.y += this.myYShift;
        }
    }

    public void mouseUp(MouseEvent mouseEvent, EditPartViewer view) {
        this.myXShift = 0;
        this.myYShift = 0;
        this.stopScrolling();
    }

    private void stopScrolling() {
        if (this.myScroller != null) {
            this.myScroller.stopScrolling();
            this.myScroller = null;
        }
    }

    static /* synthetic */ ScrollableTool access$1000(AutoscrollSupport x0) {
        return x0.myTool;
    }

    private class DiagramScroller {
        private static final int SCROLL_FACTOR = 50;
        public static final int WAIT_DELAY = 10;
        private boolean myStopFlag = false;

        public DiagramScroller(final ScrollDirection direction, final ScrollPane scroller, MouseEvent mouseEvent, final EditPartViewer viewer) {
            Event event = new Event();
            event.x = mouseEvent.x;
            event.y = mouseEvent.y;
            event.button = mouseEvent.button;
            event.stateMask = mouseEvent.stateMask;
            event.widget = mouseEvent.widget;
            event.time = mouseEvent.time;
            event.display = mouseEvent.display;
            final MouseEvent newEvent = new MouseEvent(event);
            if (AutoscrollSupport.this.myTransformEvents) {
                newEvent.x += AutoscrollSupport.this.myXShift;
                newEvent.y += AutoscrollSupport.this.myYShift;
            }
            Thread scrollerThread = new Thread(){

                public void run() {
                    while (!myStopFlag) {
                        1 var1_1 = this;
                        synchronized (var1_1) {
                            if (!myStopFlag) {
                                boolean scrollPerformed = false;
                                if (direction.toBeScrolledVertically()) {
                                    scrollPerformed = this.scrollDiagram(true, direction.down, scroller.getVerticalScrollBar(), newEvent) | scrollPerformed;
                                }
                                if (direction.toBeScrolledHorizontally()) {
                                    scrollPerformed = this.scrollDiagram(false, direction.right, scroller.getHorizontalScrollBar(), newEvent) | scrollPerformed;
                                }
                                if (scrollPerformed) {
                                    Display.getDefault().syncExec(new Runnable(this){
                                        private final /* synthetic */ 1 this$2;
                                        {
                                            this.this$2 = this$2;
                                        }

                                        public void run() {
                                            AutoscrollSupport.access$1000(DiagramScroller.access$900(1.access$800(this.this$2))).mouseDragCausedByScroller(1.access$600(this.this$2), 1.access$700(this.this$2));
                                        }
                                    });
                                }
                                try {
                                    Thread.sleep(10L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                }

                static /* synthetic */ MouseEvent access$600(1 x0) {
                    return x0.newEvent;
                }

                static /* synthetic */ EditPartViewer access$700(1 x0) {
                    return x0.viewer;
                }

                static /* synthetic */ DiagramScroller access$800(1 x0) {
                    return x0.this;
                }
            };
            scrollerThread.start();
        }

        private boolean scrollDiagram(boolean vertically, boolean increase, ScrollBar scrollBar, MouseEvent event) {
            int scrollMaxValue = scrollBar.getMaximum() - scrollBar.getExtent();
            int scrollMinValue = scrollBar.getMinimum();
            boolean bl = increase ? scrollBar.getValue() == scrollMaxValue : scrollBar.getValue() == scrollMinValue;
            if (bl) {
                return false;
            }
            int delta = increase ? scrollMaxValue - scrollBar.getValue() : scrollBar.getValue() - scrollMinValue;
            delta = Math.min(delta, scrollBar.getExtent() / 50);
            int scrollDelta = delta = increase ? delta : -1 * delta;
            Display.getDefault().syncExec(new Runnable(this, scrollBar, scrollDelta){
                private final /* synthetic */ ScrollBar val$scrollBar;
                private final /* synthetic */ int val$scrollDelta;
                private final /* synthetic */ DiagramScroller this$1;
                {
                    this.this$1 = this$1;
                    this.val$scrollBar = val$scrollBar;
                    this.val$scrollDelta = val$scrollDelta;
                }

                public void run() {
                    this.val$scrollBar.setValue(this.val$scrollBar.getValue() + this.val$scrollDelta);
                }
            });
            if (vertically) {
                AutoscrollSupport.this.myYShift += delta;
                if (AutoscrollSupport.this.myTransformEvents) {
                    event.y += AutoscrollSupport.this.myYShift;
                }
            } else {
                AutoscrollSupport.this.myXShift += delta;
                if (AutoscrollSupport.this.myTransformEvents) {
                    event.x += AutoscrollSupport.this.myXShift;
                }
            }
            return true;
        }

        public synchronized void stopScrolling() {
            this.myStopFlag = true;
        }

        static /* synthetic */ AutoscrollSupport access$900(DiagramScroller x0) {
            return x0.AutoscrollSupport.this;
        }
    }

    private class ScrollDirection {
        public boolean up = false;
        public boolean right = false;
        public boolean down = false;
        public boolean left = false;

        private ScrollDirection() {
        }

        public boolean toBeScrolledVertically() {
            return this.up || this.down;
        }

        public boolean toBeScrolledHorizontally() {
            return this.left || this.right;
        }

        public boolean toBeScrolled() {
            return this.up || this.right || this.down || this.left;
        }
    }
}

