/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.internal.commands;

import com.tssap.selena.gde.ModelElementEditPart;
import com.tssap.selena.gde.internal.DiagramElement;
import com.tssap.selena.gde.internal.DiagramImpl;
import com.tssap.selena.gde.internal.Messages;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.update.diagram.IDiagram;
import com.tssap.selena.model.update.diagram.IUpdatableElement;
import com.tssap.selena.model.util.ShortCommand;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.AbstractCommand;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public abstract class AbstractSelectLaterCommand
extends AbstractCommand {
    protected static void selectNewReferenceLater(final DiagramImpl diagram, final Reference newReference) {
        if (newReference == null || diagram == null) {
            return;
        }
        ModelAccess.runCommandLater((Runnable)new ShortCommand(){

            public void run() {
                IUpdatableElement newDiagramElement = diagram.findDiagramElement(newReference);
                if (newDiagramElement instanceof DiagramElement) {
                    diagram.getViewPart().getViewer().setSelection((ISelection)new StructuredSelection((Object)((DiagramElement)newDiagramElement).getEditPart()));
                }
            }
        }, (String)Messages.getString("AbstractSelectLaterCommand.Restoring_selection"));
    }

    protected static void selectNewEntityLater(final DiagramImpl diagram, final Entity newEntity) {
        if (newEntity == null || diagram == null) {
            return;
        }
        ModelAccess.runCommandLater((Runnable)new ShortCommand(){

            public void run() {
                IUpdatableElement newDiagramElement = diagram.findByEntityUin(newEntity.getUniqueName());
                if (newDiagramElement instanceof DiagramElement) {
                    diagram.getViewPart().getViewer().setSelection((ISelection)new StructuredSelection((Object)((DiagramElement)newDiagramElement).getEditPart()));
                }
            }
        }, (String)Messages.getString("AbstractSelectLaterCommand.Restoring_selection"));
    }

    protected static DiagramImpl findDiagram(GraphicalEditPart graphEP) {
        if (graphEP instanceof ModelElementEditPart) {
            IDiagram diagram = ((ModelElementEditPart)graphEP).getDiagram();
            return diagram instanceof DiagramImpl ? (DiagramImpl)diagram : null;
        }
        return null;
    }
}

