/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.internal.actions;

import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.ModelDeltaNode;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.ui.IElementWrapper;
import com.tssap.selena.model.ui.actions.AbstractSelectionAwareAction;
import com.tssap.selena.model.util.TotalUpdateDeltaNode;
import com.tssap.selena.model.util.UndoTransparableCommand;
import com.tssap.selena.model.view.View;
import com.tssap.selena.model.view.ViewAccess;
import com.tssap.selena.model.view.ViewManager;
import java.util.Enumeration;
import java.util.Iterator;
import org.eclipse.jface.action.IAction;

public class UpdateDiagramAction
extends AbstractSelectionAwareAction {
    protected boolean customIsEnabled() {
        if (this.getSelection() == null || this.getSelection().size() != 1) {
            return false;
        }
        Iterator it = this.selectedWrappersIterator();
        if (!it.hasNext()) {
            return false;
        }
        IElementWrapper selected = (IElementWrapper)it.next();
        Element originalSelected = selected.getOriginalElement();
        return originalSelected instanceof ReferenceCollection || originalSelected.hasProperty("DiagramUIN") || originalSelected instanceof Reference;
    }

    protected boolean customIsChecked() {
        return false;
    }

    public void run(IAction action) {
        IElementWrapper selected = (IElementWrapper)this.selectedWrappersIterator().next();
        Element selectedElement = selected.getOriginalElement();
        if (!(selectedElement instanceof ReferenceCollection) && selectedElement.getPropertyValue("DiagramUIN") != null) {
            UniqueName uin = ModelAccess.createUniqueName((String)selectedElement.getPropertyValue("DiagramUIN"));
            selectedElement = selectedElement.getModel().findReferenceCollection(uin);
        } else if (selectedElement instanceof Reference) {
            selectedElement = selectedElement.getParent();
        }
        if (!(selectedElement instanceof ReferenceCollection)) {
            return;
        }
        final ReferenceCollection rcToUpdate = (ReferenceCollection)selectedElement;
        final TotalUpdateDeltaNode totalUpdate = new TotalUpdateDeltaNode((Entity)selectedElement);
        totalUpdate.setTotalUpdateRequired();
        ModelAccess.runCommand((Runnable)new UndoTransparableCommand(){

            public void run() {
                ViewManager viewManager = ViewAccess.getViewManager((UniqueName)rcToUpdate.getModel().getUniqueName());
                Enumeration views = viewManager.views();
                while (views.hasMoreElements()) {
                    View view = (View)views.nextElement();
                    if (!view.getReferenceCollection().equals(rcToUpdate)) continue;
                    view.update((ModelDeltaNode)totalUpdate);
                }
            }
        });
    }
}

