/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.internal.actions;

import com.tssap.selena.gde.internal.DiagramElement;
import com.tssap.selena.gde.internal.DiagramImpl;
import com.tssap.selena.gde.internal.DiagramLink;
import com.tssap.selena.gde.internal.GdePlugin;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.ui.IElementWrapper;
import com.tssap.selena.model.ui.actions.AbstractSelectionAwareAction;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.action.IAction;

public class ScrollToSourceAction
extends AbstractSelectionAwareAction {
    protected boolean customIsEnabled() {
        return true;
    }

    protected boolean customIsChecked() {
        return false;
    }

    public void run(IAction action) {
        IElementWrapper wrapper = (IElementWrapper)this.getSelection().getFirstElement();
        ReferenceCollection rc = null;
        if (wrapper.getOriginalElement() instanceof Reference) {
            Reference reference = (Reference)wrapper.getOriginalElement();
            rc = (ReferenceCollection)reference.getParent();
        }
        if (rc == null) {
            return;
        }
        DiagramImpl diagram = GdePlugin.openDiagram(rc, true);
        DiagramElement link = (DiagramElement)diagram.findDiagramElement((Reference)wrapper.getOriginalElement());
        if (link instanceof DiagramLink) {
            DiagramElement source = this.getLinkEdge((DiagramLink)link);
            diagram.getViewPart().getViewer().select((EditPart)source.getEditPart());
            ScrollToSourceAction.revealDiagramElement(diagram, source);
        }
    }

    protected DiagramElement getLinkEdge(DiagramLink link) {
        return (DiagramElement)link.getSourceNode();
    }

    private static void revealDiagramElement(DiagramImpl diagram, DiagramElement diagramElement) {
        if (diagram == null || diagramElement == null) {
            return;
        }
        diagram.getViewPart().getViewer().revealDiagramElement(diagramElement);
    }

    private static DiagramElement findSelection(DiagramImpl diagram, IElementWrapper wrapper) {
        if (diagram == null || wrapper == null) {
            return null;
        }
        Entity resolved = wrapper.getResolvedElement();
        if (resolved == null) {
            return null;
        }
        UniqueName uinToSelect = resolved.getUniqueName();
        String substitutedUin = resolved.getPropertyValue("DiagramUIN");
        if (substitutedUin != null) {
            uinToSelect = ModelAccess.createUniqueName((String)substitutedUin);
        }
        return uinToSelect != null ? (DiagramElement)diagram.findByEntityUin(uinToSelect) : null;
    }

    private ReferenceCollection getDefaultPackageDiagram(Element element) {
        String metaclass = element.getPropertyValue("$metaclass");
        if ("Class".equals(metaclass) || "Interface".equals(metaclass) || "Package".equals(metaclass) || "Attribute".equals(metaclass) || "Operation".equals(metaclass) || "Property".equals(metaclass)) {
            Entity parent = element.getParent();
            while (parent != null && !parent.hasProperty("DiagramUIN")) {
                parent = parent.getParent();
            }
            if (parent == null) {
                return null;
            }
            String diagramUinAsString = parent.getPropertyValue("DiagramUIN");
            if (diagramUinAsString == null) {
                System.err.println("hasProperty inconsistent with getPropertyValue for Property.DiagramUin, element: " + parent);
                return null;
            }
            UniqueName diagramUin = ModelAccess.createUniqueName((String)diagramUinAsString);
            if (diagramUin == null) {
                return null;
            }
            return element.getModel().findReferenceCollection(diagramUin);
        }
        return null;
    }
}

