/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.internal.actions;

import com.tssap.selena.gde.internal.DiagramRootEditPart;
import com.tssap.selena.gde.internal.actions.AbstractDiagramAwareAction;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.draw2d.ScrollBar;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.gef.RootEditPart;
import org.eclipse.jface.action.IAction;

public class ScrollDiagramAction
extends AbstractDiagramAwareAction
implements IExecutableExtension {
    private static final String TAG_DIRECTION = "direction";
    private static final String TAG_PAGE = "page";
    private static final String DIRECTION_UP = "up";
    private static final String DIRECTION_DOWN = "down";
    private static final String DIRECTION_LEFT = "left";
    private static final String DIRECTION_RIGHT = "right";
    private Direction myDirection;
    private boolean myPage = false;

    public void setInitializationData(IConfigurationElement element, String propertyName, Object data) {
        this.myDirection = new Direction();
        String direction = element.getAttribute(TAG_DIRECTION);
        if (DIRECTION_UP.equals(direction)) {
            this.myDirection.myUp = true;
        } else if (DIRECTION_DOWN.equals(direction)) {
            this.myDirection.myDown = true;
        } else if (DIRECTION_LEFT.equals(direction)) {
            this.myDirection.myLeft = true;
        } else if (DIRECTION_RIGHT.equals(direction)) {
            this.myDirection.myRight = true;
        }
        String page = element.getAttribute(TAG_PAGE);
        this.myPage = Boolean.valueOf(page);
    }

    protected boolean customIsEnabled() {
        if (this.getCurrentDiagramEditPart() == null) {
            return false;
        }
        return this.myDirection.toBeScrolled();
    }

    public void run(IAction action) {
        RootEditPart rootEp = this.getCurrentDiagramEditPart().getRoot();
        if (rootEp instanceof DiagramRootEditPart) {
            ScrollBar scrollBar;
            ScrollPane scrollPane = ((DiagramRootEditPart)rootEp).getDiagramScrollPane();
            int deltaSign = 1;
            if (this.myDirection.myUp || this.myDirection.myDown) {
                scrollBar = scrollPane.getVerticalScrollBar();
                deltaSign = this.myDirection.myDown ? 1 : -1;
            } else {
                scrollBar = scrollPane.getHorizontalScrollBar();
                deltaSign = this.myDirection.myRight ? 1 : -1;
            }
            int delta = this.myPage ? scrollBar.getPageIncrement() : scrollBar.getStepIncrement();
            delta = deltaSign * delta;
            scrollBar.setValue(scrollBar.getValue() + delta);
        }
    }

    private class Direction {
        private boolean myUp = false;
        private boolean myDown = false;
        private boolean myLeft = false;
        private boolean myRight = false;

        private Direction() {
        }

        public boolean toBeScrolled() {
            return this.myUp || this.myDown || this.myLeft || this.myRight;
        }
    }
}

