/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.internal.actions;

import com.tssap.selena.gde.EditPartElementWrapper;
import com.tssap.selena.gde.internal.GdePlugin;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.ui.actions.AbstractSelectionAwareAction;
import com.tssap.selena.model.ui.actions.SelectionUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;

public class OpenDiagramAction
extends AbstractSelectionAwareAction {
    public void run(IAction action) {
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                Element selectedModelElement = SelectionUtil.resolve2Element((Object)OpenDiagramAction.super.getSelection().getFirstElement());
                ReferenceCollection diagramToOpen = OpenDiagramAction.this.getDiagram(selectedModelElement);
                if (diagramToOpen != null) {
                    GdePlugin.getDefault();
                    GdePlugin.openDiagram(diagramToOpen, true);
                }
            }
        });
    }

    protected boolean customIsChecked() {
        return false;
    }

    protected boolean customIsEnabled() {
        EditPartElementWrapper wrapper;
        if (this.getSelection() == null || this.getSelection().size() != 1) {
            return false;
        }
        if (this.getSelection().getFirstElement() instanceof EditPartElementWrapper && (wrapper = (EditPartElementWrapper)((Object)this.getSelection().getFirstElement())).getOriginalElement() instanceof ReferenceCollection) {
            return false;
        }
        Element selectedModelElement = SelectionUtil.resolve2Element((Object)this.getSelection().getFirstElement());
        return this.getDiagram(selectedModelElement) != null;
    }

    protected ReferenceCollection getDiagram(Element element) {
        if (element == null) {
            return null;
        }
        if (element instanceof ReferenceCollection) {
            return (ReferenceCollection)element;
        }
        String diagramUinAsString = element.getPropertyValue("DiagramUIN");
        if (diagramUinAsString != null) {
            UniqueName diagramUin = ModelAccess.createUniqueName((String)diagramUinAsString);
            return element.getModel().findReferenceCollection(diagramUin);
        }
        return null;
    }
}

