/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.internal.actions;

import com.tssap.selena.gde.internal.DiagramImpl;
import com.tssap.selena.gde.internal.DiagramViewPart;
import com.tssap.selena.gde.internal.editparts.DiagramEditPart;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.ui.IElementWrapper;
import com.tssap.selena.model.ui.actions.AbstractSelectionAwareAction;
import com.tssap.selena.model.update.diagram.IDiagram;
import com.tssap.selena.ui.multipageview.MultiPageViewPart;
import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ActualSizeAction
extends AbstractSelectionAwareAction {
    private IDiagram myDiagramToLayout = null;

    public void init(IWorkbenchWindow window) {
        super.init(window);
        IPartService partService = window.getPartService();
        partService.addPartListener(new IPartListener(){
            ISelectionChangedListener selectionChangedListener;

            public void partActivated(IWorkbenchPart part) {
                this.update(part);
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
                ActualSizeAction.this.myDiagramToLayout = null;
            }

            public void partDeactivated(IWorkbenchPart part) {
                ActualSizeAction.this.myDiagramToLayout = null;
            }

            public void partOpened(IWorkbenchPart part) {
                this.update(part);
            }

            private void update(IWorkbenchPart part) {
                if (part instanceof MultiPageViewPart) {
                    MultiPageViewPart multiPage = (MultiPageViewPart)part;
                    ActualSizeAction.this.setActivePart(null, (IWorkbenchPart)multiPage.getActiveView());
                    multiPage.getSite().getSelectionProvider().addSelectionChangedListener(this.getSelectionChangedListener());
                }
            }

            private ISelectionChangedListener getSelectionChangedListener() {
                if (this.selectionChangedListener == null) {
                    this.selectionChangedListener = new ISelectionChangedListener(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void selectionChanged(SelectionChangedEvent event) {
                            MultiPageViewPart multiPageViewPart = 1.access$100(this.this$1).getMultiPageViewPart();
                            if (multiPageViewPart != null) {
                                1.access$100(this.this$1).setActivePart(null, (IWorkbenchPart)multiPageViewPart.getActiveView());
                            }
                        }
                    };
                }
                return this.selectionChangedListener;
            }

            static /* synthetic */ ActualSizeAction access$100(1 x0) {
                return x0.ActualSizeAction.this;
            }
        });
    }

    protected boolean customIsEnabled() {
        return this.myDiagramToLayout != null;
    }

    protected boolean customIsChecked() {
        return false;
    }

    public void run(IAction action) {
        ModelAccess.runCommand((Runnable)new Runnable(){

            public void run() {
                DiagramImpl diagram = (DiagramImpl)ActualSizeAction.this.myDiagramToLayout;
                Iterator selection = ActualSizeAction.super.getSelection().iterator();
                while (selection.hasNext()) {
                    IElementWrapper wrapper = (IElementWrapper)selection.next();
                    Element ref = wrapper.getOriginalElement();
                    if (!(ref instanceof Reference)) continue;
                    ref.setPropertyValue("bounds_setted_by_user", null);
                }
            }
        });
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        if (targetPart instanceof DiagramViewPart) {
            DiagramViewPart diagramViewPart = (DiagramViewPart)targetPart;
            this.myDiagramToLayout = ((DiagramEditPart)diagramViewPart.getViewer().getContents()).getDiagram();
        }
    }

    protected IDiagram getDiagramToLayout() {
        return this.myDiagramToLayout;
    }

    protected MultiPageViewPart getMultiPageViewPart() {
        try {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = window.getActivePage();
            return (MultiPageViewPart)page.findView("com.tssap.selena.gde.diagramMultiPageView");
        }
        catch (Exception e) {
            return null;
        }
    }
}

