/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.internal.actions;

import com.tssap.selena.gde.internal.DiagramElement;
import com.tssap.selena.gde.internal.DiagramImpl;
import com.tssap.selena.gde.internal.GdePlugin;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.ui.actions.AbstractSelectionAwareAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public abstract class AbstractSelectOnDiagramAction
extends AbstractSelectionAwareAction {
    protected abstract boolean customIsEnabled();

    protected abstract ReferenceCollection findDiagramCollectionToOpen();

    protected abstract Entity getEntityToSelect();

    protected final boolean customIsChecked() {
        return false;
    }

    public final void run(IAction action) {
        ReferenceCollection diagramToOpen = this.findDiagramCollectionToOpen();
        if (diagramToOpen == null) {
            return;
        }
        DiagramImpl diagram = GdePlugin.openDiagram(diagramToOpen, true);
        if (diagram == null) {
            return;
        }
        Entity entityToSelect = this.getEntityToSelect();
        if (entityToSelect == null) {
            return;
        }
        DiagramElement selection = this.findSelection(diagram, entityToSelect);
        if (selection != null) {
            diagram.getViewPart().getViewer().setSelection((ISelection)new StructuredSelection((Object)selection.getEditPart()));
        }
        AbstractSelectOnDiagramAction.revealDiagramElement(diagram, selection);
    }

    protected static ReferenceCollection getDefaultPackageDiagram(Element element) {
        String metaclass = element.getPropertyValue("$metaclass");
        if ("Class".equals(metaclass) || "Interface".equals(metaclass) || "Package".equals(metaclass) || "Attribute".equals(metaclass) || "Operation".equals(metaclass) || "Property".equals(metaclass)) {
            Entity parent = element.getParent();
            while (parent != null && !parent.hasProperty("DiagramUIN")) {
                parent = parent.getParent();
            }
            if (parent == null) {
                return null;
            }
            String diagramUinAsString = parent.getPropertyValue("DiagramUIN");
            if (diagramUinAsString == null) {
                System.err.println("hasProperty inconsistent with getPropertyValue for Property.DiagramUin, element: " + parent);
                return null;
            }
            UniqueName diagramUin = ModelAccess.createUniqueName((String)diagramUinAsString);
            if (diagramUin == null) {
                return null;
            }
            return element.getModel().findReferenceCollection(diagramUin);
        }
        return null;
    }

    protected static void revealDiagramElement(DiagramImpl diagram, DiagramElement diagramElement) {
        if (diagram == null || diagramElement == null) {
            return;
        }
        diagram.getViewPart().getViewer().revealDiagramElement(diagramElement);
    }

    protected DiagramElement findSelection(DiagramImpl diagram, Entity toSelect) {
        UniqueName uinToSelect = toSelect.getUniqueName();
        String substitutedUin = toSelect.getPropertyValue("DiagramUIN");
        if (substitutedUin != null) {
            uinToSelect = ModelAccess.createUniqueName((String)substitutedUin);
        }
        return uinToSelect != null ? (DiagramElement)diagram.findByEntityUin(uinToSelect) : null;
    }
}

