/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.internal.actions;

import com.tssap.selena.gde.internal.DiagramViewPart;
import com.tssap.selena.gde.internal.DiagramViewer;
import com.tssap.selena.gde.internal.editparts.DiagramEditPart;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.ui.actions.AbstractSelectionAwareAction;
import com.tssap.selena.model.ui.actions.UnaryElementCondition;
import com.tssap.selena.ui.multipageview.MultiPageViewPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractDiagramAwareAction
extends AbstractSelectionAwareAction {
    private DiagramViewPart myDiagramViewPart = null;

    public void init(IWorkbenchWindow window) {
        super.init(window);
        IPartService partService = window.getPartService();
        partService.addPartListener(new IPartListener(){
            ISelectionChangedListener selectionChangedListener;

            public void partActivated(IWorkbenchPart part) {
                this.update(part);
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
                AbstractDiagramAwareAction.this.myDiagramViewPart = null;
            }

            public void partDeactivated(IWorkbenchPart part) {
                AbstractDiagramAwareAction.this.myDiagramViewPart = null;
            }

            public void partOpened(IWorkbenchPart part) {
                this.update(part);
            }

            private void update(IWorkbenchPart part) {
                if (part instanceof MultiPageViewPart) {
                    MultiPageViewPart multiPage = (MultiPageViewPart)part;
                    AbstractDiagramAwareAction.this.setActivePart(null, (IWorkbenchPart)multiPage.getActiveView());
                    multiPage.getSite().getSelectionProvider().addSelectionChangedListener(this.getSelectionChangedListener());
                }
            }

            private ISelectionChangedListener getSelectionChangedListener() {
                if (this.selectionChangedListener == null) {
                    this.selectionChangedListener = new ISelectionChangedListener(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void selectionChanged(SelectionChangedEvent event) {
                            MultiPageViewPart multiPageViewPart = 1.access$100(this.this$1).getMultiPageViewPart();
                            if (multiPageViewPart != null) {
                                1.access$100(this.this$1).setActivePart(null, (IWorkbenchPart)multiPageViewPart.getActiveView());
                            }
                        }
                    };
                }
                return this.selectionChangedListener;
            }

            static /* synthetic */ AbstractDiagramAwareAction access$100(1 x0) {
                return x0.AbstractDiagramAwareAction.this;
            }
        });
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.myDiagramViewPart = null;
        if (targetPart instanceof MultiPageViewPart) {
            targetPart = ((MultiPageViewPart)((Object)targetPart)).getActiveView();
        }
        if (targetPart instanceof DiagramViewPart) {
            this.myDiagramViewPart = (DiagramViewPart)targetPart;
        }
    }

    protected boolean customIsEnabled() {
        if (this.myDiagramViewPart == null) {
            return false;
        }
        return this.checkConditionForAllSelected(new UnaryElementCondition(){

            public boolean check(Element element) {
                return element instanceof ReferenceCollection;
            }
        });
    }

    protected boolean customIsChecked() {
        return false;
    }

    protected DiagramViewer getCurrentDiagramViewer() {
        if (this.myDiagramViewPart == null) {
            return null;
        }
        return this.myDiagramViewPart.getViewer();
    }

    protected DiagramEditPart getCurrentDiagramEditPart() {
        if (this.myDiagramViewPart == null) {
            return null;
        }
        return (DiagramEditPart)this.myDiagramViewPart.getViewer().getContents();
    }

    protected MultiPageViewPart getMultiPageViewPart() {
        try {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = window.getActivePage();
            return (MultiPageViewPart)page.findView("com.tssap.selena.gde.diagramMultiPageView");
        }
        catch (Exception e) {
            return null;
        }
    }
}

