/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.internal;

import java.util.StringTokenizer;
import org.eclipse.draw2d.AbstractConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public class RelativeXYAnchor
extends AbstractConnectionAnchor {
    private LocationRecord locationRecord;

    public static LocationRecord computeLocationRecord(Rectangle r, Point p) {
        r = new Rectangle(r);
        p = new Point(p);
        Point tl = r.getTopLeft();
        Point tr = r.getTopRight();
        Point br = r.getBottomRight();
        Point bl = r.getBottomLeft();
        double d1 = RelativeXYAnchor.computeDistance(p, tl, tr);
        double d2 = RelativeXYAnchor.computeDistance(p, tr, br);
        double d3 = RelativeXYAnchor.computeDistance(p, br, bl);
        double d4 = RelativeXYAnchor.computeDistance(p, bl, tl);
        double min = Math.min(d1, Math.min(d2, Math.min(d3, d4)));
        LocationRecord lr = null;
        if (d1 == min) {
            RelativeXYAnchor.normalizePointY(p, tl, tr, d1);
            lr = new LocationRecord(8, (double)(p.x - tl.x) / (double)r.width);
        } else if (d2 == min) {
            RelativeXYAnchor.normalizePointX(p, tr, br, d2);
            lr = new LocationRecord(4, (double)(p.y - tr.y) / (double)r.height);
        } else if (d3 == min) {
            RelativeXYAnchor.normalizePointY(p, br, bl, d3);
            lr = new LocationRecord(32, (double)(br.x - p.x) / (double)r.width);
        } else {
            RelativeXYAnchor.normalizePointX(p, bl, tl, d4);
            lr = new LocationRecord(1, (double)(bl.y - p.y) / (double)r.height);
        }
        return lr;
    }

    public static LocationRecord read(String value) {
        try {
            StringTokenizer tokenizer = new StringTokenizer(value, ",");
            String sSide = tokenizer.nextToken();
            String sWeight = tokenizer.nextToken();
            int side = Integer.parseInt(sSide);
            double weight = Double.parseDouble(sWeight);
            return new LocationRecord(side, weight);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String store(RelativeXYAnchor anchor) {
        if (anchor == null) {
            return null;
        }
        return RelativeXYAnchor.store(anchor.locationRecord);
    }

    public static String store(LocationRecord lr) {
        if (lr == null) {
            return null;
        }
        String value = lr.side + "," + lr.weight;
        return value;
    }

    public RelativeXYAnchor(IFigure owner) {
        this(owner, null);
    }

    public RelativeXYAnchor(IFigure owner, Point location) {
        super(owner);
        if (location != null) {
            // empty if block
        }
    }

    public LocationRecord computeLocationRecord(Point p) {
        Rectangle r = this.getOwner().getBounds();
        return RelativeXYAnchor.computeLocationRecord(r, p);
    }

    public Point getLocation(Point reference) {
        return this.getReferencePoint();
    }

    public Point getReferencePoint() {
        if (this.locationRecord == null) {
            this.locationRecord = this.computeLocationRecord(this.getInitialLocation());
        }
        Point p = this.computeLocation();
        this.getOwner().translateToAbsolute((Translatable)p);
        return p;
    }

    public void setLocation(Point p) {
        if (p != null) {
            this.locationRecord = this.computeLocationRecord(p);
        }
    }

    public void setLocationRecord(LocationRecord lr) {
        if (lr == null) {
            return;
        }
        this.setLocationRecord(lr.side, lr.weight);
    }

    public void setLocationRecord(int side, double weight) {
        boolean weightCorrect;
        boolean sideCorrect = side == 8 || side == 4 || side == 32 || side == 1;
        boolean bl = weightCorrect = weight >= 0.0 && weight <= 1.0;
        if (!sideCorrect || !weightCorrect) {
            return;
        }
        this.locationRecord = new LocationRecord(side, weight);
    }

    private static Point computeLocation(Rectangle r, LocationRecord lr) {
        Point location = null;
        switch (lr.side) {
            case 8: {
                location = new Point(r.getTopLeft());
                location.x += (int)(lr.weight * (double)r.width);
                break;
            }
            case 32: {
                location = new Point(r.getBottomRight());
                location.x -= (int)(lr.weight * (double)r.width);
                break;
            }
            case 1: {
                location = new Point(r.getBottomLeft());
                location.y -= (int)(lr.weight * (double)r.height);
                break;
            }
            case 4: {
                location = new Point(r.getTopRight());
                location.y += (int)(lr.weight * (double)r.height);
            }
        }
        return location;
    }

    private static double computeDistance(Point p, Point lineStart, Point lineEnd) {
        double a = lineStart.getDistance(p);
        double b = lineEnd.getDistance(p);
        double l = lineStart.getDistance(lineEnd);
        double y = (b * b - a * a - l * l) / (2.0 * l);
        double x = Math.sqrt(a * a - y * y);
        return x;
    }

    private static void normalizePointX(Point p, Point lineStart, Point lineEnd, double distance) {
        if (distance != 0.0) {
            p.x = lineStart.x;
        }
    }

    private static void normalizePointY(Point p, Point lineStart, Point lineEnd, double distance) {
        if (distance != 0.0) {
            p.y = lineStart.y;
        }
    }

    private Point computeLocation() {
        return RelativeXYAnchor.computeLocation(this.getOwner().getBounds(), this.locationRecord);
    }

    private Point getInitialLocation() {
        return this.getOwner().getBounds().getBottom();
    }

    public static class LocationRecord {
        int side;
        double weight;

        public LocationRecord(int side, double weight) {
            this.side = side;
            this.weight = weight;
        }

        public String toString() {
            String s = "";
            s = this.side == 8 ? s + "top" : (this.side == 4 ? s + "right" : (this.side == 32 ? s + "bottom" : s + "left"));
            s = s + ", " + this.weight;
            return s;
        }
    }
}

