/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.internal;

import com.tssap.selena.gde.ModelElementEditPart;
import com.tssap.selena.gde.internal.DiagramElement;
import com.tssap.selena.gde.internal.DiagramImpl;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceUniqueName;
import com.tssap.selena.model.update.diagram.IUpdatableElement;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class PreservingSelectionOperation
implements Runnable {
    private List mySelectedUins = new LinkedList();
    private DiagramImpl myDiagram;
    private Runnable myCommand;
    private boolean myIsDiagramValidOnStart;

    public PreservingSelectionOperation(DiagramImpl diagram, Runnable command) {
        this.myDiagram = diagram;
        this.myCommand = command;
        this.myIsDiagramValidOnStart = this.myDiagram != null && this.myDiagram.getViewPart() != null && this.myDiagram.getViewPart().getViewer() != null;
    }

    public void run() {
        this.collectSelection();
        try {
            try {
                this.myCommand.run();
            }
            catch (NullPointerException ex) {
                System.out.println("Exception!!!!!!!!!!!!!!!!!!!!!!");
                ex.printStackTrace();
                Object var3_2 = null;
                this.restoreSelection();
            }
            Object var3_1 = null;
            this.restoreSelection();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.restoreSelection();
            throw throwable;
        }
    }

    private void collectSelection() {
        if (!this.myIsDiagramValidOnStart) {
            return;
        }
        List selectedParts = this.myDiagram.getViewPart().getViewer().getSelectedEditParts();
        if (selectedParts == null) {
            return;
        }
        Iterator parts = selectedParts.iterator();
        while (parts.hasNext()) {
            Element curModel;
            EditPart curEP = (EditPart)parts.next();
            if (!(curEP instanceof ModelElementEditPart) || !((curModel = ((ModelElementEditPart)curEP).getElement()) instanceof Reference)) continue;
            this.mySelectedUins.add(curModel.getUniqueName());
        }
    }

    private void restoreSelection() {
        if (!this.myIsDiagramValidOnStart) {
            return;
        }
        LinkedList<GraphicalEditPart> partsToSelect = new LinkedList<GraphicalEditPart>();
        Iterator collectedSelection = this.mySelectedUins.iterator();
        while (collectedSelection.hasNext()) {
            ReferenceUniqueName curUin = (ReferenceUniqueName)collectedSelection.next();
            IUpdatableElement element = this.myDiagram.findDiagramElement(curUin);
            if (!(element instanceof DiagramElement)) continue;
            partsToSelect.add(((DiagramElement)element).getEditPart());
        }
        if (!partsToSelect.isEmpty()) {
            this.myDiagram.getViewPart().getViewer().setSelection((ISelection)new StructuredSelection(partsToSelect));
        }
    }
}

