/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.internal;

import com.tssap.selena.ui.IPropertyMarshaler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.geometry.Point;

public class GDEBendpointListMarshaller
implements IPropertyMarshaler {
    public String marshal(Object value) {
        List list = (List)value;
        String s = this.toString(list);
        return s;
    }

    public Object unmarshal(String value) {
        List result;
        if (value != null) {
            StringTokenizer tokenizer = new StringTokenizer(value, ",");
            result = this.readBendpoints(tokenizer);
        } else {
            result = new ArrayList();
        }
        return result;
    }

    protected List readBendpoints(StringTokenizer tokenizer) {
        ArrayList<Bendpoint> list = new ArrayList<Bendpoint>();
        while (tokenizer.hasMoreTokens()) {
            try {
                Bendpoint bp = this.readBendpoint(tokenizer);
                list.add(bp);
            }
            catch (Exception e) {
                break;
            }
        }
        return list;
    }

    protected Bendpoint readBendpoint(StringTokenizer tokenizer) {
        Point location = this.readPoint(tokenizer);
        AbsoluteBendpoint bp = new AbsoluteBendpoint(location);
        return bp;
    }

    protected Point readPoint(StringTokenizer tokenizer) {
        String sX = tokenizer.nextToken();
        String sY = tokenizer.nextToken();
        int x = Integer.parseInt(sX);
        int y = Integer.parseInt(sY);
        Point p = new Point(x, y);
        return p;
    }

    protected String toString(List list) {
        String s = "";
        Iterator itr = list.iterator();
        while (itr.hasNext()) {
            Bendpoint bp = (Bendpoint)itr.next();
            if (s.length() > 0) {
                s = s + ",";
            }
            s = s + this.toString(bp);
        }
        return s;
    }

    protected String toString(Bendpoint bp) {
        String s = this.toString(bp.getLocation());
        return s;
    }

    protected String toString(Point p) {
        String s = p.x + "," + p.y;
        return s;
    }
}

