/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.internal;

import com.tssap.selena.gde.internal.DiagramElement;
import com.tssap.selena.gde.internal.DiagramRootEditPart;
import com.tssap.selena.gde.internal.EditPartSelectionConverter;
import com.tssap.selena.gde.internal.editparts.NodeEditPart;
import com.tssap.selena.gde.zoom.Zoomer;
import com.tssap.selena.ui.internal.ChromePlugin;
import com.tssap.selena.ui.internal.ContextMenuContributor;
import com.tssap.selena.ui.internal.SortingMenuManager;
import com.tssap.selena.ui.internal.StandardMenuGroups;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.draw2d.EventDispatcher;
import org.eclipse.draw2d.GraphicsSource;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.SWTEventDispatcher;
import org.eclipse.draw2d.ScrollBar;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.UpdateListener;
import org.eclipse.draw2d.UpdateManager;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.ui.parts.DomainEventDispatcher;
import org.eclipse.gef.ui.parts.GraphicalViewerImpl;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class DiagramViewer
extends GraphicalViewerImpl {
    private SortingMenuManager myMenuManager;
    private DiagramEventDispatcher myEventDispatcher;
    private LightweightSystem myLightweightSystem;
    private Zoomer myZoomer = null;

    protected void hookControl() {
        if (this.getControl() == null) {
            return;
        }
        this.myMenuManager = new SortingMenuManager();
        this.myMenuManager.addMenuListener((IMenuListener)this);
        this.myMenuManager.setRemoveAllWhenShown(true);
        Menu menu = this.myMenuManager.createContextMenu(this.getControl());
        this.getControl().setMenu(menu);
        if (this.getRootEditPart() != null) {
            this.getRootEditPart().activate();
        }
        this.refreshDragSourceAdapter();
        this.refreshDropTargetAdapter();
        LightweightSystem lws = this.getLightweightSystem();
        lws.setControl((Canvas)this.getControl());
    }

    public Zoomer getZoomer() {
        if (this.myZoomer == null) {
            this.myZoomer = new Zoomer();
        }
        return this.myZoomer;
    }

    public void setEditDomain(EditDomain domain) {
        super.setEditDomain(domain);
        if ("motif".equals(SWT.getPlatform())) {
            LightweightSystem lws = this.getLightweightSystem();
            lws.setEventDispatcher((EventDispatcher)new DiagramEventDispatcher(domain, (EditPartViewer)this, true));
        }
    }

    public void menuAboutToShow(IMenuManager menu) {
        DiagramViewer.createStandardGroups(menu);
        ISelection selection = new EditPartSelectionConverter((ISelectionProvider)this).getSelection();
        ContextMenuContributor[] contributors = ChromePlugin.getInstance().getContextMenuContributors();
        int ci = 0;
        while (ci < contributors.length) {
            contributors[ci].addMenu(menu, selection);
            ++ci;
        }
        super.menuAboutToShow(menu);
    }

    private static void createStandardGroups(IMenuManager menu) {
        StandardMenuGroups.addStandardGroups((IMenuManager)menu);
    }

    public EditPart findObjectAtExcluding(Point pt, Collection exclude) {
        EditPart ep = super.findObjectAtExcluding(pt, exclude);
        if (ep instanceof NodeEditPart) {
            return ep;
        }
        ArrayList<IFigure> c = new ArrayList<IFigure>(exclude.size() + 1);
        c.add(this.getLayerManager().getLayer((Object)"Primary Layer"));
        c.addAll(exclude);
        EditPart ep1 = super.findObjectAtExcluding(pt, c);
        if (ep1 instanceof ConnectionEditPart) {
            return ep1;
        }
        return ep;
    }

    public final boolean revealDiagramElement(DiagramElement diagramElement) {
        if (diagramElement == null) {
            return false;
        }
        return this.revealEditPart(diagramElement.getEditPart());
    }

    public boolean revealEditPart(GraphicalEditPart editPart) {
        if (editPart == null) {
            return false;
        }
        ScrollPane scrollPane = this.findDiagramScrollPane();
        if (scrollPane == null) {
            System.err.println("can not find scroll pane");
            return false;
        }
        IFigure toReveal = editPart.getFigure();
        if (toReveal == null || !toReveal.isVisible()) {
            return false;
        }
        Point zero = new Point(0, 0);
        toReveal.translateToAbsolute((Translatable)zero);
        Point figureCenter = toReveal.getBounds().getCenter();
        toReveal.translateToAbsolute((Translatable)figureCenter);
        figureCenter.x -= zero.x;
        figureCenter.y -= zero.y;
        DiagramViewer.scrollToBounds(scrollPane, figureCenter);
        if ("gtk".equals(BootLoader.getWS()) && this.getControl() != null) {
            this.getControl().redraw();
        }
        return true;
    }

    public boolean isEditPartVisible(GraphicalEditPart editPart) {
        if (editPart == null) {
            return false;
        }
        ScrollPane scrollPane = this.findDiagramScrollPane();
        if (scrollPane == null) {
            return false;
        }
        Viewport viewport = scrollPane.getViewport();
        if (viewport == null) {
            return false;
        }
        Point viewPortTopLeft = viewport.getBounds().getTopLeft();
        Point viewPortBottomRight = viewport.getBounds().getBottomRight();
        viewport.translateToAbsolute((Translatable)viewPortTopLeft);
        viewport.translateToAbsolute((Translatable)viewPortBottomRight);
        IFigure figure = editPart.getFigure();
        Point figureTopLeft = figure.getBounds().getTopLeft();
        figure.translateToAbsolute((Translatable)figureTopLeft);
        return new Rectangle(viewPortTopLeft, viewPortBottomRight).contains(figureTopLeft);
    }

    private ScrollPane findDiagramScrollPane() {
        RootEditPart rootEP = this.getRootEditPart();
        if (rootEP instanceof DiagramRootEditPart) {
            DiagramRootEditPart ep = (DiagramRootEditPart)rootEP;
            return ep.getDiagramScrollPane();
        }
        return null;
    }

    private static void scrollToBounds(ScrollPane scrollPane, Point absoluteFigureCenter) {
        if (scrollPane == null) {
            return;
        }
        Viewport viewport = scrollPane.getViewport();
        Point viewportCenter = viewport.getBounds().getCenter();
        int x = Math.max(0, absoluteFigureCenter.x - viewportCenter.x);
        int y = Math.max(0, absoluteFigureCenter.y - viewportCenter.y);
        scrollPane.scrollTo(new Point(x, y));
    }

    public void dispose() {
        this.getControl().dispose();
        this.setSelection((ISelection)new StructuredSelection());
        super.dispose();
        this.getContents().dispose();
    }

    public Control createControl(Composite parent) {
        if (this.getControl() != null) {
            return this.getControl();
        }
        Canvas canvas = new Canvas(parent, 2816);
        canvas.getVerticalBar().setVisible(false);
        canvas.getHorizontalBar().setVisible(false);
        canvas.getVerticalBar().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ScrollPane sp = ((DiagramRootEditPart)DiagramViewer.this.getRootEditPart()).getDiagramScrollPane();
                ScrollBar scrollBar = sp.getVerticalScrollBar();
                if (!scrollBar.isVisible() && !(scrollBar = sp.getHorizontalScrollBar()).isVisible()) {
                    return;
                }
                int value = -1;
                int inc = scrollBar.getStepIncrement();
                if (e.detail == 0x1000002) {
                    value = Math.min(scrollBar.getMaximum(), scrollBar.getValue() + inc);
                } else if (e.detail == 0x1000001) {
                    value = Math.max(0, scrollBar.getValue() - inc);
                }
                if (value != -1) {
                    scrollBar.setValue(value);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.setControl((Control)canvas);
        return canvas;
    }

    protected LightweightSystem getLightweightSystem() {
        if (this.myLightweightSystem == null) {
            this.myLightweightSystem = new LightweightSystem((Canvas)this.getControl()){

                public void setUpdateManager(UpdateManager manager) {
                    super.setUpdateManager((UpdateManager)new ProxyUpdateManager(manager));
                }
            };
        }
        return this.myLightweightSystem;
    }

    private static class DiagramEventDispatcher
    extends DomainEventDispatcher {
        private boolean myIsMotif = false;
        private EditDomain myDomain;
        private EditPartViewer myViewer;

        public DiagramEventDispatcher(EditDomain d, EditPartViewer v, boolean motif) {
            super(d, v);
            this.myIsMotif = motif;
        }

        public void dispatchMousePressed(MouseEvent me) {
            if (!this.myIsMotif) {
                super.dispatchMousePressed(me);
                return;
            }
            if (me.button == 1) {
                super.dispatchMousePressed(me);
            } else {
                this.setRouteEventsToEditor(false);
                EditDomain d = this.domain;
                this.domain = null;
                super.dispatchMousePressed(me);
                this.domain = d;
            }
        }

        public void dispose() {
            if (this.domain.getActiveTool() != null) {
                this.domain.getActiveTool().deactivate();
            }
            this.domain = null;
            ((SWTEventDispatcher)this).control = null;
            this.viewer = null;
            super.setRoot(null);
            this.setCapture(null);
            this.setFocus(null);
            this.setMouseTarget(null);
        }
    }

    private class ProxyUpdateManager
    extends UpdateManager {
        private UpdateManager myUpdateManager;

        ProxyUpdateManager(UpdateManager updateManager) {
            this.myUpdateManager = updateManager;
        }

        public void addDirtyRegion(IFigure figure, int x, int y, int w, int h) {
            this.myUpdateManager.addDirtyRegion(figure, x - (int)(2.0f / DiagramViewer.this.getZoomer().getScale()), y - (int)(2.0f / DiagramViewer.this.getZoomer().getScale()), w + (int)(4.0f / DiagramViewer.this.getZoomer().getScale()), h + (int)(4.0f / DiagramViewer.this.getZoomer().getScale()));
        }

        public void addInvalidFigure(IFigure figure) {
            this.myUpdateManager.addInvalidFigure(figure);
        }

        public void addUpdateListener(UpdateListener listener) {
            this.myUpdateManager.addUpdateListener(listener);
        }

        public void performUpdate() {
            this.myUpdateManager.performUpdate();
        }

        public void performUpdate(Rectangle exposed) {
            exposed.x -= (int)(2.0f / DiagramViewer.this.getZoomer().getScale());
            exposed.y -= (int)(2.0f / DiagramViewer.this.getZoomer().getScale());
            exposed.width += (int)(4.0f / DiagramViewer.this.getZoomer().getScale());
            exposed.height += (int)(4.0f / DiagramViewer.this.getZoomer().getScale());
            this.myUpdateManager.performUpdate(exposed);
        }

        public void removeUpdateListener(UpdateListener listener) {
            this.myUpdateManager.removeUpdateListener(listener);
        }

        public void setGraphicsSource(GraphicsSource gs) {
            this.myUpdateManager.setGraphicsSource(gs);
        }

        public void setRoot(IFigure figure) {
            this.myUpdateManager.setRoot(figure);
        }
    }
}

