/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.internal;

import com.tssap.selena.gde.internal.DiagramImpl;
import com.tssap.selena.gde.internal.DiagramViewer;
import com.tssap.selena.gde.internal.DiagramViewerAdapterFactory;
import com.tssap.selena.gde.internal.EditDomainAdapterFactory;
import com.tssap.selena.gde.internal.EditPartSelectionConverter;
import com.tssap.selena.gde.internal.PaletteRootAdapterFactory;
import com.tssap.selena.gde.internal.RegistryContextMenuProvider;
import com.tssap.selena.gde.internal.palette.GDEPaletteRoot;
import com.tssap.selena.gde.internal.palette.ui.GDEPaletteViewer;
import com.tssap.selena.gde.internal.toolbar.def.ToolbarDefRegistry;
import com.tssap.selena.gde.toolbar.IGDEToolbarAction;
import com.tssap.selena.ui.multipageview.IMemberViewPart;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.ViewPart;

public class DiagramViewPart
extends ViewPart
implements IMemberViewPart {
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("com.tssap.selena.gde.internal.diagramContextHelp");
    private static final String PREFIX_SEPARATOR = ".";
    private static final String DIAGRAM_PREFIX = "diagram.";
    private static final String PALETTE_PREFIX = "toolbar.";
    private DiagramImpl myDiagram;
    private String myDiagramMetaclass;
    private Canvas myPaletteControl;
    private IContributionItem[] myToolbarContributions;
    private DividedComposite mySplitter;
    private RegistryContextMenuProvider myRegistryContextMenuProvider;
    static /* synthetic */ Class class$org$eclipse$gef$ui$palette$PaletteViewer;
    static /* synthetic */ Class class$org$eclipse$gef$palette$PaletteRoot;
    static /* synthetic */ Class class$com$tssap$selena$gde$internal$DiagramViewer;

    public DiagramViewPart(DiagramImpl diagram, String diagramMetaclass) {
        this.myDiagram = diagram;
        this.myDiagramMetaclass = diagramMetaclass;
    }

    public void createPartControl(Composite parent) {
        this.mySplitter = new DividedComposite(parent);
        this.createPaletteControl(this.mySplitter);
        Control diagramControl = this.getViewer().createControl(this.mySplitter);
        if (diagramControl != null) {
            diagramControl.addHelpListener((HelpListener)new TypedContextHelpListener(DIAGRAM_PREFIX));
        }
        this.myRegistryContextMenuProvider = new RegistryContextMenuProvider((IWorkbenchPart)this);
        this.getViewer().setContextMenuProvider(this.myRegistryContextMenuProvider);
        this.getSite().setSelectionProvider((ISelectionProvider)new EditPartSelectionConverter((ISelectionProvider)this.getViewer()));
    }

    public IContributionItem[] getToolBarContributions() {
        if (this.myToolbarContributions == null) {
            ArrayList contributions = new ArrayList();
            List defaultContributions = (List)ToolbarDefRegistry.getInstance().getDef("<all_diagrams>").createToolbarContribution();
            List specificContributions = (List)ToolbarDefRegistry.getInstance().getDef(this.myDiagramMetaclass).createToolbarContribution();
            contributions.addAll(defaultContributions);
            contributions.addAll(specificContributions);
            Iterator itr = contributions.iterator();
            while (itr.hasNext()) {
                IAction action;
                IContributionItem contribution = (IContributionItem)itr.next();
                if (!(contribution instanceof ActionContributionItem) || !((action = ((ActionContributionItem)contribution).getAction()) instanceof IGDEToolbarAction)) continue;
                ((IGDEToolbarAction)action).setDiagramView(this);
            }
            this.myToolbarContributions = contributions.toArray(new IContributionItem[contributions.size()]);
        }
        return this.myToolbarContributions;
    }

    public void dispose() {
        if (this.myDiagram == null) {
            return;
        }
        this.getSite().setSelectionProvider(null);
        if (this.getPaletteViewer() != null) {
            this.getPaletteViewer().dispose();
        }
        if (this.myDiagram != null) {
            EditDomainAdapterFactory.disposeAdapter(this.myDiagram);
            DiagramViewerAdapterFactory.disposeAdapter(this.myDiagram);
            this.myDiagram.dispose();
        }
        this.myDiagram = null;
        if (this.myPaletteControl != null) {
            if (!this.myPaletteControl.isDisposed()) {
                this.myPaletteControl.dispose();
            }
            this.myPaletteControl = null;
        }
        if (this.mySplitter != null && !this.mySplitter.isDisposed()) {
            this.mySplitter.dispose();
        }
        this.myRegistryContextMenuProvider.dispose();
        this.mySplitter = null;
        if (this.myToolbarContributions != null) {
            int i = 0;
            while (i < this.myToolbarContributions.length) {
                IAction action;
                IContributionItem contribution = this.myToolbarContributions[i];
                if (contribution instanceof ActionContributionItem && (action = ((ActionContributionItem)contribution).getAction()) instanceof IGDEToolbarAction) {
                    ((IGDEToolbarAction)action).setDiagramView(null);
                }
                ++i;
            }
        }
        this.myToolbarContributions = null;
        super.dispose();
    }

    public void setFocus() {
    }

    public void setInput(EditPart diagram) {
    }

    public boolean getPaletteVisible() {
        return this.myPaletteControl.getVisible();
    }

    public void setPaletteVisible(boolean visible) {
        this.myPaletteControl.setVisible(visible);
        this.mySplitter.layout();
    }

    public boolean getPaletteLabelStatus() {
        boolean status = this.getPaletteRoot().getLabelStatus();
        return status;
    }

    public void setPaletteLabelStatus(boolean status) {
        GDEPaletteRoot root = this.getPaletteRoot();
        root.setLabelStatus(status);
        GDEPaletteViewer viewer = this.getPaletteViewer();
        viewer.setPaletteRoot((PaletteRoot)root);
        viewer.getControl().redraw();
        this.mySplitter.layout();
    }

    public void updatePalette() {
        GDEPaletteViewer viewer = this.getPaletteViewer();
        if (viewer == null) {
            return;
        }
        PaletteRootAdapterFactory.clear();
        viewer.setPaletteRoot((PaletteRoot)this.getPaletteRoot());
        if (viewer.getControl() != null && !viewer.getControl().isDisposed()) {
            viewer.getControl().redraw();
        }
        if (!this.mySplitter.isDisposed()) {
            this.mySplitter.layout();
        }
    }

    private void createPaletteControl(Composite parent) {
        this.myPaletteControl = new Canvas(parent, 2048);
        this.getPaletteViewer().setControl((Control)this.myPaletteControl);
        this.myPaletteControl.addHelpListener((HelpListener)new TypedContextHelpListener(PALETTE_PREFIX));
    }

    public GDEPaletteViewer getPaletteViewer() {
        return (GDEPaletteViewer)((Object)this.myDiagram.getAdapter(class$org$eclipse$gef$ui$palette$PaletteViewer == null ? (class$org$eclipse$gef$ui$palette$PaletteViewer = DiagramViewPart.class$("org.eclipse.gef.ui.palette.PaletteViewer")) : class$org$eclipse$gef$ui$palette$PaletteViewer));
    }

    public void update() {
        this.updatePalette();
        if (this.getViewer() != null && this.getViewer().getControl() != null && !this.getViewer().getControl().isDisposed()) {
            this.getViewer().getControl().redraw();
        }
    }

    private GDEPaletteRoot getPaletteRoot() {
        return (GDEPaletteRoot)this.myDiagram.getAdapter(class$org$eclipse$gef$palette$PaletteRoot == null ? (class$org$eclipse$gef$palette$PaletteRoot = DiagramViewPart.class$("org.eclipse.gef.palette.PaletteRoot")) : class$org$eclipse$gef$palette$PaletteRoot);
    }

    public DiagramViewer getViewer() {
        return (DiagramViewer)((Object)this.myDiagram.getAdapter(class$com$tssap$selena$gde$internal$DiagramViewer == null ? (class$com$tssap$selena$gde$internal$DiagramViewer = DiagramViewPart.class$("com.tssap.selena.gde.internal.DiagramViewer")) : class$com$tssap$selena$gde$internal$DiagramViewer));
    }

    public DiagramImpl getDiagram() {
        return this.myDiagram;
    }

    private String getContextHelpID(String prefix) {
        String[] projectNatures = this.getDiagram().getProjectNatures();
        int i = 0;
        while (i < projectNatures.length) {
            String helpID = this.getContextHelpResource(prefix + projectNatures[i] + PREFIX_SEPARATOR + this.myDiagramMetaclass);
            if (!helpID.equals("")) {
                return helpID;
            }
            ++i;
        }
        return this.getContextHelpResource(prefix + this.myDiagramMetaclass);
    }

    private String getContextHelpResource(String key) {
        try {
            return RESOURCE_BUNDLE.getString(key);
        }
        catch (MissingResourceException ex) {
            return "";
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class DividedComposite
    extends Composite {
        static final int SPACE = 0;
        static final int PALETTE_WIDTH_ADDITION = 6;

        DividedComposite(Composite parent) {
            super(parent, 0);
            this.addListener(11, new Listener(){

                public void handleEvent(Event e) {
                    this.layout(true);
                }
            });
        }

        public void layout(boolean changed) {
            Control[] children = this.getChildren();
            if (children.length != 2) {
                super.layout(changed);
                return;
            }
            this.checkWidget();
            Rectangle area = this.getClientArea();
            Control paletteControl = children[0];
            Control diagramControl = children[1];
            if (paletteControl.getVisible()) {
                Rectangle paletteBounds = new Rectangle(area.x, area.y, this.getPaletteWidth(), area.height);
                Rectangle diagramBounds = new Rectangle(area.x + (paletteBounds.width + 0), area.y, area.width - (paletteBounds.width + 0), area.height);
                paletteControl.setBounds(paletteBounds);
                diagramControl.setBounds(diagramBounds);
            } else {
                diagramControl.setBounds(area);
            }
        }

        private int getPaletteWidth() {
            GDEPaletteViewer paletteViewer = DiagramViewPart.this.getPaletteViewer();
            IFigure rootFigure = paletteViewer.getRootFigure();
            int width = Math.max(rootFigure.getMinimumSize().width, rootFigure.getPreferredSize().width);
            return width;
        }
    }

    public class TypedContextHelpListener
    implements HelpListener {
        private String myHelpPrefix;

        private TypedContextHelpListener(String contextHelpPrefix) {
            this.myHelpPrefix = contextHelpPrefix;
        }

        public void helpRequested(HelpEvent event) {
            String contextHelpID;
            Object sourceObject = event.getSource();
            if (sourceObject instanceof Control && !(contextHelpID = DiagramViewPart.this.getContextHelpID(this.myHelpPrefix)).equals("")) {
                WorkbenchHelp.setHelp((Control)((Control)sourceObject), (String)contextHelpID);
            }
        }
    }
}

