/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.internal;

import com.tssap.selena.gde.internal.DiagramElement;
import com.tssap.selena.gde.internal.DiagramNode;
import com.tssap.selena.gde.internal.GdePlugin;
import com.tssap.selena.gde.internal.editparts.NodeEditPart;
import com.tssap.selena.gde.internal.rcnode.RCNodeView;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.ReferenceContainer;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.ReferenceEnumeration;
import com.tssap.selena.model.update.diagram.DiagramFactory;
import com.tssap.selena.model.update.diagram.IUpdatableNode;
import com.tssap.selena.model.view.View;
import com.tssap.selena.model.view.ViewAccess;
import com.tssap.selena.model.view.ViewManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;

public class DiagramRCNode
extends DiagramNode {
    private ReferenceCollection myReferenceCollection;
    private RCNodeView myView;
    private Disposer myViewDisposer;

    public DiagramRCNode(Element model, DiagramNode parent) {
        super(model, parent);
    }

    protected void init(Element model) {
        String viewType;
        if (this.isInsideRCNode(this)) {
            return;
        }
        this.myReferenceCollection = (ReferenceCollection)((Reference)model).getEntity();
        ViewManager viewManager = ViewAccess.getViewManager((UniqueName)this.myReferenceCollection.getModel().getUniqueName());
        if (viewManager.canCreateView(this.myReferenceCollection, viewType = "com.tssap.selena.model.diagram.rc")) {
            this.myView = (RCNodeView)viewManager.createView(this.myReferenceCollection, viewType);
            this.myView.setHost(this);
        }
    }

    public void disposeView() {
        Model model = this.myReferenceCollection.getModel();
        if (model == null || model.isDeleted()) {
            return;
        }
        ViewManager viewManager = ViewAccess.getViewManager((UniqueName)model.getUniqueName());
        if (viewManager == null) {
            return;
        }
        viewManager.disposeView((View)this.myView);
        this.myViewDisposer.shutdown();
        this.myViewDisposer = null;
    }

    protected void internalCreateChildren(ReferenceContainer container, IProgressMonitor pm) {
        if (this.isInsideRCNode(this)) {
            return;
        }
        ReferenceEnumeration dependencyLinks = container.references();
        while (dependencyLinks.hasMoreElements()) {
            Reference cur = dependencyLinks.next();
            Entity curLink = cur.getEntity();
            if (curLink == null || !"com.tssap.twse.package.dependency".equals(curLink.getUniqueName().getDomain())) continue;
            this.hack_createLink(cur);
        }
        ReferenceEnumeration subReferences = this.myReferenceCollection.references();
        while (subReferences.hasMoreElements()) {
            Reference curSubReference = subReferences.next();
            String type = curSubReference.getPropertyValue("$metaclass");
            this.addChildType(type);
            if (Boolean.TRUE.toString().equals(this.getContent().getPropertyValue("hide" + type))) {
                if (GdePlugin.getDefault().isDiagramOpening()) continue;
                curSubReference.getEntity().setPropertyValue("#invoke_inplace", null);
                continue;
            }
            if (Boolean.TRUE.toString().equals(curSubReference.getPropertyValue("$hiddenWithOptions"))) continue;
            this.createDiagramChild(curSubReference);
        }
        this.myViewDisposer = new Disposer(this);
    }

    protected void createDiagramChild(Reference reference) {
        if (this.isInsideRCNode(this)) {
            return;
        }
        Entity mayBeLink = reference.getEntity();
        if (mayBeLink != null && "com.tssap.twse.package.dependency".equals(mayBeLink.getUniqueName().getDomain())) {
            this.hack_createLink(reference);
            return;
        }
        IUpdatableNode result = DiagramFactory.createNode((IUpdatableNode)this, (Reference)reference);
        this.add(result);
    }

    protected void hack_createLink(Reference reference) {
        super.createDiagramChild(reference);
    }

    private static class Disposer
    extends EditPartListener.Stub
    implements EditPartListener {
        private DiagramRCNode myNodeToDispose;
        private NodeEditPart myEditPartToListen;

        public Disposer(DiagramRCNode nodeToDispose) {
            this.myNodeToDispose = nodeToDispose;
            if (this.myNodeToDispose.getParentNode() instanceof DiagramElement) {
                this.myEditPartToListen = ((DiagramNode)this.myNodeToDispose.getParentNode()).getNodeEditPart();
                this.myEditPartToListen.addEditPartListener(this);
            }
        }

        public void removingChild(EditPart child, int index) {
            if (this.myNodeToDispose.getEditPart().equals(child)) {
                this.myNodeToDispose.disposeView();
            }
        }

        void shutdown() {
            if (this.myEditPartToListen != null) {
                this.myEditPartToListen.removeEditPartListener(this);
                this.myEditPartToListen = null;
            }
            this.myNodeToDispose = null;
        }
    }
}

