/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.internal;

import com.tssap.selena.gde.ModelNodeEditPart;
import com.tssap.selena.gde.internal.DiagramElement;
import com.tssap.selena.gde.internal.DiagramImpl;
import com.tssap.selena.gde.internal.DiagramLink;
import com.tssap.selena.gde.internal.DiagramRCNode;
import com.tssap.selena.gde.internal.GdePlugin;
import com.tssap.selena.gde.internal.Messages;
import com.tssap.selena.gde.internal.NodeLinkResolver;
import com.tssap.selena.gde.internal.SafeUinHashMap;
import com.tssap.selena.gde.internal.editparts.NodeEditPart;
import com.tssap.selena.impl.model.elements.ReferenceUniqueNameImpl;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelDeltaNode;
import com.tssap.selena.model.elements.Participant;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceContainer;
import com.tssap.selena.model.elements.ReferenceUniqueName;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.ReferenceEnumeration;
import com.tssap.selena.model.update.diagram.DiagramFactory;
import com.tssap.selena.model.update.diagram.IUpdatableElement;
import com.tssap.selena.model.update.diagram.IUpdatableLink;
import com.tssap.selena.model.update.diagram.IUpdatableNode;
import com.tssap.selena.model.util.Assert;
import com.tssap.selena.ui.internal.ChromePlugin;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;

public class DiagramNode
extends DiagramElement
implements IUpdatableNode {
    protected static long ourReferenceIterationTime;
    protected static long ourHiddenTime;
    protected static long ourLinkResolvingTime;
    protected Map myChildNodes = new SafeUinHashMap(new HashMap());
    private Map myOutgoingConnections = new SafeUinHashMap(new HashMap());
    private Map myIncomingConnections = new SafeUinHashMap(new HashMap());
    private boolean myIsUpdatableContainer;
    protected static int myUpdateCount;
    protected HashMap myChildTypes;
    private boolean myIsPreservingChildTypes;
    static /* synthetic */ Class class$org$eclipse$draw2d$geometry$Rectangle;

    public DiagramNode(Element model, DiagramNode parent, IProgressMonitor pm) {
        super(model, parent);
        this.init(model);
        if (parent instanceof DiagramRCNode) {
            return;
        }
        String metaclass = model.getPropertyValue("$metaclass");
        if ("Class".equals(metaclass) && !(parent instanceof DiagramImpl)) {
            return;
        }
        if (!("Operation".equals(metaclass) || "Attribute".equals(metaclass) || "Property".equals(metaclass))) {
            this.internalCreateChildren((ReferenceContainer)model, pm);
        }
    }

    public DiagramNode(Element model, DiagramNode parent) {
        this(model, parent, null);
    }

    protected int getUpdateCount() {
        return myUpdateCount;
    }

    protected void init(Element element) {
    }

    protected void collectAllSubnodes(Collection subnodes) {
        Iterator it = this.getChildNodes().iterator();
        while (it.hasNext()) {
            DiagramNode childNode = (DiagramNode)it.next();
            if (subnodes.contains(childNode)) continue;
            subnodes.add(childNode);
            childNode.collectAllSubnodes(subnodes);
        }
    }

    protected void adjustSize() {
        this.adjustSize(false);
    }

    public void adjustSize(boolean recursively) {
        Rectangle bounds;
        if (this.getDiagram().isJustLayouted(this) || this.getNodeEditPart().isInner() || Boolean.TRUE.toString().equals(this.getContent().getPropertyValue("bounds_setted_by_user"))) {
            return;
        }
        ModelNodeEditPart editPart = (ModelNodeEditPart)this.getEditPart();
        Dimension dimension = new Dimension(this.getEditPart().getFigure().getPreferredSize());
        dimension.height = Math.max(editPart.getMinimumSize().height, dimension.height);
        dimension.width = Math.max(editPart.getMinimumSize().width, dimension.width);
        if (this.getDiagram().getMaximumClassWidth() > 0 && this.getContent() instanceof Reference && "Class".equals(((Reference)this.getContent()).getEntity().getPropertyValue("$metaclass"))) {
            dimension.width = Math.min(dimension.width, this.getDiagram().getMaximumClassWidth());
        }
        if (!dimension.equals((Object)(bounds = ((ModelNodeEditPart)this.getEditPart()).getBounds()).getSize()) || bounds.x <= 0 && bounds.y <= 0) {
            bounds.setSize(dimension);
            ((ModelNodeEditPart)this.getEditPart()).setBounds(bounds);
            this.getDiagram().deferRefresh(this, bounds.x <= 0 && bounds.y <= 0, true);
            this.getDiagram().addJustLayouted(this);
        }
        if (recursively && this.getParentNode() != null && !(this.getParentNode() instanceof DiagramImpl)) {
            ((DiagramNode)this.getParentNode()).adjustSize(recursively);
        }
    }

    protected void internalCreateChildren(ReferenceContainer container, IProgressMonitor pm) {
        if (pm != null) {
            pm.subTask(Messages.getString("DiagramNode.Creating_Diagram_Elements"));
        }
        ArrayList<Reference> referencesList = new ArrayList<Reference>();
        long start = System.currentTimeMillis();
        ReferenceEnumeration subReferences = container.references();
        while (subReferences.hasMoreElements()) {
            Reference curSubReference = subReferences.next();
            if (curSubReference.getPropertyValue("$metaclass") == null) continue;
            this.addChildType(curSubReference.getPropertyValue("$metaclass"));
            referencesList.add(curSubReference);
        }
        ourReferenceIterationTime += System.currentTimeMillis() - start;
        Iterator references = ((AbstractList)referencesList).iterator();
        while (references.hasNext()) {
            Reference curSubReference = (Reference)references.next();
            start = System.currentTimeMillis();
            boolean hidden = Boolean.TRUE.toString().equals(curSubReference.getPropertyValue("$hiddenWithOptions"));
            ourHiddenTime += System.currentTimeMillis() - start;
            if (hidden) {
                if (GdePlugin.getDefault().isDiagramOpening()) continue;
                curSubReference.getEntity().setPropertyValue("#invoke_inplace", null);
                continue;
            }
            this.createDiagramChild(curSubReference);
        }
        if (pm != null) {
            pm.worked(1);
        }
    }

    protected void createDiagramChild(Reference reference) {
        ++myUpdateCount;
        long start = System.currentTimeMillis();
        Participant[] edges = NodeLinkResolver.getInstance().isRepresentedByLink(reference);
        ourLinkResolvingTime += System.currentTimeMillis() - start;
        if (edges != null) {
            if ("Message Link".equals(reference.getPropertyValue("$metaclass"))) {
                Reference parentRef = (Reference)reference.getReferenceContainer();
                if ("Messages Link".equals(parentRef.getPropertyValue("$metaclass"))) {
                    IUpdatableNode result = DiagramFactory.createNode((IUpdatableNode)this, (Reference)reference);
                    if (!this.isInsideRCNode(this)) {
                        this.add(result);
                    }
                    return;
                }
            } else if ("Messages Link".equals(reference.getPropertyValue("$metaclass"))) {
                IUpdatableNode result = DiagramFactory.createNode((IUpdatableNode)this, (Reference)reference);
                if (!this.isInsideRCNode(this)) {
                    this.add(result);
                }
            }
            if (!this.isInsideRCNode(this)) {
                this.getDiagram().registerLink(reference, edges);
            }
        } else if (!this.isInsideRCNode(this)) {
            IUpdatableNode result = DiagramFactory.createNode((IUpdatableNode)this, (Reference)reference);
            this.add(result);
        }
    }

    protected boolean isInsideRCNode(DiagramNode node) {
        if (node == null) {
            return false;
        }
        if (node.getParentNode() instanceof DiagramRCNode) {
            return true;
        }
        return this.isInsideRCNode((DiagramNode)node.getParentNode());
    }

    public Collection getChildNodes() {
        if (this.myChildNodes == null) {
            this.myChildNodes = new HashMap();
        }
        return this.myChildNodes.values();
    }

    public Collection getChildLinks() {
        return this.myIncomingConnections.values();
    }

    public void removeIncomingLinks() {
        Iterator entries = new HashMap(this.myIncomingConnections).entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry curEntry = entries.next();
            DiagramLink curLink = (DiagramLink)curEntry.getValue();
            ReferenceUniqueNameImpl curLinkUin = curLink.getReferenceUin();
            if (this.getDiagram().findDiagramElement((ReferenceUniqueName)curLinkUin) == null) continue;
            if (this.getDiagram().findDiagramElement((ReferenceUniqueName)curLinkUin) != curLink) {
                throw new IllegalStateException("wrong incoming link was registered in diagram deep content");
            }
            this.getDiagram().returnToNotProcessedList(curLink);
        }
        this.myIncomingConnections.clear();
    }

    public void removeOutgoingLinks() {
        Iterator entries = new HashMap(this.myOutgoingConnections).entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry curEntry = entries.next();
            DiagramLink curLink = (DiagramLink)curEntry.getValue();
            ReferenceUniqueNameImpl curLinkUin = curLink.getReferenceUin();
            if (this.getDiagram().findDiagramElement((ReferenceUniqueName)curLinkUin) == null) continue;
            if (this.getDiagram().findDiagramElement((ReferenceUniqueName)curLinkUin) != curLink) {
                throw new IllegalStateException("wrong incoming link was registered in diagram deep content");
            }
            this.getDiagram().removeLink(curLink);
        }
        this.myOutgoingConnections.clear();
    }

    public void modelChanged(ModelDeltaNode dispatchedDelta) {
        try {
            this.getDiagram().startUpdate();
            Enumeration subdeltas = dispatchedDelta.changedChildren();
            while (subdeltas.hasMoreElements()) {
                ModelDeltaNode subDelta = (ModelDeltaNode)subdeltas.nextElement();
                if (subDelta.isTotallyChanged()) {
                    this.myIsPreservingChildTypes = true;
                    this.remove(subDelta);
                    if (subDelta.getElement() instanceof Reference && ((Reference)subDelta.getElement()).getEntity() != null && !((Reference)subDelta.getElement()).getEntity().isDeleted()) {
                        this.add(subDelta);
                    }
                    this.myIsPreservingChildTypes = false;
                    this.adjustSize(true);
                    continue;
                }
                if (subDelta.isNew()) {
                    this.add(subDelta);
                    this.adjustSize(true);
                    continue;
                }
                if (subDelta.isDeleted()) {
                    this.remove(subDelta);
                    this.adjustSize(true);
                    continue;
                }
                if (subDelta.isChanged()) {
                    if (this.getDiagram().isResizedObject(subDelta.getElement())) {
                        this.change(subDelta);
                    } else {
                        this.rebuild(subDelta);
                    }
                    this.adjustSize(true);
                    continue;
                }
                if (!this.getDiagram().hasResizedObjects() && this.isUpdatableContainer((ReferenceUniqueName)subDelta.getElementUniqueName())) {
                    this.rebuild(subDelta);
                    this.adjustSize(true);
                    continue;
                }
                this.dispatchToNextLevel(subDelta);
            }
            Object var5_4 = null;
            this.getDiagram().finishUpdate();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.getDiagram().finishUpdate();
            throw throwable;
        }
    }

    private void rebuild(ModelDeltaNode delta) {
        this.myIsPreservingChildTypes = true;
        this.remove(delta);
        this.add(delta);
        this.myIsPreservingChildTypes = false;
    }

    private void add(ModelDeltaNode node) {
        if (node.getElement() == null) {
            System.err.println("DeltaNode:getElement() return null");
            return;
        }
        if (node.getElement().isDeleted()) {
            return;
        }
        Assert.isLegal((boolean)(node.getElement() instanceof Reference), (String)("diagram elements should not get entity-changes notifications: " + node.getElement()));
        Reference newReference = (Reference)node.getElement();
        this.addChildType(newReference.getPropertyValue("$metaclass"));
        boolean hidden = Boolean.TRUE.toString().equals(newReference.getPropertyValue("$hiddenWithOptions"));
        if (hidden) {
            newReference.getEntity().setPropertyValue("#invoke_inplace", null);
            return;
        }
        ReferenceUniqueName newReferenceUin = (ReferenceUniqueName)newReference.getUniqueName();
        IUpdatableElement newDiagramElement = this.getDiagram().findDiagramElement(newReference);
        if (newDiagramElement != null) {
            return;
        }
        this.createDiagramChild(newReference);
        DiagramNode newDiagramNode = (DiagramNode)this.getDiagram().findDiagramElement(newReference);
        if (newDiagramNode != null) {
            this.getNodeEditPart().addChild(newDiagramNode.getEditPart());
            DiagramImpl.internalAdjustSize(newDiagramNode);
        }
    }

    private boolean remove(ModelDeltaNode node) {
        ReferenceUniqueName deletedReferenceUin = (ReferenceUniqueName)node.getElementUniqueName();
        IUpdatableElement diagramElementToDelete = (IUpdatableElement)this.myChildNodes.get(deletedReferenceUin);
        if (diagramElementToDelete != null) {
            this.remove(diagramElementToDelete);
            this.myChildNodes.remove(deletedReferenceUin);
            ((DiagramElement)diagramElementToDelete).getEditPart().dispose();
            this.getNodeEditPart().removeChild(((DiagramElement)diagramElementToDelete).getEditPart());
            return true;
        }
        diagramElementToDelete = this.getDiagram().findDiagramElement(deletedReferenceUin);
        if (diagramElementToDelete instanceof IUpdatableLink) {
            this.getDiagram().removeLink((DiagramLink)diagramElementToDelete);
        }
        return diagramElementToDelete != null;
    }

    private void change(ModelDeltaNode node) {
        DiagramNode diagramNode;
        if (!(node.getElement() instanceof Reference)) {
            return;
        }
        Reference changedReference = (Reference)node.getElement();
        ReferenceUniqueName changedReferenceUin = (ReferenceUniqueName)changedReference.getUniqueName();
        IUpdatableElement changedDiagramElement = this.getDiagram().findDiagramElement(changedReferenceUin);
        if (changedDiagramElement instanceof DiagramLink) {
            ((DiagramLink)changedDiagramElement).adjustSize();
            this.getDiagram().deferRefresh((DiagramLink)changedDiagramElement, true, true);
            return;
        }
        if (changedDiagramElement == null) {
            return;
        }
        IUpdatableElement diagramElementToUpdate = (IUpdatableElement)this.myChildNodes.get(node.getElementUniqueName());
        if (diagramElementToUpdate instanceof DiagramNode && !(diagramNode = (DiagramNode)diagramElementToUpdate).getNodeEditPart().isInner()) {
            String strBounds = diagramNode.getContent().getPropertyValue("bounds");
            Rectangle newBounds = (Rectangle)ChromePlugin.getInstance().getPropertyMarshaler((Object)(class$org$eclipse$draw2d$geometry$Rectangle == null ? (class$org$eclipse$draw2d$geometry$Rectangle = DiagramNode.class$("org.eclipse.draw2d.geometry.Rectangle")) : class$org$eclipse$draw2d$geometry$Rectangle).getName()).unmarshal(strBounds);
            if (!diagramNode.getNodeEditPart().getBounds().equals((Object)newBounds)) {
                diagramNode.getNodeEditPart().setBounds(newBounds);
            }
            this.getDiagram().deferRefresh(diagramNode, false, true);
        }
        this.dispatchToNextLevel(node);
    }

    private void dispatchToNextLevel(ModelDeltaNode node) {
        ReferenceUniqueName targetUin = (ReferenceUniqueName)node.getElementUniqueName();
        IUpdatableElement diagramTarget = (IUpdatableElement)this.myChildNodes.get(targetUin);
        if (diagramTarget == null) {
            diagramTarget = this.getDiagram().findDiagramElement(targetUin);
            if (diagramTarget instanceof DiagramLink) {
                this.rebuild(node);
                return;
            }
            return;
        }
        diagramTarget.modelChanged(node);
    }

    public void add(IUpdatableNode newChild) {
        DiagramNode childNode = (DiagramNode)newChild;
        this.myChildNodes.put(childNode.getReferenceUin(), newChild);
        this.getDiagram().deferRefresh(childNode, false, false);
    }

    public void add(IUpdatableLink newChild, boolean isTarget) {
        DiagramLink childLink = (DiagramLink)newChild;
        if (isTarget) {
            this.myIncomingConnections.put(childLink.getReferenceUin(), newChild);
        }
    }

    public IUpdatableElement remove(IUpdatableElement childToDelete) {
        if (((ModelNodeEditPart)this.getEditPart()).isInner()) {
            return null;
        }
        if (childToDelete instanceof DiagramNode) {
            this.removeChildType(childToDelete.getContent().getPropertyValue("$metaclass"));
            DiagramNode childNode = (DiagramNode)childToDelete;
            Iterator children = ((AbstractList)new ArrayList(childNode.getChildNodes())).iterator();
            while (children.hasNext()) {
                DiagramNode node = (DiagramNode)children.next();
                childNode.remove(node);
                this.getDiagram().undoRefresh(childNode);
            }
            if (!(this.getParentNode() instanceof DiagramRCNode)) {
                childNode.removeIncomingLinks();
                childNode.removeOutgoingLinks();
            }
            this.myChildNodes.remove(childNode.getReferenceUin());
            if (!"Messages Link".equals(childNode.getContent().getPropertyValue("$metaclass"))) {
                this.getDiagram().unregisterElement(childNode);
            } else {
                UniqueName contentUin = childNode.getContent().getUniqueName();
                Collection linksCol = this.getChildLinks();
                if (linksCol != null) {
                    Iterator links = linksCol.iterator();
                    while (links.hasNext()) {
                        DiagramLink link = (DiagramLink)links.next();
                        if (!contentUin.equals(link.getContent().getUniqueName())) continue;
                        this.getDiagram().removeLink(link);
                        break;
                    }
                }
            }
            this.getDiagram().deferRefresh(this, false, true);
        } else {
            this.getDiagram().removeLink((DiagramLink)childToDelete);
        }
        return childToDelete;
    }

    protected GraphicalEditPart createEditPart() {
        NodeEditPart ep = GdePlugin.getDefault().getModelElementEditPartFactory().createNodeEditPart(this.getContent());
        ep.setChildTypes(this.myChildTypes);
        return ep;
    }

    public NodeEditPart getNodeEditPart() {
        return (NodeEditPart)this.getEditPart();
    }

    private Model getModel() {
        return this.getContent().getModel();
    }

    public void removeIncomingLink(DiagramLink link) {
        this.myIncomingConnections.remove(link.getReferenceUin());
        super.removeIncomingLink(link);
    }

    public void removeOutgoingLink(DiagramLink link) {
        this.myOutgoingConnections.remove(link.getReferenceUin());
    }

    public boolean isUpdatableContainer(ReferenceUniqueName uin) {
        IUpdatableElement diagramElement = this.getDiagram().findDiagramElement(uin);
        if (diagramElement instanceof DiagramNode) {
            return ((DiagramNode)diagramElement).isUpdatableContainer();
        }
        return false;
    }

    public void setUpdatableContainer(boolean updatable) {
        this.myIsUpdatableContainer = updatable;
    }

    public boolean isUpdatableContainer() {
        return this.myIsUpdatableContainer;
    }

    protected void addChildType(String type) {
        int[] count;
        if (this.myIsPreservingChildTypes) {
            return;
        }
        if (this.myChildTypes == null) {
            this.myChildTypes = new HashMap();
        }
        if ((count = (int[])this.myChildTypes.get(type)) == null) {
            count = new int[]{0};
            this.myChildTypes.put(type, count);
        }
        count[0] = count[0] + 1;
    }

    protected void removeChildType(String type) {
        int[] count;
        if (this.myIsPreservingChildTypes) {
            return;
        }
        if (this.myChildTypes != null && (count = (int[])this.myChildTypes.get(type)) != null && count[0] > 0) {
            count[0] = count[0] - 1;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

