/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.internal;

import com.tssap.selena.gde.IBendpointList;
import com.tssap.selena.gde.internal.DiagramElement;
import com.tssap.selena.gde.internal.DiagramNode;
import com.tssap.selena.gde.internal.GdePlugin;
import com.tssap.selena.gde.internal.editparts.LinkEditPart;
import com.tssap.selena.gde.internal.editparts.NodeEditPart;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.update.diagram.IUpdatableElement;
import com.tssap.selena.model.update.diagram.IUpdatableLink;
import com.tssap.selena.model.update.diagram.IUpdatableNode;
import com.tssap.selena.ui.IPropertyMarshaler;
import com.tssap.selena.ui.internal.ChromePlugin;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.GraphicalEditPart;

public class DiagramLink
extends DiagramElement
implements IUpdatableLink {
    private IUpdatableElement myTarget;
    private DiagramNode mySource;

    public DiagramLink(Element model, DiagramNode source, IUpdatableElement target) {
        super(model, source.getDiagram());
        this.myTarget = target;
        this.mySource = source;
    }

    public IUpdatableNode getSourceNode() {
        return this.mySource;
    }

    public IUpdatableElement getTargetElement() {
        return this.myTarget;
    }

    protected GraphicalEditPart createEditPart() {
        NodeEditPart sourceEP = this.mySource.getNodeEditPart();
        return GdePlugin.getDefault().getModelElementEditPartFactory().createLinkEditPart(((DiagramNode)this.getSourceNode()).getDiagram(), this.getContent(), sourceEP);
    }

    protected void adjustSize() {
        this.getLinkEditPart().setSourceAnchor(this.getContent().getPropertyValue("sourceAnchor"));
        this.getLinkEditPart().setTargetAnchor(this.getContent().getPropertyValue("targetAnchor"));
        String bendpointsStr = this.getContent().getPropertyValue("bendpoints");
        IPropertyMarshaler marshaller = ChromePlugin.getInstance().getPropertyMarshaler((Object)IBendpointList.MARSHALLER_ID);
        List points = new ArrayList();
        if (bendpointsStr != null) {
            points = (List)marshaller.unmarshal(bendpointsStr);
        }
        Point[] bendpoints = points.toArray(new Point[points.size()]);
        this.getLinkEditPart().setBendpointLocations(bendpoints);
        if (this.getParentNode() != null) {
            ((DiagramNode)this.getParentNode()).adjustSize();
        }
    }

    public LinkEditPart getLinkEditPart() {
        return (LinkEditPart)this.getEditPart();
    }
}

