/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.internal;

import com.tssap.selena.gde.DiagramLayouts;
import com.tssap.selena.gde.IBendpointList;
import com.tssap.selena.gde.ModelElementEditPart;
import com.tssap.selena.gde.internal.DebugProgressMonitor;
import com.tssap.selena.gde.internal.DebugProgressMonitorDialog;
import com.tssap.selena.gde.internal.DiagramElement;
import com.tssap.selena.gde.internal.DiagramLink;
import com.tssap.selena.gde.internal.DiagramMultiPageViewPart;
import com.tssap.selena.gde.internal.DiagramNode;
import com.tssap.selena.gde.internal.DiagramRCNode;
import com.tssap.selena.gde.internal.DiagramViewPart;
import com.tssap.selena.gde.internal.GdePlugin;
import com.tssap.selena.gde.internal.Messages;
import com.tssap.selena.gde.internal.NodeLinkResolver;
import com.tssap.selena.gde.internal.PreservingSelectionOperation;
import com.tssap.selena.gde.internal.SafeUinHashMap;
import com.tssap.selena.gde.internal.editparts.DiagramEditPart;
import com.tssap.selena.gde.internal.editparts.LinkEditPart;
import com.tssap.selena.gde.internal.editparts.NodeEditPart;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.ModelDeltaNode;
import com.tssap.selena.model.elements.Participant;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.ReferenceContainer;
import com.tssap.selena.model.elements.ReferenceUniqueName;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.preferences.PreferencesPlugin;
import com.tssap.selena.model.ui.actions.TextActionHandlerExt;
import com.tssap.selena.model.update.diagram.DiagramFactory;
import com.tssap.selena.model.update.diagram.IDiagram;
import com.tssap.selena.model.update.diagram.IUpdatableElement;
import com.tssap.selena.model.update.diagram.IUpdatableNode;
import com.tssap.selena.model.update.hierarchy.Revisit;
import com.tssap.selena.model.update.hierarchy.SingleDiagramUpdater;
import com.tssap.selena.model.util.Assert;
import com.tssap.selena.model.util.ParticipantAdapter;
import com.tssap.selena.ui.internal.ChromePlugin;
import com.tssap.selena.ui.internal.debug.MemoryUsageDialog;
import com.tssap.selena.ui.multipageview.IMemberViewPart;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.RootEditPart;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class DiagramImpl
extends DiagramNode
implements IDiagram {
    private volatile long start;
    private String[] myProjectNatures;
    private int myUpdateCounter;
    private Collection myJustLayouted;
    private Collection myLayoutedInPreviousCommand;
    private List myResizedObjects;
    private List myDeferredElements;
    private Map myRegisteredReferencesToLinks;
    private List myDisplayedLinks;
    private DiagramViewPart myDiagramViewPart;
    private SingleDiagramUpdater myUpdater;
    private boolean myLayouterRuns = false;
    private HashSet myElementsSelectedForLayout = null;
    private HashSet myReshapedElementsForLayout = null;
    private HashSet myReshapedElements = null;
    private DiagramMultiPageViewPart myMultiPageViewPart;
    private boolean myViewPartInitialized = false;
    private DeepElementsCache myDeepElementsCache;
    private int myMaximumClassWidth = PreferencesPlugin.getPreferenceStore((String)"workspace", null).getInt("class_width");
    private List myLinksToUpdate;
    private static final String UML_PERSPECTIVE_ID = "com.togethersoft.selena.perspective.uml";
    private static final String J2EE_PERSPECTIVE_ID = "com.togethersoft.selena.j2ee.ui.perspective";
    private long myStartTime;
    private HashMap myTopLevelClasses;
    static /* synthetic */ Class class$com$tssap$selena$gde$internal$DiagramViewer;
    static /* synthetic */ Class class$org$eclipse$draw2d$geometry$Rectangle;

    public DiagramImpl(SingleDiagramUpdater updater, ReferenceCollection model, IProgressMonitor pm) {
        super((Element)model, null, (IProgressMonitor)pm);
        if (pm == null) {
            pm = new DebugProgressMonitor((IProgressMonitor)new NullProgressMonitor());
        }
        if (GdePlugin.isLogEnabled()) {
            System.err.println("[gde.monitor.internal] hidden state fetching : " + DiagramNode.ourHiddenTime + " ms.");
            System.err.println("[gde.monitor.internal] reference iteration   : " + DiagramNode.ourReferenceIterationTime + " ms.");
            System.err.println("[gde.monitor.internal] link resolving        : " + DiagramNode.ourLinkResolvingTime + " ms.");
        }
        DiagramNode.ourReferenceIterationTime = 0L;
        DiagramNode.ourHiddenTime = 0L;
        DiagramNode.ourLinkResolvingTime = 0L;
        pm.subTask(Messages.getString("DiagramImpl.Executing_Viewmaps_Task") + DiagramNode.myUpdateCount + ")");
        this.getAdapter(class$com$tssap$selena$gde$internal$DiagramViewer == null ? (class$com$tssap$selena$gde$internal$DiagramViewer = DiagramImpl.class$("com.tssap.selena.gde.internal.DiagramViewer")) : class$com$tssap$selena$gde$internal$DiagramViewer);
        DiagramImpl.internalAdjustSize(this);
        pm.worked(1);
        this.myUpdater = updater;
        pm.subTask(Messages.getString("DiagramImpl.Drawing_Links_and_Layouting_Task"));
        this.initTimeLayout((IProgressMonitor)pm);
        this.dumpStatistic();
    }

    static void internalAdjustSize(DiagramNode node) {
        Iterator children = node.getChildNodes().iterator();
        while (children.hasNext()) {
            DiagramNode child = (DiagramNode)children.next();
            if (child.getEditPart() == null) continue;
            node.getNodeEditPart().addChild(child.getEditPart());
            DiagramImpl.internalAdjustSize(child);
        }
        Rectangle bounds = (Rectangle)ChromePlugin.getInstance().getPropertyMarshaler((Object)(class$org$eclipse$draw2d$geometry$Rectangle == null ? (class$org$eclipse$draw2d$geometry$Rectangle = DiagramImpl.class$("org.eclipse.draw2d.geometry.Rectangle")) : class$org$eclipse$draw2d$geometry$Rectangle).getName()).unmarshal(node.getContent().getPropertyValue("bounds"));
        if (bounds != null) {
            node.getNodeEditPart().setBounds(bounds);
        }
        node.adjustSize();
        node.getNodeEditPart().getFigure().validate();
    }

    protected void init(Element element) {
        this.myStartTime = System.currentTimeMillis();
        DiagramNode.myUpdateCount = 0;
        GdePlugin.getDefault().setDiagramOpening(true);
    }

    public void modelChanged(final ModelDeltaNode delta) {
        this.myStartTime = System.currentTimeMillis();
        DiagramNode.myUpdateCount = 0;
        if (delta.isTotallyChanged()) {
            this.myProjectNatures = null;
            this.myTopLevelClasses = null;
            this.myMaximumClassWidth = PreferencesPlugin.getPreferenceStore((String)"workspace", null).getInt("class_width");
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(Messages.getString("DiagramImpl.Updating_Diagram_Task"), 5);
                    monitor.subTask(Messages.getString("DiagramImpl.Removing_Diagram_Elements_Task"));
                    DiagramImpl.this.startUpdate();
                    Iterator nodes = ((AbstractList)new ArrayList(DiagramImpl.this.getChildNodes())).iterator();
                    while (nodes.hasNext()) {
                        DiagramNode node = (DiagramNode)nodes.next();
                        DiagramImpl.this.remove(node);
                        DiagramImpl.this.getNodeEditPart().removeChild(node.getEditPart());
                    }
                    GraphicalEditPart oldEditPart = DiagramImpl.this.getEditPart();
                    RootEditPart root = oldEditPart.getRoot();
                    DiagramImpl.this.setEditPart(null);
                    oldEditPart.dispose();
                    root.setContents((EditPart)DiagramImpl.this.getEditPart());
                    DiagramImpl.this.finishUpdate();
                    monitor.worked(1);
                    monitor.subTask(Messages.getString("DiagramImpl.Creating_Diagram_Elements_Task"));
                    DiagramImpl.this.internalCreateChildren((ReferenceContainer)DiagramImpl.this.getContent(), null);
                    monitor.worked(1);
                    monitor.subTask(Messages.getString("DiagramImpl.Executing_Viewmaps_Task") + DiagramNode.myUpdateCount + ")");
                    DiagramImpl.internalAdjustSize(DiagramImpl.this);
                    monitor.worked(1);
                    DiagramImpl.this.initTimeLayout(monitor);
                    DiagramImpl.this.getViewPart().update();
                    monitor.done();
                }
            };
            try {
                new DebugProgressMonitorDialog(null).run(false, false, op);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (delta.isChanged()) {
            DiagramMultiPageViewPart view = this.findMultiPageViewPart();
            int i = 0;
            while (i < view.getPageCount()) {
                IMemberViewPart viewPart = view.getPage(i);
                if (viewPart != null && viewPart.equals(this.getViewPart())) {
                    view.setPageText(i, this.getContent().getPropertyValue("$name"));
                    view.setToolTipText(i, this.getToolTipText());
                }
                ++i;
            }
            this.getViewPart().update();
        }
        if (!delta.isTotallyChanged()) {
            Runnable updateCommand = new Runnable(){

                public void run() {
                    DiagramImpl.super.modelChanged(delta);
                }
            };
            new PreservingSelectionOperation(this, updateCommand).run();
        }
        if (GdePlugin.isLogEnabled()) {
            System.err.println("[gde.monitor] update took : " + (System.currentTimeMillis() - this.myStartTime));
        }
        this.dumpStatistic();
    }

    protected void dumpStatistic() {
        if (DiagramNode.myUpdateCount > 0) {
            long totalTime = System.currentTimeMillis() - this.myStartTime;
            double ups = DiagramImpl.getUPS(totalTime, this.getUpdateCount());
            MemoryUsageDialog.setUPS((double)ups);
            DiagramNode.myUpdateCount = 0;
        }
    }

    protected static double getUPS(long time, int count) {
        double nofups = time / (long)count;
        double ups = 1000.0 / nofups;
        return ups;
    }

    public int getMaximumClassWidth() {
        return this.myMaximumClassWidth;
    }

    public String[] getProjectNatures() {
        if (this.myProjectNatures == null) {
            ArrayList<String> naturesList = new ArrayList<String>();
            PropertyEnumeration natures = this.getContent().getModel().properties("$nature");
            while (natures.hasMoreElements()) {
                Property nature = natures.next();
                naturesList.add(nature.getValue());
            }
            this.myProjectNatures = naturesList.toArray(new String[naturesList.size()]);
        }
        return this.myProjectNatures;
    }

    public Object getAdapter(Class adapter) {
        Object result = Platform.getAdapterManager().getAdapter((Object)this, adapter);
        if (result == null) {
            result = super.getAdapter(adapter);
        }
        return result;
    }

    public DiagramViewPart getViewPart() {
        return this.myDiagramViewPart;
    }

    public Participant[] removeLink(DiagramLink link) {
        this.getDisplayedLinks().remove(link);
        Reference linkContent = (Reference)link.getContent();
        if (this.getRegisteredReferencesToLinks().containsKey(linkContent)) {
            return (Participant[])this.getRegisteredReferencesToLinks().remove(linkContent);
        }
        IUpdatableNode source = link.getSourceNode();
        IUpdatableElement target = link.getTargetElement();
        Participant[] result = null;
        if (source != null || target != null) {
            Entity targetEntity;
            Entity sourceEntity;
            result = new Participant[2];
            if (source != null && (sourceEntity = ((Reference)source.getContent()).getEntity()) != null) {
                result[0] = new ParticipantAdapter(sourceEntity.getUniqueName(), "Client");
            }
            if (target != null && (targetEntity = ((Reference)target.getContent()).getEntity()) != null) {
                result[1] = new ParticipantAdapter(targetEntity.getUniqueName(), "Supplier");
            }
        }
        this.processEditPartsOnRemovingLink(link);
        this.unregisterElement(link);
        return result;
    }

    private void processEditPartsOnRemovingLink(DiagramLink link) {
        if (this.getDeepElementsCache().getByReferenceUin((ReferenceUniqueName)link.getReferenceUin()) == null) {
            return;
        }
        DiagramNode linkSource = (DiagramNode)link.getSourceNode();
        DiagramElement linkTarget = (DiagramElement)link.getTargetElement();
        if (linkSource != null) {
            linkSource.removeIncomingLink(link);
            NodeEditPart sourceEP = linkSource.getNodeEditPart();
            if (sourceEP != null) {
                sourceEP.removeLinkAsSource((ConnectionEditPart)link.getLinkEditPart());
            }
        }
        if (linkTarget != null) {
            linkTarget.removeIncomingLink(link);
            ModelElementEditPart targetEP = (ModelElementEditPart)linkTarget.getEditPart();
            if (targetEP != null) {
                targetEP.removeLinkAsTarget((ConnectionEditPart)link.getLinkEditPart());
            }
        }
        link.getLinkEditPart().dispose();
    }

    public void returnToNotProcessedList(DiagramLink link) {
        Participant[] entities = this.removeLink(link);
        Reference linkReference = (Reference)link.getContent();
        if (linkReference == null) {
            throw new NullPointerException("link without content");
        }
        if (entities != null) {
            this.registerLink(linkReference, entities);
        }
    }

    private DiagramMultiPageViewPart findMultiPageViewPart() {
        HashSet<IViewPart> views = new HashSet<IViewPart>();
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchWindow window = windows[i];
            IWorkbenchPage[] pages = window.getPages();
            int j = 0;
            while (j < pages.length) {
                IWorkbenchPage page = pages[j];
                IViewPart view = page.findView("com.tssap.selena.gde.diagramMultiPageView");
                if (view != null) {
                    views.add(view);
                }
                ++j;
            }
            ++i;
        }
        if (!views.isEmpty()) {
            return (DiagramMultiPageViewPart)((Object)views.iterator().next());
        }
        return null;
    }

    private DiagramMultiPageViewPart openMultiPageViewPart() {
        try {
            IWorkbenchPage page = this.getPageToOpenOn();
            if (page == null) {
                return null;
            }
            this.myMultiPageViewPart = (DiagramMultiPageViewPart)page.showView("com.tssap.selena.gde.diagramMultiPageView");
        }
        catch (CoreException e) {
            e.printStackTrace();
            throw new IllegalStateException("Can not access multipage view part: com.tssap.selena.gde.diagramMultiPageView");
        }
        return this.myMultiPageViewPart;
    }

    public TextActionHandlerExt getTextActionHandler() {
        return this.myMultiPageViewPart == null ? null : this.myMultiPageViewPart.getTextActionHandler();
    }

    private IWorkbenchPage getPageToOpenOn() throws CoreException {
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWindow != null) {
            return activeWindow.getActivePage();
        }
        return null;
    }

    public void reactivate() {
        DiagramMultiPageViewPart multiPageView = this.openMultiPageViewPart();
        multiPageView.setActivePage(this.myDiagramViewPart);
    }

    public void dispose() {
        if (this.myUpdater != null) {
            this.myUpdater.shutDown();
        }
        super.dispose();
    }

    public void closeView() {
        DiagramMultiPageViewPart multiPageView;
        Iterator nodes = ((AbstractList)new ArrayList(this.getChildNodes())).iterator();
        while (nodes.hasNext()) {
            DiagramNode next = (DiagramNode)nodes.next();
            if (!(next instanceof DiagramRCNode)) continue;
            ((DiagramRCNode)next).disposeView();
        }
        this.myChildNodes = null;
        this.myDeepElementsCache = null;
        this.myDeferredElements = null;
        this.myDisplayedLinks = null;
        this.myJustLayouted = null;
        this.myElementsSelectedForLayout = null;
        this.myLayoutedInPreviousCommand = null;
        if (this.myDiagramViewPart != null && this.myDiagramViewPart.getViewSite() != null && (multiPageView = this.findMultiPageViewPart()) != null) {
            multiPageView.removePage(this.myDiagramViewPart);
        }
        this.myUpdater.shutDown();
        this.myMultiPageViewPart = null;
        this.myDiagramViewPart = null;
        this.myUpdater = null;
        this.myTopLevelClasses = null;
    }

    public void initViewPart() {
        if (!this.myViewPartInitialized) {
            DiagramMultiPageViewPart multiPageView = this.openMultiPageViewPart();
            this.myDiagramViewPart = new DiagramViewPart(this, this.getContent().getPropertyValue("$metaclass"));
            try {
                int pageIndex = multiPageView.addPage(this.myDiagramViewPart);
                multiPageView.setPageText(pageIndex, this.getContent().getPropertyValue("$name"));
                multiPageView.setToolTipText(pageIndex, this.getToolTipText());
                String diagramMetaclass = this.getContent().getPropertyValue("$metaclass");
                Image image = this.getDiagramIcon(diagramMetaclass);
                multiPageView.setPageImage(pageIndex, image);
                multiPageView.setActivePage(pageIndex);
            }
            catch (PartInitException addingToMultiViewFails) {
                Revisit.revisit();
                throw new RuntimeException("adding of the page to multiPageView fails: multiPage = " + (Object)((Object)multiPageView) + ", page: " + this.myDiagramViewPart);
            }
            this.myViewPartInitialized = true;
        }
        GdePlugin.getDefault().setDiagramOpening(false);
    }

    private Image getDiagramIcon(String diagramMetaclass) {
        return ChromePlugin.getInstance().getImageBundle().getImage(diagramMetaclass);
    }

    public List links() {
        return this.getDisplayedLinks();
    }

    public void startUpdate() {
        ++this.myUpdateCounter;
    }

    public void finishUpdate() {
        --this.myUpdateCounter;
        if (this.myUpdateCounter < 0) {
            Revisit.revisit();
            throw new IllegalStateException("finishUpdate without opening startUpdate");
        }
        if (this.myUpdateCounter == 0) {
            try {
                block8: {
                    try {
                        this.updateRegisteredLinks();
                        this.processRegisteredLinks();
                        this.doPartialLayout(false);
                        Iterator it = this.getDeferredElements().iterator();
                        while (it.hasNext()) {
                            DiagramElement element = (DiagramElement)it.next();
                            if (element.getParentNode() == null) continue;
                            element.getEditPart().refresh();
                        }
                        if (this.myLinksToUpdate == null) break block8;
                        Iterator it2 = this.myLinksToUpdate.iterator();
                        while (it2.hasNext()) {
                            DiagramElement element = (DiagramElement)it2.next();
                            this.getReshapedElements().add(element);
                            if (element.getParentNode() == null) continue;
                            element.getEditPart().refresh();
                        }
                        this.myLinksToUpdate = null;
                    }
                    catch (NullPointerException npe) {
                        npe.printStackTrace();
                        Object var5_6 = null;
                        this.myDeferredElements = null;
                        this.clearResizedObjects();
                        this.storeReshapedBounds();
                    }
                }
                Object var5_5 = null;
                this.myDeferredElements = null;
                this.clearResizedObjects();
                this.storeReshapedBounds();
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.myDeferredElements = null;
                this.clearResizedObjects();
                this.storeReshapedBounds();
                throw throwable;
            }
        }
    }

    public void storeReshapedBounds() {
        boolean changed = false;
        Iterator reshapedElements = this.getReshapedElements().iterator();
        while (reshapedElements.hasNext()) {
            String bendpointsStr;
            DiagramElement reshapedElement = (DiagramElement)reshapedElements.next();
            if (reshapedElement instanceof DiagramImpl) continue;
            Element element = reshapedElement.getContent();
            if (reshapedElement instanceof DiagramNode) {
                Rectangle newBounds = ((DiagramNode)reshapedElement).getNodeEditPart().getBounds();
                String boundsStr = null;
                if (newBounds == null || (boundsStr = ChromePlugin.getInstance().getPropertyMarshaler((Object)(class$org$eclipse$draw2d$geometry$Rectangle == null ? DiagramImpl.class$("org.eclipse.draw2d.geometry.Rectangle") : class$org$eclipse$draw2d$geometry$Rectangle).getName()).marshal((Object)newBounds)).equals(element.getPropertyValue("bounds"))) continue;
                this.addResizedObject(element);
                element.setPropertyValue("bounds", boundsStr);
                changed = true;
                continue;
            }
            if (!(reshapedElement instanceof DiagramLink)) continue;
            LinkEditPart linkEditPart = ((DiagramLink)reshapedElement).getLinkEditPart();
            String oldSourceAnchor = element.getPropertyValue("sourceAnchor");
            String oldTargetAnchor = element.getPropertyValue("targetAnchor");
            String newSourceAnchor = linkEditPart.getSourceAnchor();
            String newTargetAnchor = linkEditPart.getTargetAnchor();
            if (!DiagramImpl.areStringsEquals(oldSourceAnchor, newSourceAnchor)) {
                this.addResizedObject(element);
                element.setPropertyValue("sourceAnchor", newSourceAnchor);
                changed = true;
            }
            if (!DiagramImpl.areStringsEquals(oldTargetAnchor, newTargetAnchor)) {
                this.addResizedObject(element);
                element.setPropertyValue("targetAnchor", newTargetAnchor);
                changed = true;
            }
            if ((bendpointsStr = ChromePlugin.getInstance().getPropertyMarshaler((Object)IBendpointList.MARSHALLER_ID).marshal((Object)linkEditPart.getBendpointList().getBendpoints())).equals(element.getPropertyValue("bendpoints"))) continue;
            this.addResizedObject(element);
            element.setPropertyValue("bendpoints", bendpointsStr);
            changed = true;
        }
        if (!changed) {
            this.getJustLayoutedElements().clear();
        }
        this.myLayoutedInPreviousCommand = new ArrayList(this.getJustLayoutedElements());
        this.myReshapedElements = null;
    }

    private Collection getJustLayoutedElements() {
        if (this.myJustLayouted == null) {
            this.myJustLayouted = new HashSet();
        }
        return this.myJustLayouted;
    }

    public void addJustLayouted(Object obj) {
        this.getJustLayoutedElements().add(obj);
    }

    public boolean isJustLayouted(Object obj) {
        return this.myLayoutedInPreviousCommand != null && this.myLayoutedInPreviousCommand.contains(obj);
    }

    public void initTimeLayout(IProgressMonitor pm) {
        pm.subTask(Messages.getString("DiagramImpl.Processing_Links_Task") + this.getRegisteredReferencesToLinks().keySet().size() + ")");
        this.processRegisteredLinks();
        pm.worked(1);
        pm.subTask(Messages.getString("DiagramImpl.Layouting_Task"));
        boolean diagramContainsPositionedNodes = false;
        Iterator it = this.getChildNodes().iterator();
        while (it.hasNext()) {
            if (((DiagramNode)it.next()).getContent().getPropertyValue("bounds") == null) continue;
            diagramContainsPositionedNodes = true;
            break;
        }
        if (diagramContainsPositionedNodes) {
            this.doPartialLayout(true);
        } else {
            this.doFullLayout();
        }
        HashSet allnodes = new HashSet();
        this.collectAllSubnodes(allnodes);
        Iterator it2 = allnodes.iterator();
        while (it2.hasNext()) {
            DiagramNode node = (DiagramNode)it2.next();
            if (node.getEditPart() == null) continue;
            node.getEditPart().refresh();
        }
        Iterator it3 = this.links().iterator();
        while (it3.hasNext()) {
            DiagramLink link = (DiagramLink)it3.next();
            link.getEditPart().refresh();
        }
        this.storeReshapedBounds();
        pm.worked(1);
    }

    public void optimizeSizes() {
        HashSet allnodes = new HashSet();
        this.collectAllSubnodes(allnodes);
        Iterator it = allnodes.iterator();
        while (it.hasNext()) {
            DiagramNode node = (DiagramNode)it.next();
            if (node.getContent().getPropertyValue("bounds_setted_by_user") == null) continue;
            this.addResizedObject(node);
            node.getContent().setPropertyValue("bounds_setted_by_user", null);
        }
        this.prepareAllLinksForLayout();
        Iterator it2 = allnodes.iterator();
        while (it2.hasNext()) {
            DiagramNode node = (DiagramNode)it2.next();
            node.adjustSize();
        }
    }

    protected void prepareAllLinksForLayout() {
        Iterator it = this.links().iterator();
        while (it.hasNext()) {
            DiagramLink link = (DiagramLink)it.next();
            if (link.getContent().getPropertyValue("bounds_setted_by_user") == null) continue;
            link.getContent().setPropertyValue("bounds_setted_by_user", null);
            this.addResizedObject(link);
        }
    }

    public void adjustSize(boolean rec) {
        this.adjustSize();
    }

    protected void adjustSize() {
        if (this.getNodeEditPart() == null || this.getNodeEditPart().getFigure() == null) {
            return;
        }
        Rectangle oldBounds = this.getNodeEditPart().getFigure().getBounds();
        this.getNodeEditPart().getFigure().getLayoutManager().invalidate();
        if (oldBounds != null) {
            oldBounds.setSize(this.getNodeEditPart().getFigure().getPreferredSize());
            this.getNodeEditPart().getFigure().setBounds(oldBounds);
        }
    }

    public void addResizedObject(Object object) {
        if (this.myResizedObjects == null) {
            this.myResizedObjects = new ArrayList();
        }
        this.myResizedObjects.add(object);
    }

    public void clearResizedObjects() {
        this.myResizedObjects = null;
    }

    public boolean hasResizedObjects() {
        return this.myResizedObjects != null && this.myResizedObjects.size() > 0;
    }

    public boolean isResizedObject(Object object) {
        return this.myResizedObjects != null && this.myResizedObjects.contains(object);
    }

    public void doFullLayout() {
        this.doFullLayout(false, null);
    }

    public void doFullLayoutForPrinting(Dimension gridDimension) {
        this.doFullLayout(true, gridDimension);
    }

    public void doFullLayout(boolean forPrinting, Dimension gridDimension) {
        if (this.myLayouterRuns) {
            return;
        }
        try {
            this.myLayouterRuns = true;
            this.myElementsSelectedForLayout = null;
            this.myReshapedElements = null;
            this.prepareAllLinksForLayout();
            DiagramLayouts.getLayoutManager(this).fullLayout(this, forPrinting, gridDimension);
            this.getReshapedElements().addAll(this.getChildNodes());
            this.getReshapedElements().addAll(this.links());
            Iterator links = this.getReshapedElements().iterator();
            while (links.hasNext()) {
                this.addJustLayouted(links.next());
            }
            Iterator nodes = this.getChildNodes().iterator();
            while (nodes.hasNext()) {
                DiagramNode node = (DiagramNode)nodes.next();
                node.getEditPart().refresh();
            }
            Iterator links2 = this.links().iterator();
            while (links2.hasNext()) {
                DiagramLink link = (DiagramLink)links2.next();
                link.getEditPart().refresh();
            }
            this.storeReshapedBounds();
            Object var8_7 = null;
            this.myLayouterRuns = false;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.myLayouterRuns = false;
            throw throwable;
        }
    }

    public void doPartialLayout() {
        this.doPartialLayout(false);
        this.clearResizedObjects();
        this.storeReshapedBounds();
    }

    public void doPartialLayout(boolean forced) {
        if (this.myLayouterRuns) {
            return;
        }
        try {
            this.myLayouterRuns = true;
            if (forced || this.getElementsSelectedForLayout().size() > 0 || this.getReshapedElementsForLayout().size() > 0) {
                HashSet elementsSelectedForLayout = this.getElementsSelectedForLayout();
                this.myElementsSelectedForLayout = null;
                HashSet reshapedElements = this.getReshapedElementsForLayout();
                this.myReshapedElementsForLayout = null;
                DiagramLayouts.getLayoutManager(this).partialLayout(this, elementsSelectedForLayout, reshapedElements);
                this.getReshapedElements().addAll(reshapedElements);
                this.getReshapedElements().addAll(elementsSelectedForLayout);
                Iterator links = this.getReshapedElements().iterator();
                while (links.hasNext()) {
                    this.addJustLayouted(links.next());
                }
            }
            Object var6_5 = null;
            this.myLayouterRuns = false;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.myLayouterRuns = false;
            throw throwable;
        }
    }

    private void doSelectedLayout(Collection selectedElements) {
        DiagramLayouts.getLayoutManager(this).selectedLayout(this, selectedElements);
        this.getReshapedElements().addAll(selectedElements);
    }

    protected GraphicalEditPart createEditPart() {
        return new DiagramEditPart(this, (ReferenceCollection)this.getContent());
    }

    public DiagramImpl getDiagram() {
        return this;
    }

    public void deferRefresh(DiagramElement element) {
        this.deferRefresh(element, true, false);
    }

    public void deferRefresh(DiagramElement element, boolean selectForLayout, boolean wasReshaped) {
        if (!this.getDeferredElements().contains(element)) {
            this.getDeferredElements().add(element);
        }
        if (selectForLayout && (element instanceof DiagramLink || !((NodeEditPart)element.getEditPart()).isInner()) && !this.isJustLayouted(element)) {
            this.getElementsSelectedForLayout().add(element);
        }
        if (wasReshaped && !this.isJustLayouted(element)) {
            this.getReshapedElementsForLayout().add(element);
        }
    }

    public void undoRefresh(DiagramElement element) {
        this.getDeferredElements().remove(element);
        this.getElementsSelectedForLayout().remove(element);
        this.getReshapedElementsForLayout().remove(element);
    }

    public void registerLink(Reference referenceToLink, Participant[] edges) {
        this.getRegisteredReferencesToLinks().put(referenceToLink, edges);
    }

    public void updateRegisteredLinks() {
        Iterator it = this.getRegisteredReferencesToLinks().keySet().iterator();
        while (it.hasNext()) {
            Participant[] updatedEdges;
            Reference referenceToLink = (Reference)it.next();
            if (referenceToLink.getEntity().isDeleted() || Boolean.TRUE.toString().equals(referenceToLink.getPropertyValue("$hiddenWithOptions"))) {
                it.remove();
                continue;
            }
            Participant[] edges = (Participant[])this.getRegisteredReferencesToLinks().get(referenceToLink);
            if (edges == null || edges[0] != null && edges[1] != null || (updatedEdges = NodeLinkResolver.getInstance().isRepresentedByLink(referenceToLink)) == null) continue;
            edges[0] = updatedEdges[0];
            edges[1] = updatedEdges[1];
        }
    }

    public void processRegisteredLinks() {
        Iterator it = this.getRegisteredReferencesToLinks().keySet().iterator();
        while (it.hasNext()) {
            Reference referenceToLink = (Reference)it.next();
            ReferenceUniqueName referenceToLinkUin = (ReferenceUniqueName)referenceToLink.getUniqueName();
            Entity modelLink = referenceToLink.getEntity();
            DiagramElement source = null;
            DiagramElement target = null;
            Participant[] edges = (Participant[])this.getRegisteredReferencesToLinks().get(referenceToLink);
            if (edges != null && edges[0] != null) {
                source = this.getDeepElementsCache().getByEntityUin(edges[0].getUniqueName());
            }
            if (source != null && edges != null && edges[1] != null) {
                target = edges[1].getPropertyValue("$name") != null ? this.resolveLinkTarget(edges[1]) : this.getDeepElementsCache().getByEntityUin(edges[1].getUniqueName());
            }
            if (source instanceof DiagramNode && target != null) {
                if (((DiagramNode)source).getNodeEditPart().isInner() || target instanceof DiagramNode && ((DiagramNode)target).getNodeEditPart().isInner()) continue;
                DiagramLink link = (DiagramLink)DiagramFactory.createLink((IUpdatableNode)((DiagramNode)source), (IUpdatableElement)target, (Reference)referenceToLink);
                ((DiagramNode)target).add(link, true);
                ((DiagramNode)target).getNodeEditPart().addLinkAsTarget((ConnectionEditPart)link.getLinkEditPart());
                ((DiagramNode)source).add(link, true);
                ((DiagramNode)source).getNodeEditPart().addLinkAsSource((ConnectionEditPart)link.getLinkEditPart());
                link.adjustSize();
                this.getDeepElementsCache().put(referenceToLinkUin, link);
                this.getDisplayedLinks().add(link);
                if (this.myLinksToUpdate == null) {
                    this.myLinksToUpdate = new ArrayList();
                }
                this.deferRefresh(link, false, true);
                it.remove();
            }
            if (source != null) continue;
            it.remove();
        }
    }

    public IUpdatableElement findDiagramElement(Reference reference) {
        return this.findDiagramElement((ReferenceUniqueName)reference.getUniqueName());
    }

    public IUpdatableElement findDiagramElement(ReferenceUniqueName uin) {
        return this.getDeepElementsCache().getByReferenceUin(uin);
    }

    public IUpdatableElement findByEntityUin(UniqueName entityUin) {
        return this.getDeepElementsCache().getByEntityUin(entityUin);
    }

    void registerElement(DiagramElement diagramElement) {
        if (diagramElement.getContent() instanceof ReferenceCollection) {
            return;
        }
        Reference content = (Reference)diagramElement.getContent();
        ReferenceUniqueName referenceUin = (ReferenceUniqueName)content.getUniqueName();
        this.getDeepElementsCache().put(referenceUin, diagramElement);
    }

    void unregisterElement(DiagramElement diagramElement) {
        Reference content = (Reference)diagramElement.getContent();
        ReferenceUniqueName referenceUin = (ReferenceUniqueName)content.getUniqueName();
        DiagramElement removed = this.getDeepElementsCache().remove(referenceUin);
        if (removed != diagramElement) {
            System.err.println("unknow element was removed: shouldbe: " + diagramElement + "\n\t but was: " + removed);
        }
        Revisit.revisit();
    }

    private String getToolTipText() {
        ReferenceCollection rc = (ReferenceCollection)this.getContent();
        String metaclass = rc.getPropertyValue("$metaclass");
        String result = "";
        if ("Package Diagram".equals(metaclass)) {
            result = rc.getParent().getPropertyValue("$fullName");
            if (result == null || "".equals(result.trim())) {
                result = "(default package)";
            }
        } else {
            result = rc.getParent().getPropertyValue("$fullName");
            result = result != null && result.length() > 0 ? result + "." + rc.getPropertyValue("$name") : rc.getPropertyValue("$name");
        }
        return result;
    }

    private DiagramElement resolveLinkTarget(Participant target) {
        String name = target.getPropertyValue("$name");
        if (!this.myTopLevelClasses.containsKey(name)) {
            return null;
        }
        List possibleTargets = (List)this.myTopLevelClasses.get(name);
        DiagramImpl.removeAllDisposedTargets(possibleTargets);
        String fullName = target.getPropertyValue("$fullName");
        if (fullName != null) {
            Iterator targets = possibleTargets.iterator();
            while (targets.hasNext()) {
                DiagramElement possibleTarget = (DiagramElement)targets.next();
                if (!fullName.equals(((Reference)possibleTarget.getContent()).getEntity().getPropertyValue("$fullName"))) continue;
                return possibleTarget;
            }
            return null;
        }
        UniqueName uniqueName = target.getUniqueName();
        if (uniqueName == null) {
            return null;
        }
        Iterator targets = possibleTargets.iterator();
        while (targets.hasNext()) {
            DiagramElement possibleTarget = (DiagramElement)targets.next();
            if (possibleTarget == null || !(possibleTarget.getContent() instanceof Reference) || !uniqueName.equals(((Reference)possibleTarget.getContent()).getEntity().getUniqueName())) continue;
            return possibleTarget;
        }
        return null;
    }

    private static boolean isDisposed(DiagramElement topLevelDiagramElement) {
        GraphicalEditPart ep = topLevelDiagramElement.getEditPart();
        return ep == null || ep.getParent() == null;
    }

    private static void removeAllDisposedTargets(List list) {
        Iterator all = list.iterator();
        while (all.hasNext()) {
            DiagramElement mayBeDisposed = (DiagramElement)all.next();
            if (!DiagramImpl.isDisposed(mayBeDisposed)) continue;
            all.remove();
        }
    }

    private List getDeferredElements() {
        if (this.myDeferredElements == null) {
            this.myDeferredElements = new LinkedList();
        }
        return this.myDeferredElements;
    }

    private Map getRegisteredReferencesToLinks() {
        if (this.myRegisteredReferencesToLinks == null) {
            this.myRegisteredReferencesToLinks = new HashMap();
        }
        return this.myRegisteredReferencesToLinks;
    }

    private List getDisplayedLinks() {
        if (this.myDisplayedLinks == null) {
            this.myDisplayedLinks = new ArrayList();
        }
        return this.myDisplayedLinks;
    }

    private HashSet getElementsSelectedForLayout() {
        if (this.myElementsSelectedForLayout == null) {
            this.myElementsSelectedForLayout = new HashSet();
        }
        return this.myElementsSelectedForLayout;
    }

    private HashSet getReshapedElementsForLayout() {
        if (this.myReshapedElementsForLayout == null) {
            this.myReshapedElementsForLayout = new HashSet();
        }
        return this.myReshapedElementsForLayout;
    }

    private HashSet getReshapedElements() {
        if (this.myReshapedElements == null) {
            this.myReshapedElements = new HashSet();
        }
        return this.myReshapedElements;
    }

    private DeepElementsCache getDeepElementsCache() {
        if (this.myDeepElementsCache == null) {
            this.myDeepElementsCache = new DeepElementsCache();
        }
        return this.myDeepElementsCache;
    }

    private static boolean areStringsEquals(String one, String two) {
        if (one == null || two == null) {
            return one == two;
        }
        return one.equals(two);
    }

    public boolean containsClass(String shortOrFullName) {
        if (shortOrFullName != null && shortOrFullName.indexOf(46) >= 0) {
            List possibleClasses = (List)this.myTopLevelClasses.get(shortOrFullName.substring(shortOrFullName.lastIndexOf(46) + 1));
            if (possibleClasses == null) {
                return false;
            }
            Iterator elements = possibleClasses.iterator();
            while (elements.hasNext()) {
                DiagramElement element = (DiagramElement)elements.next();
                if (!shortOrFullName.equals(((Reference)element.getContent()).getEntity().getPropertyValue("$fullName"))) continue;
                return true;
            }
            return false;
        }
        return this.myTopLevelClasses.containsKey(shortOrFullName);
    }

    public void add(IUpdatableNode newChild) {
        super.add(newChild);
        if (this.myTopLevelClasses == null) {
            this.myTopLevelClasses = new HashMap();
        }
        if ("Class".equals(newChild.getContent().getPropertyValue("$metaclass"))) {
            String name = newChild.getContent().getPropertyValue("$name");
            if (!this.myTopLevelClasses.containsKey(name)) {
                this.myTopLevelClasses.put(name, new ArrayList());
            }
            ((List)this.myTopLevelClasses.get(name)).add(newChild);
        }
    }

    public IUpdatableElement remove(IUpdatableElement childToDelete) {
        String name;
        if (this.myTopLevelClasses != null && "Class".equals(childToDelete.getContent().getPropertyValue("$metaclass")) && this.myTopLevelClasses.containsKey(name = childToDelete.getContent().getPropertyValue("$name"))) {
            List list = (List)this.myTopLevelClasses.get(name);
            list.remove(childToDelete);
            if (list.size() == 0) {
                this.myTopLevelClasses.remove(name);
            }
        }
        return super.remove(childToDelete);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class DeepElementsCache {
        private Map myElements = new SafeUinHashMap(new HashMap());
        private Map myForeignElements = new HashMap();
        private Map myEntityUin2ReferenceUin = new HashMap();

        private DeepElementsCache() {
        }

        public DiagramElement getByReferenceUin(ReferenceUniqueName referenceUin) {
            DiagramElement result = (DiagramElement)this.myForeignElements.get(referenceUin);
            if (result != null) {
                return result;
            }
            result = (DiagramElement)this.myElements.get(referenceUin);
            return result;
        }

        public DiagramElement getByEntityUin(UniqueName entityUin) {
            Assert.isLegal((!(entityUin instanceof ReferenceUniqueName) ? 1 : 0) != 0, (String)"entityUin instanceof referenceUniqueName");
            ReferenceUniqueName referenceUin = (ReferenceUniqueName)this.myEntityUin2ReferenceUin.get(entityUin);
            if (referenceUin != null) {
                return (DiagramElement)this.myElements.get(referenceUin);
            }
            return null;
        }

        public DiagramElement remove(ReferenceUniqueName referenceUin) {
            DiagramElement result = (DiagramElement)this.myForeignElements.remove(referenceUin);
            if (result != null) {
                return result;
            }
            UniqueName entityUin = referenceUin.getReferencedUniqueName();
            result = (DiagramElement)this.myElements.remove(referenceUin);
            this.myEntityUin2ReferenceUin.remove(entityUin);
            return result;
        }

        public void put(ReferenceUniqueName referenceUin, DiagramElement diagramElement) {
            if (diagramElement.getParentNode() instanceof DiagramRCNode) {
                this.myForeignElements.put(referenceUin, diagramElement);
                return;
            }
            UniqueName entityUin = referenceUin.getReferencedUniqueName();
            this.myElements.put(referenceUin, diagramElement);
            this.myEntityUin2ReferenceUin.put(entityUin, referenceUin);
        }

        private void checkConsistency(ReferenceUniqueName referenceUin) {
            UniqueName entityUin = referenceUin.getReferencedUniqueName();
            Assert.isLegal((entityUin != null ? 1 : 0) != 0, (String)"referenceUin without entityUin");
            DiagramElement cachedByReferenceUin = (DiagramElement)this.myElements.get(referenceUin);
            ReferenceUniqueName cachedReferenceUin = (ReferenceUniqueName)this.myEntityUin2ReferenceUin.get(entityUin);
            if (cachedByReferenceUin == null && cachedReferenceUin != null) {
                String message = "key: " + referenceUin + "\t unknowReference but known Entity" + "\n\t entity:" + entityUin + "\n\t known reference: " + cachedReferenceUin;
                Assert.isLegal((boolean)false, (String)message);
            }
            Assert.isLegal((this.myElements.containsKey(referenceUin) == this.myEntityUin2ReferenceUin.containsKey(entityUin) ? 1 : 0) != 0, (String)("key: " + referenceUin + (this.myElements.containsKey(referenceUin) ? " knownReference" : " unknownReference") + " but " + (this.myEntityUin2ReferenceUin.containsKey(entityUin) ? "knownEntity" : "unknownEntity")));
            if (this.myEntityUin2ReferenceUin.containsKey(entityUin)) {
                Assert.isLegal((boolean)this.myEntityUin2ReferenceUin.get(entityUin).equals(referenceUin));
            }
        }
    }
}

