/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.internal;

import com.tssap.selena.gde.internal.GdePlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ProgressMonitorWrapper;

public class DebugProgressMonitor
extends ProgressMonitorWrapper {
    private long mySubTaskStart = -1L;
    private long myStart = -1L;
    private String mySubTask;
    private String myName;

    public DebugProgressMonitor(IProgressMonitor monitor) {
        super(monitor);
    }

    public void subTask(String name) {
        this.mySubTaskStart = System.currentTimeMillis();
        this.mySubTask = name;
        super.subTask(name);
    }

    public void worked(int work) {
        super.worked(work);
        if (this.mySubTaskStart != -1L) {
            DebugProgressMonitor.log(this.mySubTask + " : " + (System.currentTimeMillis() - this.mySubTaskStart) + " ms.");
        }
        this.mySubTaskStart = -1L;
    }

    public void beginTask(String name, int totalWork) {
        super.beginTask(name, totalWork);
        this.myStart = System.currentTimeMillis();
        this.myName = name;
    }

    public void done() {
        super.done();
        DebugProgressMonitor.log(this.myName + " : " + (System.currentTimeMillis() - this.myStart) + " ms.");
    }

    private static void log(String log) {
        if (GdePlugin.isLogEnabled()) {
            System.err.println("[gde.monitor]" + log);
        }
    }
}

