/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.internal;

import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.update.hierarchy.Revisit;
import java.util.Comparator;
import org.eclipse.gef.GraphicalEditPart;

public class ClassDiagramEditPartComparator
implements Comparator {
    public static final Comparator COMPARATOR_NAME = new ClassDiagramEditPartComparator(new String[]{"$name", "$memberSignature"}, new boolean[]{false, false});
    public static final Comparator COMPARATOR_ACCESS = new ClassDiagramEditPartComparator(new String[]{"$public", "$protected", "$private", "$name", "$memberSignature"}, new boolean[]{true, true, true, false, false});
    private int myLastValidIndex;
    private String[] myPropertyNames;
    private boolean[] myIsBooleanProperty;

    public ClassDiagramEditPartComparator(String[] propertyNames, boolean[] isBooleanPropertyFlags) {
        this.myLastValidIndex = Math.min(propertyNames.length, isBooleanPropertyFlags.length);
        this.myPropertyNames = propertyNames;
        this.myIsBooleanProperty = isBooleanPropertyFlags;
    }

    public int compare(Object o1, Object o2) {
        if (o1 instanceof GraphicalEditPart && o2 instanceof GraphicalEditPart) {
            return this.compareElements((Element)this.getContent((GraphicalEditPart)o1), (Element)this.getContent((GraphicalEditPart)o2));
        }
        Revisit.revisit();
        throw new IllegalStateException("JavaElementComparator: attempt to compare not graphical editparts: " + o1 + ", " + o2);
    }

    private Entity getContent(GraphicalEditPart ep) {
        if (ep.getModel() instanceof Reference) {
            return ((Reference)ep.getModel()).getEntity();
        }
        return null;
    }

    private int compareElements(Element element1, Element element2) {
        if (element1 == null) {
            return element2 == null ? 0 : -1;
        }
        if (element2 == null) {
            return 1;
        }
        int i = 0;
        while (i < this.myLastValidIndex) {
            int curDiff;
            String curPropertyName = this.myPropertyNames[i];
            if (this.myIsBooleanProperty[i]) {
                boolean hasProperty1 = element1.getPropertyValue(curPropertyName) != null;
                boolean hasProperty2 = element2.getPropertyValue(curPropertyName) != null;
                curDiff = this.compareBoolean(hasProperty1, hasProperty2);
            } else {
                String value1 = element1.getPropertyValue(curPropertyName);
                String value2 = element2.getPropertyValue(curPropertyName);
                curDiff = this.compareStrings(value1, value2);
            }
            if (curDiff != 0) {
                return curDiff;
            }
            ++i;
        }
        return 0;
    }

    private int compareStrings(String s1, String s2) {
        if (s1 == null) {
            return s2 == null ? 0 : -1;
        }
        if (s2 == null) {
            return 1;
        }
        return s1.compareTo(s2);
    }

    private int compareBoolean(boolean b1, boolean b2) {
        if (b1 && b2) {
            return 0;
        }
        if (!b1 && !b2) {
            return 0;
        }
        return b1 ? 1 : -1;
    }
}

