/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.IObjectActionContributor;
import org.eclipse.ui.internal.IObjectContributor;
import org.eclipse.ui.internal.ObjectActionContributorManager;

public class ActionContributorManager
extends ObjectActionContributorManager {
    private static final IObjectActionContributor[] EMPTY = new IObjectActionContributor[0];
    private static ActionContributorManager myInstance;
    private Map myContributorCache = new HashMap();

    protected ActionContributorManager() {
    }

    public static ActionContributorManager getInstance() {
        if (myInstance == null) {
            myInstance = new ActionContributorManager();
        }
        return myInstance;
    }

    public boolean contributeObjectActions(IWorkbenchPart part, MenuManager menu, ISelectionProvider provider) {
        List items;
        IObjectActionContributor[] contributors;
        IStructuredSelection selection;
        ISelection rawSelection = provider.getSelection();
        if (rawSelection instanceof IStructuredSelection && (selection = (IStructuredSelection)rawSelection).size() > 0 && (contributors = this.getContributors(items = selection.toList())) != null && contributors.length > 0) {
            boolean contributed = false;
            boolean[] applicabilityStatus = new boolean[contributors.length];
            int i = 0;
            while (i < contributors.length) {
                IObjectActionContributor contributor = contributors[i];
                applicabilityStatus[i] = this.isApplicableTo(selection, (IObjectContributor)contributor);
                if (applicabilityStatus[i] && contributor.contributeObjectMenus((IMenuManager)menu, provider)) {
                    contributed = true;
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < contributors.length) {
                IObjectActionContributor contributor = contributors[i2];
                if (applicabilityStatus[i2] && contributor.contributeObjectActions(part, (IMenuManager)menu, provider, new ArrayList())) {
                    contributed = true;
                }
                ++i2;
            }
            return contributed;
        }
        return false;
    }

    public boolean isCacheEnabled() {
        return this.myContributorCache != null;
    }

    public void setCacheEnabled(boolean flag) {
        if (flag != this.isCacheEnabled()) {
            this.myContributorCache = flag ? new HashMap() : null;
        }
    }

    private IObjectActionContributor[] getContributors(List selection) {
        if (this.myContributorCache != null) {
            HashSet key = new HashSet();
            Iterator elements = selection.iterator();
            while (elements.hasNext()) {
                key.add(elements.next().getClass());
            }
            IObjectActionContributor[] contributors = (IObjectActionContributor[])this.myContributorCache.get(key);
            if (contributors == null) {
                contributors = this.createContributors(selection);
                this.myContributorCache.put(key, contributors);
            }
            return contributors;
        }
        return this.createContributors(selection);
    }

    private IObjectActionContributor[] createContributors(List selection) {
        HashSet contributors = new HashSet();
        Iterator elements = selection.iterator();
        while (elements.hasNext()) {
            Class<?> elementClass = elements.next().getClass();
            List elementContributors = this.getContributors(elementClass);
            if (elementContributors == null) continue;
            if (contributors.isEmpty()) {
                contributors.addAll(elementContributors);
                continue;
            }
            Iterator iter = contributors.iterator();
            while (iter.hasNext()) {
                IObjectActionContributor contributor = (IObjectActionContributor)iter.next();
                if (elementContributors.contains(contributor)) continue;
                iter.remove();
            }
        }
        if (contributors.size() > 0) {
            IObjectActionContributor[] arr = new IObjectActionContributor[contributors.size()];
            return contributors.toArray(arr);
        }
        return EMPTY;
    }
}

