/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde.figures;

import com.tssap.selena.gde.figures.GridBagConstraints;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;

public class GridBagLayout
extends AbstractLayout {
    protected static final int MAXGRIDSIZE = 512;
    protected static final int MINSIZE = 1;
    protected static final int PREFERREDSIZE = 2;
    private int[] columnWidths;
    private int[] rowHeights;
    private double[] columnWeights;
    private double[] rowWeights;
    protected Hashtable comptable = new Hashtable();
    protected GridBagConstraints defaultConstraints = new GridBagConstraints();
    protected GridBagLayoutInfo layoutInfo;

    public void layout(IFigure parent) {
        this.ArrangeGrid(parent);
    }

    public void setConstraint(IFigure comp, Object constraints) {
        super.setConstraint(comp, constraints);
        if (constraints instanceof GridBagConstraints) {
            this.comptable.put(comp, ((GridBagConstraints)constraints).clone());
        }
    }

    public Object getConstraint(IFigure child) {
        return this.comptable.get(child);
    }

    protected GridBagConstraints lookupConstraints(IFigure comp) {
        GridBagConstraints constraints = (GridBagConstraints)this.comptable.get(comp);
        if (constraints == null) {
            this.setConstraint(comp, this.defaultConstraints);
            constraints = (GridBagConstraints)this.comptable.get(comp);
        }
        return constraints;
    }

    protected GridBagLayoutInfo GetLayoutInfo(IFigure parent, int sizeflag) {
        int py;
        int i;
        int px;
        int curHeight;
        int curWidth;
        int curY;
        int curX;
        GridBagConstraints constraints;
        IFigure comp;
        GridBagLayoutInfo r = new GridBagLayoutInfo();
        List children = parent.getChildren();
        r.width = 0;
        r.height = 0;
        int curRow = -1;
        int curCol = -1;
        int[] xMax = new int[512];
        int[] yMax = new int[512];
        int compindex = 0;
        while (compindex < children.size()) {
            comp = (IFigure)children.get(compindex);
            if (comp.isVisible()) {
                constraints = this.lookupConstraints(comp);
                curX = constraints.gridx;
                curY = constraints.gridy;
                curWidth = constraints.gridwidth;
                if (curWidth <= 0) {
                    curWidth = 1;
                }
                if ((curHeight = constraints.gridheight) <= 0) {
                    curHeight = 1;
                }
                if (curX < 0 && curY < 0) {
                    if (curRow >= 0) {
                        curY = curRow;
                    } else if (curCol >= 0) {
                        curX = curCol;
                    } else {
                        curY = 0;
                    }
                }
                if (curX < 0) {
                    px = 0;
                    i = curY;
                    while (i < curY + curHeight) {
                        px = Math.max(px, xMax[i]);
                        ++i;
                    }
                    if ((curX = px - curX - 1) < 0) {
                        curX = 0;
                    }
                } else if (curY < 0) {
                    py = 0;
                    i = curX;
                    while (i < curX + curWidth) {
                        py = Math.max(py, yMax[i]);
                        ++i;
                    }
                    if ((curY = py - curY - 1) < 0) {
                        curY = 0;
                    }
                }
                px = curX + curWidth;
                while (r.width < px) {
                    ++r.width;
                }
                py = curY + curHeight;
                while (r.height < py) {
                    ++r.height;
                }
                i = curX;
                while (i < curX + curWidth) {
                    yMax[i] = py;
                    ++i;
                }
                i = curY;
                while (i < curY + curHeight) {
                    xMax[i] = px;
                    ++i;
                }
                Dimension d = sizeflag == 2 ? comp.getPreferredSize() : comp.getMinimumSize();
                constraints.minWidth = d.width;
                constraints.minHeight = d.height;
                if (constraints.gridheight == 0 && constraints.gridwidth == 0) {
                    curRow = -1;
                    curCol = -1;
                }
                if (constraints.gridheight == 0 && curRow < 0) {
                    curCol = curX + curWidth;
                } else if (constraints.gridwidth == 0 && curCol < 0) {
                    curRow = curY + curHeight;
                }
            }
            ++compindex;
        }
        if (this.columnWidths != null && r.width < this.columnWidths.length) {
            r.width = this.columnWidths.length;
        }
        if (this.rowHeights != null && r.height < this.rowHeights.length) {
            r.height = this.rowHeights.length;
        }
        curRow = -1;
        curCol = -1;
        xMax = new int[512];
        yMax = new int[512];
        compindex = 0;
        while (compindex < children.size()) {
            comp = (IFigure)children.get(compindex);
            if (comp.isVisible()) {
                constraints = this.lookupConstraints(comp);
                curX = constraints.gridx;
                curY = constraints.gridy;
                curWidth = constraints.gridwidth;
                curHeight = constraints.gridheight;
                if (curX < 0 && curY < 0) {
                    if (curRow >= 0) {
                        curY = curRow;
                    } else if (curCol >= 0) {
                        curX = curCol;
                    } else {
                        curY = 0;
                    }
                }
                if (curX < 0) {
                    if (curHeight <= 0 && (curHeight += r.height - curY) < 1) {
                        curHeight = 1;
                    }
                    px = 0;
                    i = curY;
                    while (i < curY + curHeight) {
                        px = Math.max(px, xMax[i]);
                        ++i;
                    }
                    if ((curX = px - curX - 1) < 0) {
                        curX = 0;
                    }
                } else if (curY < 0) {
                    if (curWidth <= 0 && (curWidth += r.width - curX) < 1) {
                        curWidth = 1;
                    }
                    py = 0;
                    i = curX;
                    while (i < curX + curWidth) {
                        py = Math.max(py, yMax[i]);
                        ++i;
                    }
                    if ((curY = py - curY - 1) < 0) {
                        curY = 0;
                    }
                }
                if (curWidth <= 0 && (curWidth += r.width - curX) < 1) {
                    curWidth = 1;
                }
                if (curHeight <= 0 && (curHeight += r.height - curY) < 1) {
                    curHeight = 1;
                }
                px = curX + curWidth;
                py = curY + curHeight;
                i = curX;
                while (i < curX + curWidth) {
                    yMax[i] = py;
                    ++i;
                }
                i = curY;
                while (i < curY + curHeight) {
                    xMax[i] = px;
                    ++i;
                }
                if (constraints.gridheight == 0 && constraints.gridwidth == 0) {
                    curRow = -1;
                    curCol = -1;
                }
                if (constraints.gridheight == 0 && curRow < 0) {
                    curCol = curX + curWidth;
                } else if (constraints.gridwidth == 0 && curCol < 0) {
                    curRow = curY + curHeight;
                }
                constraints.tempX = curX;
                constraints.tempY = curY;
                constraints.tempWidth = curWidth;
                constraints.tempHeight = curHeight;
            }
            ++compindex;
        }
        if (this.columnWidths != null) {
            System.arraycopy(this.columnWidths, 0, r.minWidth, 0, this.columnWidths.length);
        }
        if (this.rowHeights != null) {
            System.arraycopy(this.rowHeights, 0, r.minHeight, 0, this.rowHeights.length);
        }
        if (this.columnWeights != null) {
            System.arraycopy(this.columnWeights, 0, r.weightX, 0, this.columnWeights.length);
        }
        if (this.rowWeights != null) {
            System.arraycopy(this.rowWeights, 0, r.weightY, 0, this.rowWeights.length);
        }
        int nextSize = Integer.MAX_VALUE;
        i = 1;
        while (i != Integer.MAX_VALUE) {
            compindex = 0;
            while (compindex < children.size()) {
                comp = (IFigure)children.get(compindex);
                if (comp.isVisible()) {
                    int pixels_diff;
                    double wt;
                    double weight;
                    int k;
                    double weight_diff;
                    constraints = this.lookupConstraints(comp);
                    if (constraints.tempWidth == i) {
                        px = constraints.tempX + constraints.tempWidth;
                        weight_diff = constraints.weightx;
                        k = constraints.tempX;
                        while (k < px) {
                            weight_diff -= r.weightX[k];
                            ++k;
                        }
                        if (weight_diff > 0.0) {
                            weight = 0.0;
                            k = constraints.tempX;
                            while (k < px) {
                                weight += r.weightX[k];
                                ++k;
                            }
                            k = constraints.tempX;
                            while (weight > 0.0 && k < px) {
                                wt = r.weightX[k];
                                double dx = wt * weight_diff / weight;
                                int n = k++;
                                r.weightX[n] = r.weightX[n] + dx;
                                weight_diff -= dx;
                                weight -= wt;
                            }
                            int n = px - 1;
                            r.weightX[n] = r.weightX[n] + weight_diff;
                        }
                        pixels_diff = constraints.minWidth + constraints.ipadx + constraints.insets.left + constraints.insets.right;
                        k = constraints.tempX;
                        while (k < px) {
                            pixels_diff -= r.minWidth[k];
                            ++k;
                        }
                        if (pixels_diff > 0) {
                            weight = 0.0;
                            k = constraints.tempX;
                            while (k < px) {
                                weight += r.weightX[k];
                                ++k;
                            }
                            k = constraints.tempX;
                            while (weight > 0.0 && k < px) {
                                wt = r.weightX[k];
                                int dx = (int)(wt * (double)pixels_diff / weight);
                                int n = k++;
                                r.minWidth[n] = r.minWidth[n] + dx;
                                pixels_diff -= dx;
                                weight -= wt;
                            }
                            int n = px - 1;
                            r.minWidth[n] = r.minWidth[n] + pixels_diff;
                        }
                    } else if (constraints.tempWidth > i && constraints.tempWidth < nextSize) {
                        nextSize = constraints.tempWidth;
                    }
                    if (constraints.tempHeight == i) {
                        py = constraints.tempY + constraints.tempHeight;
                        weight_diff = constraints.weighty;
                        k = constraints.tempY;
                        while (k < py) {
                            weight_diff -= r.weightY[k];
                            ++k;
                        }
                        if (weight_diff > 0.0) {
                            weight = 0.0;
                            k = constraints.tempY;
                            while (k < py) {
                                weight += r.weightY[k];
                                ++k;
                            }
                            k = constraints.tempY;
                            while (weight > 0.0 && k < py) {
                                wt = r.weightY[k];
                                double dy = wt * weight_diff / weight;
                                int n = k++;
                                r.weightY[n] = r.weightY[n] + dy;
                                weight_diff -= dy;
                                weight -= wt;
                            }
                            int n = py - 1;
                            r.weightY[n] = r.weightY[n] + weight_diff;
                        }
                        pixels_diff = constraints.minHeight + constraints.ipady + constraints.insets.top + constraints.insets.bottom;
                        k = constraints.tempY;
                        while (k < py) {
                            pixels_diff -= r.minHeight[k];
                            ++k;
                        }
                        if (pixels_diff > 0) {
                            weight = 0.0;
                            k = constraints.tempY;
                            while (k < py) {
                                weight += r.weightY[k];
                                ++k;
                            }
                            k = constraints.tempY;
                            while (weight > 0.0 && k < py) {
                                wt = r.weightY[k];
                                int dy = (int)(wt * (double)pixels_diff / weight);
                                int n = k++;
                                r.minHeight[n] = r.minHeight[n] + dy;
                                pixels_diff -= dy;
                                weight -= wt;
                            }
                            int n = py - 1;
                            r.minHeight[n] = r.minHeight[n] + pixels_diff;
                        }
                    } else if (constraints.tempHeight > i && constraints.tempHeight < nextSize) {
                        nextSize = constraints.tempHeight;
                    }
                }
                ++compindex;
            }
            i = nextSize;
            nextSize = Integer.MAX_VALUE;
        }
        return r;
    }

    protected Dimension GetMinSize(IFigure parent, GridBagLayoutInfo info) {
        Dimension d = new Dimension();
        Insets insets = parent.getInsets();
        int t = 0;
        int i = 0;
        while (i < info.width) {
            t += info.minWidth[i];
            ++i;
        }
        d.width = t + insets.left + insets.right;
        t = 0;
        i = 0;
        while (i < info.height) {
            t += info.minHeight[i];
            ++i;
        }
        d.height = t + insets.top + insets.bottom;
        return d;
    }

    protected void ArrangeGrid(IFigure parent) {
        int i;
        double weight;
        Insets insets = parent.getInsets();
        List children = parent.getChildren();
        Rectangle r = new Rectangle();
        if (!(children.size() != 0 || this.columnWidths != null && this.columnWidths.length != 0 || this.rowHeights != null && this.rowHeights.length != 0)) {
            return;
        }
        GridBagLayoutInfo info = this.GetLayoutInfo(parent, 2);
        Dimension d = this.GetMinSize(parent, info);
        if (parent.getSize().width < d.width || parent.getSize().height < d.height) {
            info = this.GetLayoutInfo(parent, 1);
            d = this.GetMinSize(parent, info);
        }
        this.layoutInfo = info;
        r.width = d.width;
        r.height = d.height;
        int diffw = parent.getSize().width - r.width;
        if (diffw != 0) {
            weight = 0.0;
            i = 0;
            while (i < info.width) {
                weight += info.weightX[i];
                ++i;
            }
            if (weight > 0.0) {
                i = 0;
                while (i < info.width) {
                    int dx = (int)((double)diffw * info.weightX[i] / weight);
                    int n = i;
                    info.minWidth[n] = info.minWidth[n] + dx;
                    r.width += dx;
                    if (info.minWidth[i] < 0) {
                        r.width -= info.minWidth[i];
                        info.minWidth[i] = 0;
                    }
                    ++i;
                }
            }
            diffw = parent.getSize().width - r.width;
        } else {
            diffw = 0;
        }
        int diffh = parent.getSize().height - r.height;
        if (diffh != 0) {
            weight = 0.0;
            i = 0;
            while (i < info.height) {
                weight += info.weightY[i];
                ++i;
            }
            if (weight > 0.0) {
                i = 0;
                while (i < info.height) {
                    int dy = (int)((double)diffh * info.weightY[i] / weight);
                    int n = i;
                    info.minHeight[n] = info.minHeight[n] + dy;
                    r.height += dy;
                    if (info.minHeight[i] < 0) {
                        r.height -= info.minHeight[i];
                        info.minHeight[i] = 0;
                    }
                    ++i;
                }
            }
            diffh = parent.getSize().height - r.height;
        } else {
            diffh = 0;
        }
        info.startx = diffw / 2 + insets.left;
        info.starty = diffh / 2 + insets.top;
        int compindex = 0;
        while (compindex < children.size()) {
            IFigure comp = (IFigure)children.get(compindex);
            if (comp.isVisible()) {
                GridBagConstraints constraints = this.lookupConstraints(comp);
                r.x = info.startx;
                i = 0;
                while (i < constraints.tempX) {
                    r.x += info.minWidth[i];
                    ++i;
                }
                r.y = info.starty;
                i = 0;
                while (i < constraints.tempY) {
                    r.y += info.minHeight[i];
                    ++i;
                }
                r.width = 0;
                i = constraints.tempX;
                while (i < constraints.tempX + constraints.tempWidth) {
                    r.width += info.minWidth[i];
                    ++i;
                }
                r.height = 0;
                i = constraints.tempY;
                while (i < constraints.tempY + constraints.tempHeight) {
                    r.height += info.minHeight[i];
                    ++i;
                }
                this.AdjustForGravity(constraints, r);
                if (r.width <= 0 || r.height <= 0) {
                    comp.setBounds(new Rectangle(0, 0, 0, 0));
                } else if (comp.getClientArea().x != r.x || comp.getClientArea().y != r.y || comp.getClientArea().width != r.width || comp.getClientArea().height != r.height) {
                    comp.setBounds(new Rectangle(r.x + parent.getClientArea().x, r.y + parent.getClientArea().y, r.width, r.height));
                }
            }
            ++compindex;
        }
    }

    protected void AdjustForGravity(GridBagConstraints constraints, Rectangle r) {
        r.x += constraints.insets.left;
        r.width -= constraints.insets.left + constraints.insets.right;
        r.y += constraints.insets.top;
        r.height -= constraints.insets.top + constraints.insets.bottom;
        int diffx = 0;
        if (constraints.fill != 2 && constraints.fill != 1 && r.width > constraints.minWidth + constraints.ipadx) {
            diffx = r.width - (constraints.minWidth + constraints.ipadx);
            r.width = constraints.minWidth + constraints.ipadx;
        }
        int diffy = 0;
        if (constraints.fill != 3 && constraints.fill != 1 && r.height > constraints.minHeight + constraints.ipady) {
            diffy = r.height - (constraints.minHeight + constraints.ipady);
            r.height = constraints.minHeight + constraints.ipady;
        }
        switch (constraints.anchor) {
            case 10: {
                r.x += diffx / 2;
                r.y += diffy / 2;
                break;
            }
            case 11: {
                r.x += diffx / 2;
                break;
            }
            case 12: {
                r.x += diffx;
                break;
            }
            case 13: {
                r.x += diffx;
                r.y += diffy / 2;
                break;
            }
            case 14: {
                r.x += diffx;
                r.y += diffy;
                break;
            }
            case 15: {
                r.x += diffx / 2;
                r.y += diffy;
                break;
            }
            case 16: {
                r.y += diffy;
                break;
            }
            case 17: {
                r.y += diffy / 2;
                break;
            }
            case 18: {
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal anchor value");
            }
        }
    }

    protected Dimension calculatePreferredSize(IFigure figure) {
        GridBagLayoutInfo info = this.GetLayoutInfo(figure, 2);
        return this.GetMinSize(figure, info);
    }

    static class GridBagLayoutInfo {
        int width;
        int height;
        int startx;
        int starty;
        int[] minWidth = new int[512];
        int[] minHeight = new int[512];
        double[] weightX = new double[512];
        double[] weightY = new double[512];

        GridBagLayoutInfo() {
        }
    }
}

